/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.DirectoryException;

@XObject(value="server")
public class LDAPServerDescriptor {
    @XNode(value="@name")
    public String name;
    public String ldapUrls;
    public String bindDn;
    @XNode(value="connectionTimeout")
    public int connectionTimeout = 10000;
    @XNode(value="poolingEnabled")
    public boolean poolingEnabled = true;
    public String bindPassword = "";

    public String getName() {
        return this.name;
    }

    @XNode(value="bindDn")
    public void setBindDn(String bindDn) {
        this.bindDn = null != bindDn && bindDn.trim().equals("") ? null : bindDn;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    @XNode(value="bindPassword")
    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword == null ? "" : bindPassword;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public String getLdapUrls() {
        return this.ldapUrls;
    }

    @XNodeList(value="ldapUrl", componentType=String.class, type=String[].class)
    public void setLdapUrls(String[] ldapUrls) throws DirectoryException {
        if (ldapUrls == null) {
            throw new DirectoryException("At least one <ldapUrl/> server declaration is required");
        }
        this.ldapUrls = StringUtils.join((Object[])ldapUrls, (String)" ");
    }

    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

