/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.ArrayFragment;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.db.Column;

public class ACLsFragment
extends ArrayFragment {
    private static final long serialVersionUID = 1L;
    protected static final CollectionFragment.CollectionMaker MAKER = new CollectionFragment.CollectionMaker(){
        public final ACLRow[] EMPTY_ACL_ROWS = new ACLRow[0];

        @Override
        public Serializable[] makeArray(ResultSet rs, List<Column> columns, Context context, Model model) throws SQLException {
            ArrayList<ACLRow> list = new ArrayList<ACLRow>();
            while (rs.next()) {
                list.add(this.getValue(rs, columns, model, null));
            }
            return list.toArray(new ACLRow[list.size()]);
        }

        @Override
        public Map<Serializable, Serializable[]> makeArrays(ResultSet rs, List<Column> columns, Context context, Model model) throws SQLException {
            HashMap<Serializable, Serializable[]> res = new HashMap<Serializable, Serializable[]>();
            Serializable id = null;
            ArrayList<ACLRow> list = null;
            Serializable[] returnId = new Serializable[1];
            while (rs.next()) {
                ACLRow value = this.getValue(rs, columns, model, returnId);
                Serializable newId = returnId[0];
                if (newId != null && !newId.equals(id)) {
                    if (list != null) {
                        res.put(id, list.toArray(new ACLRow[list.size()]));
                    }
                    id = newId;
                    list = new ArrayList<ACLRow>();
                }
                list.add(value);
            }
            if (id != null && list != null) {
                res.put(id, list.toArray(new ACLRow[list.size()]));
            }
            return res;
        }

        private ACLRow getValue(ResultSet rs, List<Column> columns, Model model, Serializable[] returnId) throws SQLException {
            int pos = 0;
            String name = null;
            boolean grant = false;
            String permission = null;
            String user = null;
            String group = null;
            int i = 0;
            for (Column column : columns) {
                String key = column.getKey();
                Serializable v = column.getFromResultSet(rs, ++i);
                if (key.equals("pos")) {
                    pos = v == null ? 0 : ((Long)v).intValue();
                    continue;
                }
                if (key.equals("name")) {
                    name = (String)((Object)v);
                    continue;
                }
                if (key.equals("grant")) {
                    grant = v == null ? false : (Boolean)v;
                    continue;
                }
                if (key.equals("permission")) {
                    permission = (String)((Object)v);
                    continue;
                }
                if (key.equals("user")) {
                    user = (String)((Object)v);
                    continue;
                }
                if (key.equals("group")) {
                    group = (String)((Object)v);
                    continue;
                }
                if (key.equals("id") && returnId != null) {
                    returnId[0] = v;
                    continue;
                }
                throw new RuntimeException(key);
            }
            return new ACLRow(pos, name, grant, permission, user, group);
        }

        @Override
        public CollectionFragment makeCollection(Serializable id, Serializable[] array, Context context) {
            return new ACLsFragment(id, Fragment.State.PRISTINE, context, array);
        }

        @Override
        public CollectionFragment makeEmpty(Serializable id, Context context, Model model) {
            return new ACLsFragment(id, Fragment.State.CREATED, context, this.EMPTY_ACL_ROWS);
        }
    };

    public ACLsFragment(Serializable id, Fragment.State state, Context context, Serializable[] acls) {
        super(id, state, context, acls);
    }

    protected CollectionFragment.CollectionFragmentIterator getIterator() {
        return new ACLsFragmentIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ACLsFragmentIterator
    extends ArrayFragment.ArrayFragmentIterator {
        protected ACLsFragmentIterator() {
            super(ACLsFragment.this);
        }

        @Override
        public void setToPreparedStatement(List<Column> columns, PreparedStatement ps, Model model, List<Serializable> debugValues) throws SQLException {
            ACLRow acl = (ACLRow)ACLsFragment.this.array[this.i];
            int n = 0;
            for (Column column : columns) {
                Object v;
                ++n;
                String key = column.getKey();
                if (key.equals("id")) {
                    v = ACLsFragment.this.getId();
                } else if (key.equals("pos")) {
                    v = (long)acl.pos;
                } else if (key.equals("name")) {
                    v = acl.name;
                } else if (key.equals("grant")) {
                    v = acl.grant;
                } else if (key.equals("permission")) {
                    v = acl.permission;
                } else if (key.equals("user")) {
                    v = acl.user;
                } else if (key.equals("group")) {
                    v = acl.group;
                } else {
                    throw new RuntimeException(key);
                }
                column.setToPreparedStatement(ps, n, (Serializable)v);
                if (debugValues == null) continue;
                debugValues.add((Serializable)v);
            }
        }
    }
}

