/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.db.Column;

public class ArrayFragment
extends CollectionFragment {
    private static final long serialVersionUID = 1L;
    protected Serializable[] array;
    protected static final CollectionFragment.CollectionMaker MAKER = new CollectionFragment.CollectionMaker(){

        @Override
        public Serializable[] makeArray(ResultSet rs, List<Column> columns, Context context, Model model) throws SQLException {
            Column column = null;
            for (Column col : columns) {
                if (!col.getKey().equals("item")) continue;
                column = col;
            }
            if (column == null) {
                throw new RuntimeException(columns.toString());
            }
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            while (rs.next()) {
                int i = 0;
                Serializable value = null;
                for (Column col : columns) {
                    ++i;
                    if (col != column) continue;
                    value = column.getFromResultSet(rs, i);
                }
                list.add(value);
            }
            return column.listToArray(list);
        }

        @Override
        public Map<Serializable, Serializable[]> makeArrays(ResultSet rs, List<Column> columns, Context context, Model model) throws SQLException {
            Column valueColumn = null;
            Column idColumn = null;
            for (Column column : columns) {
                String key = column.getKey();
                if (key.equals("id")) {
                    idColumn = column;
                    continue;
                }
                if (!key.equals("item")) continue;
                valueColumn = column;
            }
            if (valueColumn == null || idColumn == null) {
                throw new RuntimeException(columns.toString());
            }
            HashMap<Serializable, Serializable[]> res = new HashMap<Serializable, Serializable[]>();
            Object id = null;
            ArrayList<Serializable> list = null;
            while (rs.next()) {
                int i = 1;
                Object newId = null;
                Serializable value = null;
                for (Column column : columns) {
                    Serializable v = column.getFromResultSet(rs, i++);
                    if (column == idColumn) {
                        newId = v;
                        continue;
                    }
                    if (column != valueColumn) continue;
                    value = v;
                }
                if (newId != null && !newId.equals(id)) {
                    if (list != null) {
                        res.put((Serializable)id, valueColumn.listToArray((List<Serializable>)list));
                    }
                    id = newId;
                    list = new ArrayList<Serializable>();
                }
                list.add(value);
            }
            if (id != null && list != null) {
                res.put((Serializable)id, valueColumn.listToArray(list));
            }
            return res;
        }

        @Override
        public CollectionFragment makeCollection(Serializable id, Serializable[] array, Context context) {
            return new ArrayFragment(id, Fragment.State.PRISTINE, context, array);
        }

        @Override
        public CollectionFragment makeEmpty(Serializable id, Context context, Model model) {
            Serializable[] empty = model.getCollectionFragmentType(context.getTableName()).getEmptyArray();
            return new ArrayFragment(id, Fragment.State.CREATED, context, empty);
        }
    };

    public ArrayFragment(Serializable id, Fragment.State state, Context context, Serializable[] array) {
        super(id, state, context);
        assert (array != null);
        this.array = array;
    }

    protected Fragment.State refetch() throws StorageException {
        Context context = this.getContext();
        this.array = context.mapper.readCollectionArray(this.getId(), context);
        return Fragment.State.PRISTINE;
    }

    public void set(Serializable[] value) {
        this.array = (Serializable[])value.clone();
        this.markModified();
    }

    public Serializable[] get() throws StorageException {
        this.accessed();
        return (Serializable[])this.array.clone();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('(');
        buf.append(this.getTableName());
        buf.append(", id=");
        buf.append(this.getId());
        buf.append(", state=");
        buf.append((Object)this.getState());
        buf.append(", ");
        buf.append('[');
        for (int i = 0; i < this.array.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            Object value = this.array[i];
            boolean truncated = false;
            if (value instanceof String && ((String)value).length() > 100) {
                value = ((String)value).substring(0, 100);
                truncated = true;
            }
            buf.append(value);
            if (!truncated) continue;
            buf.append("...");
        }
        buf.append("])");
        return buf.toString();
    }

    protected CollectionFragment.CollectionFragmentIterator getIterator() {
        return new ArrayFragmentIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ArrayFragmentIterator
    implements CollectionFragment.CollectionFragmentIterator {
        protected int i = -1;

        @Override
        public boolean hasNext() {
            return ArrayFragment.this.array.length > this.i + 1;
        }

        @Override
        public Serializable next() {
            ++this.i;
            return ArrayFragment.this.array[this.i];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setToPreparedStatement(List<Column> columns, PreparedStatement ps, Model model, List<Serializable> debugValues) throws SQLException {
            int n = 0;
            for (Column column : columns) {
                Serializable v;
                ++n;
                String key = column.getKey();
                if (key.equals("id")) {
                    v = ArrayFragment.this.getId();
                } else if (key.equals("pos")) {
                    v = Long.valueOf(this.i);
                } else if (key.equals("item")) {
                    v = ArrayFragment.this.array[this.i];
                } else {
                    throw new RuntimeException(key);
                }
                column.setToPreparedStatement(ps, n, v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
        }
    }
}

