/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Children {
    private static final Log log = LogFactory.getLog(Children.class);
    protected final Context context;
    protected final String filterKey;
    protected boolean complete;
    protected List<Serializable> existing;
    protected List<Serializable> created;
    protected Set<Serializable> deleted;
    private final Serializable mapKey;
    private final Map<Serializable, Children> softMap;
    private final Map<Serializable, Children> hardMap;

    public Children(Context context, String filterKey, boolean empty, Serializable mapKey, Map<Serializable, Children> softMap, Map<Serializable, Children> hardMap) {
        this.context = context;
        this.filterKey = filterKey;
        this.complete = empty;
        this.mapKey = mapKey;
        this.softMap = softMap;
        this.hardMap = hardMap;
        softMap.put(mapKey, this);
    }

    protected Serializable fragmentValue(SimpleFragment fragment) {
        try {
            return fragment.get(this.filterKey);
        }
        catch (StorageException e) {
            log.error((Object)("Could not fetch value: " + fragment.getId()));
            return null;
        }
    }

    public void addExisting(Serializable id) {
        if (this.existing == null) {
            this.existing = new LinkedList<Serializable>();
        }
        if (this.existing.contains(id) || this.created != null && this.created.contains(id)) {
            log.error((Object)("Adding already present id: " + id));
            return;
        }
        this.existing.add(id);
    }

    public void addCreated(Serializable id) {
        if (this.created == null) {
            this.created = new LinkedList<Serializable>();
            this.softMap.remove(this.mapKey);
            this.hardMap.put(this.mapKey, this);
        }
        if (this.existing != null && this.existing.contains(id) || this.created.contains(id)) {
            log.error((Object)("Creating already present id: " + id));
            return;
        }
        this.created.add(id);
    }

    public void addExistingComplete(List<Serializable> actualExisting) {
        assert (!this.complete);
        this.complete = true;
        this.existing = actualExisting;
    }

    public void setIncomplete() {
        this.complete = false;
    }

    public void remove(Serializable id) {
        if (this.created != null && this.created.remove(id)) {
            return;
        }
        if (this.existing != null) {
            this.existing.remove(id);
        }
        if (this.deleted == null) {
            this.deleted = new HashSet<Serializable>();
            this.softMap.remove(this.mapKey);
            this.hardMap.put(this.mapKey, this);
        }
        this.deleted.add(id);
    }

    public void flush() {
        if (this.created != null) {
            if (this.existing == null) {
                this.existing = new LinkedList<Serializable>();
            }
            this.existing.addAll(this.created);
            this.created = null;
        }
        this.deleted = null;
        this.softMap.put(this.mapKey, this);
    }

    public boolean isFlushed() {
        return this.created == null && this.deleted == null;
    }

    public SimpleFragment getFragmentByValue(Serializable value) {
        SimpleFragment fragment;
        if (this.existing != null) {
            for (Serializable id : this.existing) {
                try {
                    fragment = (SimpleFragment)this.context.get(id, false);
                }
                catch (StorageException e) {
                    log.warn((Object)("Failed refetch for: " + id), (Throwable)((Object)e));
                    continue;
                }
                if (fragment == null) {
                    log.warn((Object)("Existing fragment missing: " + id));
                    continue;
                }
                if (!value.equals(this.fragmentValue(fragment))) continue;
                return fragment;
            }
        }
        if (this.created != null) {
            for (Serializable id : this.created) {
                fragment = (SimpleFragment)this.context.getIfPresent(id);
                if (fragment == null) {
                    log.warn((Object)("Created fragment missing: " + id));
                    continue;
                }
                if (!value.equals(this.fragmentValue(fragment))) continue;
                return fragment;
            }
        }
        if (this.deleted != null) {
            for (Serializable id : this.deleted) {
                fragment = (SimpleFragment)this.context.getIfPresent(id);
                if (fragment == null) {
                    log.warn((Object)("Deleted fragment missing: " + id));
                    continue;
                }
                if (!value.equals(this.fragmentValue(fragment))) continue;
                return null;
            }
        }
        return this.complete ? null : SimpleFragment.UNKNOWN;
    }

    public List<SimpleFragment> getFragmentsByValue(Serializable value) {
        SimpleFragment fragment;
        if (!this.complete) {
            return null;
        }
        LinkedList<SimpleFragment> filtered = new LinkedList<SimpleFragment>();
        if (this.existing != null) {
            for (Serializable id : this.existing) {
                try {
                    fragment = (SimpleFragment)this.context.get(id, false);
                }
                catch (StorageException e) {
                    log.warn((Object)("Failed refetch for: " + id), (Throwable)((Object)e));
                    continue;
                }
                if (fragment == null) {
                    log.warn((Object)("Existing fragment missing: " + id));
                    continue;
                }
                if (value != null && !value.equals(this.fragmentValue(fragment))) continue;
                filtered.add(fragment);
            }
        }
        if (this.created != null) {
            for (Serializable id : this.created) {
                fragment = (SimpleFragment)this.context.getIfPresent(id);
                if (fragment == null) {
                    log.warn((Object)("Created fragment missing: " + id));
                    continue;
                }
                if (value != null && !value.equals(this.fragmentValue(fragment))) continue;
                filtered.add(fragment);
            }
        }
        return filtered;
    }
}

