/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private static final Log log = LogFactory.getLog(Context.class);
    private final String tableName;
    private final int tableSize;
    protected final Mapper mapper;
    protected final Model model;
    protected final PersistenceContext persistenceContext;
    protected final Map<Serializable, Fragment> pristine;
    protected final Map<Serializable, Fragment> modified;
    private final Set<Serializable> modifiedInTransaction;
    private final Set<Serializable> deletedInTransaction;
    private final Set<Serializable> modifiedInvalidations;
    private final Set<Serializable> deletedInvalidations;
    protected final boolean isCollection;

    public Context(String tableName, Mapper mapper, PersistenceContext persistenceContext) {
        this.tableName = tableName;
        this.mapper = mapper;
        this.persistenceContext = persistenceContext;
        this.model = mapper.getModel();
        this.pristine = new ReferenceMap(0, 1);
        this.modified = new HashMap<Serializable, Fragment>();
        this.modifiedInTransaction = new HashSet<Serializable>();
        this.deletedInTransaction = new HashSet<Serializable>();
        this.modifiedInvalidations = new HashSet<Serializable>();
        this.deletedInvalidations = new HashSet<Serializable>();
        this.isCollection = this.model.isCollectionFragment(tableName);
        this.tableSize = mapper.getTableSize(tableName);
    }

    public String toString() {
        return "Context(" + this.tableName + ')';
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    protected int clearCaches() {
        int n = this.pristine.size();
        this.pristine.clear();
        this.modified.clear();
        this.modifiedInTransaction.clear();
        this.deletedInTransaction.clear();
        return n;
    }

    public void close() {
        this.detachAll();
    }

    private void detachAll() {
        for (Fragment fragment : this.modified.values()) {
            fragment.setDetached();
        }
        this.modified.clear();
    }

    public SimpleFragment create(Serializable id, Map<String, Serializable> map) throws StorageException {
        if (this.pristine.containsKey(id) || this.modified.containsKey(id)) {
            throw new IllegalStateException("Row already registered: " + id);
        }
        return new SimpleFragment(id, Fragment.State.CREATED, this, map);
    }

    public Fragment get(Serializable id, boolean allowAbsent) throws StorageException {
        Fragment fragment = this.getIfPresent(id);
        if (fragment == null) {
            return this.getFromMapper(id, allowAbsent);
        }
        if (fragment.getState() == Fragment.State.DELETED) {
            return null;
        }
        return fragment;
    }

    public List<Fragment> getMulti(List<Serializable> ids, boolean allowAbsent) throws StorageException {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Fragment> held = new ArrayList<Fragment>(ids.size());
        ArrayList<Serializable> fetchIds = new ArrayList<Serializable>(ids.size());
        for (Serializable id : ids) {
            Fragment fragment = this.getIfPresent(id);
            if (fragment == null) {
                fetchIds.add(id);
                continue;
            }
            held.add(fragment);
        }
        List<Fragment> fetched = this.getFromMapper((List<Serializable>)fetchIds, allowAbsent);
        if (fetched.size() == ids.size()) {
            return fetched;
        }
        ArrayList<Fragment> fragments = new ArrayList<Fragment>(ids.size());
        for (Serializable id : ids) {
            Fragment fragment = this.getIfPresent(id);
            if (fragment != null && fragment.getState() == Fragment.State.DELETED) {
                fragment = null;
            }
            fragments.add(fragment);
        }
        held.set(0, null);
        if (fetched.size() != 0) {
            fetched.set(0, null);
        }
        return fragments;
    }

    protected Fragment getFromMapper(Serializable id, boolean allowAbsent) throws StorageException {
        if (this.persistenceContext.isIdNew(id)) {
            if (this.isCollection) {
                return this.model.newEmptyCollectionFragment(id, this);
            }
            return allowAbsent ? new SimpleFragment(id, Fragment.State.ABSENT, this, null) : null;
        }
        if (this.isCollection) {
            Serializable[] array = this.mapper.readCollectionArray(id, this);
            return this.model.newCollectionFragment(id, array, this);
        }
        Map<String, Serializable> map = this.mapper.readSingleRowMap(this.tableName, id, this);
        if (map == null) {
            return allowAbsent ? new SimpleFragment(id, Fragment.State.ABSENT, this, null) : null;
        }
        return new SimpleFragment(id, Fragment.State.PRISTINE, this, map);
    }

    protected List<Fragment> getFromMapper(List<Serializable> ids, boolean allowAbsent) throws StorageException {
        Fragment fragment;
        ArrayList<Serializable> fetchIds = new ArrayList<Serializable>(ids.size());
        for (Serializable id : ids) {
            if (this.persistenceContext.isIdNew(id)) continue;
            fetchIds.add(id);
        }
        ArrayList<Fragment> fetchFragments = new ArrayList<Fragment>(fetchIds.size());
        if (this.isCollection) {
            Map<Serializable, Serializable[]> arrays = this.mapper.readCollectionsArrays(fetchIds, this);
            for (Serializable id : fetchIds) {
                Serializable[] array = arrays.get(id);
                fragment = this.model.newCollectionFragment(id, array, this);
                fetchFragments.add(fragment);
            }
        } else {
            Map<Serializable, Map<String, Serializable>> maps = this.mapper.readMultipleRowMaps(this.tableName, fetchIds, this);
            for (Serializable id : fetchIds) {
                Map<String, Serializable> map = maps.get(id);
                fragment = map == null ? (allowAbsent ? new SimpleFragment(id, Fragment.State.ABSENT, this, null) : null) : new SimpleFragment(id, Fragment.State.PRISTINE, this, map);
                fetchFragments.add(fragment);
            }
        }
        if (fetchIds.size() == ids.size()) {
            return fetchFragments;
        }
        ArrayList<Fragment> fragments = new ArrayList<Fragment>(ids.size());
        Iterator it = fetchFragments.iterator();
        for (Serializable id : ids) {
            fragment = this.persistenceContext.isIdNew(id) ? (this.isCollection ? this.model.newEmptyCollectionFragment(id, this) : (allowAbsent ? new SimpleFragment(id, Fragment.State.ABSENT, this, null) : null)) : (Fragment)it.next();
            fragments.add(fragment);
        }
        return fragments;
    }

    protected Fragment getIfPresent(Serializable id) {
        Fragment fragment = this.pristine.get(id);
        if (fragment != null) {
            return fragment;
        }
        return this.modified.get(id);
    }

    public void remove(Fragment fragment) throws StorageException {
        fragment.markDeleted();
    }

    protected void remove(Serializable id) throws StorageException {
        Fragment fragment = this.getIfPresent(id);
        if (fragment != null) {
            if (fragment.getState() != Fragment.State.DELETED) {
                this.remove(fragment);
            }
        } else {
            new SimpleFragment(id, Fragment.State.DELETED, this, null);
        }
    }

    protected void remapFragmentOnSave(Fragment fragment, Map<Serializable, Serializable> idMap) throws StorageException {
    }

    public void findDirtyDocuments(Set<Serializable> dirtyStrings, Set<Serializable> dirtyBinaries) throws StorageException {
        block4: for (Fragment fragment : this.modified.values()) {
            Serializable docId = null;
            switch (fragment.getState()) {
                case CREATED: {
                    docId = this.persistenceContext.getContainingDocument(fragment.getId());
                    dirtyStrings.add(docId);
                    dirtyBinaries.add(docId);
                    break;
                }
                case MODIFIED: {
                    Collection<Object> dirty = this.isCollection ? Collections.singleton(null) : ((SimpleFragment)fragment).getDirty();
                    for (String string : dirty) {
                        PropertyType type = this.model.getFulltextFieldType(this.tableName, string);
                        if (type == null) continue;
                        if (docId == null) {
                            docId = this.persistenceContext.getContainingDocument(fragment.getId());
                        }
                        if (type == PropertyType.STRING) {
                            dirtyStrings.add(docId);
                            continue;
                        }
                        if (type != PropertyType.BINARY) continue;
                        dirtyBinaries.add(docId);
                    }
                    continue block4;
                }
            }
        }
    }

    public void save(Map<Serializable, Serializable> idMap) throws StorageException {
        block6: for (Fragment fragment : this.modified.values()) {
            Serializable id = fragment.getId();
            switch (fragment.getState()) {
                case CREATED: {
                    Serializable newId = idMap.get(id);
                    if (newId != null) {
                        fragment.setId(newId);
                        id = newId;
                    }
                    if (this.isCollection) {
                        this.mapper.insertCollectionRows((CollectionFragment)fragment);
                    } else {
                        this.mapper.insertSingleRow((SimpleFragment)fragment);
                    }
                    fragment.setPristine();
                    this.pristine.put(id, fragment);
                    this.modifiedInTransaction.add(id);
                    continue block6;
                }
                case MODIFIED: {
                    if (this.isCollection) {
                        this.mapper.updateCollectionRows((CollectionFragment)fragment);
                    } else {
                        this.mapper.updateSingleRow((SimpleFragment)fragment);
                    }
                    fragment.setPristine();
                    this.pristine.put(id, fragment);
                    this.modifiedInTransaction.add(id);
                    continue block6;
                }
                case DELETED: {
                    this.mapper.deleteFragment(fragment);
                    fragment.setDetached();
                    this.deletedInTransaction.add(id);
                    continue block6;
                }
                case PRISTINE: {
                    log.error((Object)("Found PRISTINE fragment in modified map: " + fragment));
                    continue block6;
                }
            }
            throw new RuntimeException(fragment.toString());
        }
        this.modified.clear();
    }

    protected void markInvalidated(Serializable id, boolean wasModified) {
        if (wasModified) {
            Fragment fragment = this.getIfPresent(id);
            if (fragment != null) {
                fragment.markInvalidatedModified();
            }
            this.modifiedInTransaction.add(id);
        } else {
            Fragment fragment = this.getIfPresent(id);
            if (fragment != null) {
                fragment.markInvalidatedDeleted();
            }
            this.deletedInTransaction.add(id);
        }
    }

    protected void gatherInvalidations(Invalidations invalidations) {
        invalidations.addModified(this.tableName, this.modifiedInTransaction);
        invalidations.addDeleted(this.tableName, this.deletedInTransaction);
        this.modifiedInTransaction.clear();
        this.deletedInTransaction.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReceivedInvalidations() {
        Fragment fragment;
        Set<Serializable> set = this.modifiedInvalidations;
        synchronized (set) {
            for (Serializable id : this.modifiedInvalidations) {
                fragment = this.pristine.remove(id);
                if (fragment == null) continue;
                fragment.setInvalidatedModified();
            }
            this.modifiedInvalidations.clear();
        }
        set = this.deletedInvalidations;
        synchronized (set) {
            for (Serializable id : this.deletedInvalidations) {
                fragment = this.pristine.remove(id);
                if (fragment == null) continue;
                fragment.setInvalidatedDeleted();
            }
            this.deletedInvalidations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(Invalidations invalidations) {
        Set<Serializable> set;
        Set<Serializable> set2 = invalidations.modified.get(this.tableName);
        if (set2 != null) {
            set = this.modifiedInvalidations;
            synchronized (set) {
                this.modifiedInvalidations.addAll(set2);
            }
        }
        if ((set2 = invalidations.deleted.get(this.tableName)) != null) {
            set = this.deletedInvalidations;
            synchronized (set) {
                this.deletedInvalidations.addAll(set2);
            }
        }
    }
}

