/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Context;

public abstract class Fragment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Fragment.class);
    private Serializable id;
    private transient State state;
    private transient Context context;

    private void logStateTransition(State newState) {
        log.info((Object)("(" + this.context.mapper.instanceNumber + ") " + this.id + '/' + this.getTableName() + ' ' + (Object)((Object)this.state) + " -> " + (Object)((Object)newState)));
    }

    protected Fragment(Serializable id, State state, Context context) {
        this.id = id;
        this.state = state;
        this.context = context;
        switch (state) {
            case DETACHED: {
                if (context == null) break;
                throw new IllegalArgumentException();
            }
            case CREATED: 
            case DELETED: {
                context.modified.put(id, this);
                break;
            }
            case ABSENT: 
            case PRISTINE: {
                context.pristine.put(id, this);
                break;
            }
            case MODIFIED: 
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                throw new IllegalArgumentException(state.toString());
            }
        }
    }

    protected Context getContext() {
        return this.context;
    }

    public String getTableName() {
        return this.context.getTableName();
    }

    public State getState() {
        return this.state;
    }

    public void setId(Serializable id) {
        assert (this.state == State.CREATED);
        assert (id != null);
        this.id = id;
    }

    public Serializable getId() {
        return this.id;
    }

    protected abstract State refetch() throws StorageException;

    protected void accessed() throws StorageException {
        switch (this.state) {
            case DETACHED: 
            case CREATED: 
            case DELETED: 
            case ABSENT: 
            case PRISTINE: 
            case MODIFIED: {
                break;
            }
            case INVALIDATED_MODIFIED: {
                State newState;
                this.state = newState = this.refetch();
                break;
            }
            case INVALIDATED_DELETED: {
                throw new ConcurrentModificationException("Accessing a concurrently deleted value");
            }
        }
    }

    protected void markModified() {
        switch (this.state) {
            case ABSENT: {
                this.context.pristine.remove(this.id);
                this.context.modified.put(this.id, this);
                this.state = State.CREATED;
                break;
            }
            case PRISTINE: 
            case INVALIDATED_MODIFIED: {
                this.context.pristine.remove(this.id);
                this.context.modified.put(this.id, this);
                this.state = State.MODIFIED;
                break;
            }
            case DETACHED: 
            case CREATED: 
            case DELETED: 
            case MODIFIED: {
                break;
            }
            case INVALIDATED_DELETED: {
                throw new ConcurrentModificationException("Modifying a concurrently deleted value");
            }
        }
    }

    protected void markDeleted() {
        switch (this.state) {
            case DETACHED: {
                break;
            }
            case ABSENT: 
            case INVALIDATED_DELETED: {
                this.context.pristine.remove(this.id);
                this.context = null;
                this.state = State.DETACHED;
                break;
            }
            case CREATED: {
                this.context.modified.remove(this.id);
                this.context = null;
                this.state = State.DETACHED;
                break;
            }
            case PRISTINE: 
            case INVALIDATED_MODIFIED: {
                this.context.pristine.remove(this.id);
                this.context.modified.put(this.id, this);
                this.state = State.DELETED;
                break;
            }
            case MODIFIED: {
                this.state = State.DELETED;
                break;
            }
            case DELETED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void markInvalidatedModified() {
        switch (this.state) {
            case CREATED: 
            case DELETED: 
            case MODIFIED: {
                this.context.modified.remove(this.id);
                this.context.pristine.put(this.id, this);
            }
            case ABSENT: 
            case PRISTINE: {
                this.state = State.INVALIDATED_MODIFIED;
                break;
            }
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                break;
            }
            case DETACHED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void markInvalidatedDeleted() {
        switch (this.state) {
            case CREATED: 
            case DELETED: 
            case MODIFIED: {
                this.context.modified.remove(this.id);
                this.context.pristine.put(this.id, this);
            }
            case ABSENT: 
            case PRISTINE: {
                this.state = State.INVALIDATED_MODIFIED;
                break;
            }
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                break;
            }
            case DETACHED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void setDetached() {
        this.state = State.DETACHED;
        this.context = null;
    }

    protected void setPristine() {
        switch (this.state) {
            case CREATED: 
            case MODIFIED: {
                this.state = State.PRISTINE;
                break;
            }
            case DETACHED: 
            case DELETED: 
            case ABSENT: 
            case PRISTINE: 
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void setInvalidatedModified() {
        switch (this.state) {
            case ABSENT: 
            case PRISTINE: {
                this.state = State.INVALIDATED_MODIFIED;
                break;
            }
            case INVALIDATED_MODIFIED: 
            case INVALIDATED_DELETED: {
                break;
            }
            case DETACHED: 
            case CREATED: 
            case DELETED: 
            case MODIFIED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    protected void setInvalidatedDeleted() {
        switch (this.state) {
            case ABSENT: 
            case PRISTINE: 
            case INVALIDATED_MODIFIED: {
                this.state = State.INVALIDATED_DELETED;
                break;
            }
            case INVALIDATED_DELETED: {
                break;
            }
            case DETACHED: 
            case CREATED: 
            case DELETED: 
            case MODIFIED: {
                throw new RuntimeException(this.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        DETACHED,
        ABSENT,
        PRISTINE,
        CREATED,
        MODIFIED,
        DELETED,
        INVALIDATED_MODIFIED,
        INVALIDATED_DELETED;

    }
}

