/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Children;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyContext
extends Context {
    protected static final String INVAL_PARENT = "__PARENT__";
    protected final Map<Serializable, Children> childrenRegularSoft = new ReferenceMap(0, 1);
    protected final Map<Serializable, Children> childrenRegularHard = new HashMap<Serializable, Children>();
    protected final Map<Serializable, Children> childrenComplexPropSoft = new ReferenceMap(0, 1);
    protected final Map<Serializable, Children> childrenComplexPropHard = new HashMap<Serializable, Children>();
    private final Set<Serializable> modifiedParentsInTransaction = new HashSet<Serializable>();
    private final Set<Serializable> modifiedParentsInvalidations = new HashSet<Serializable>();
    private final PositionComparator posComparator = new PositionComparator("pos");

    public HierarchyContext(Mapper mapper, PersistenceContext persistenceContext) {
        super(mapper.getModel().hierTableName, mapper, persistenceContext);
    }

    @Override
    protected int clearCaches() {
        int n = super.clearCaches() + this.childrenRegularSoft.size() + this.childrenComplexPropSoft.size();
        this.childrenRegularSoft.clear();
        this.childrenComplexPropSoft.clear();
        return n;
    }

    protected Children getChildrenCache(Serializable parentId, boolean complexProp) {
        Map<Serializable, Children> hardMap;
        Map<Serializable, Children> softMap;
        if (complexProp) {
            softMap = this.childrenComplexPropSoft;
            hardMap = this.childrenComplexPropHard;
        } else {
            softMap = this.childrenRegularSoft;
            hardMap = this.childrenRegularHard;
        }
        Children children = softMap.get(parentId);
        if (children == null && (children = hardMap.get(parentId)) == null) {
            children = new Children(this, "name", false, parentId, softMap, hardMap);
        }
        return children;
    }

    protected boolean complexProp(SimpleFragment row) throws StorageException {
        return (Boolean)row.get("isproperty");
    }

    protected void addExistingChild(SimpleFragment row, boolean complexProp) throws StorageException {
        Serializable parentId = row.get("parentid");
        if (parentId == null) {
            return;
        }
        this.getChildrenCache(parentId, complexProp).addExisting(row.getId());
        this.modifiedParentsInTransaction.add(parentId);
    }

    protected void addCreatedChild(SimpleFragment row, boolean complexProp) throws StorageException {
        Serializable parentId = row.get("parentid");
        if (parentId == null) {
            return;
        }
        this.getChildrenCache(parentId, complexProp).addCreated(row.getId());
        this.modifiedParentsInTransaction.add(parentId);
    }

    protected void removeChild(SimpleFragment row, boolean complexProp) throws StorageException {
        Serializable parentId = row.get("parentid");
        if (parentId == null) {
            return;
        }
        this.getChildrenCache(parentId, complexProp).remove(row.getId());
        this.modifiedParentsInTransaction.add(parentId);
    }

    @Override
    public SimpleFragment create(Serializable id, Map<String, Serializable> map) throws StorageException {
        SimpleFragment fragment = super.create(id, map);
        this.addCreatedChild(fragment, this.complexProp(fragment));
        this.addNewParent(id);
        return fragment;
    }

    protected void addNewParent(Serializable parentId) {
        new Children(this, "name", true, parentId, this.childrenRegularSoft, this.childrenRegularHard);
        new Children(this, "name", true, parentId, this.childrenComplexPropSoft, this.childrenComplexPropHard);
    }

    @Override
    protected Fragment getFromMapper(Serializable id, boolean allowAbsent) throws StorageException {
        SimpleFragment fragment = (SimpleFragment)super.getFromMapper(id, allowAbsent);
        if (fragment != null) {
            this.addExistingChild(fragment, this.complexProp(fragment));
        }
        return fragment;
    }

    public SimpleFragment getChildByName(Serializable parentId, String name, boolean complexProp) throws StorageException {
        SimpleFragment fragment = this.getChildrenCache(parentId, complexProp).getFragmentByValue((Serializable)((Object)name));
        if (fragment == SimpleFragment.UNKNOWN && (fragment = this.mapper.readChildHierRow(parentId, name, complexProp, this)) != null) {
            this.addExistingChild(fragment, complexProp);
        }
        return fragment;
    }

    public List<SimpleFragment> getChildren(Serializable parentId, String name, boolean complexProp) throws StorageException {
        Children children = this.getChildrenCache(parentId, complexProp);
        List<SimpleFragment> fragments = children.getFragmentsByValue((Serializable)((Object)name));
        if (fragments == null) {
            fragments = this.mapper.readChildHierRows(parentId, complexProp, this);
            ArrayList<Serializable> ids = new ArrayList<Serializable>(fragments.size());
            for (SimpleFragment fragment : fragments) {
                ids.add(fragment.getId());
            }
            children.addExistingComplete(ids);
            fragments = children.getFragmentsByValue((Serializable)((Object)name));
        }
        if (this.isOrderable(parentId, complexProp)) {
            Collections.sort(fragments, this.posComparator);
        }
        return fragments;
    }

    private boolean isOrderable(Serializable parentId, boolean complexProp) throws StorageException {
        if (complexProp) {
            return true;
        }
        SimpleFragment parent = (SimpleFragment)this.get(parentId, true);
        String typeName = parent.getString("primarytype");
        return this.model.getDocumentTypeFacets(typeName).contains("Orderable");
    }

    protected Serializable getContainingDocument(Serializable id) throws StorageException {
        Serializable pid = id;
        while (pid != null) {
            SimpleFragment p = (SimpleFragment)this.get(pid, false);
            if (p == null) {
                return null;
            }
            if (!this.complexProp(p)) {
                return pid;
            }
            pid = p.get("parentid");
        }
        return null;
    }

    protected void checkNotUnder(Serializable parentId, Serializable id, String op) throws StorageException {
        SimpleFragment p;
        Serializable pid = parentId;
        do {
            if (pid.equals(id)) {
                throw new StorageException("Cannot " + op + " a node under itself: " + parentId + " is under " + id);
            }
            p = (SimpleFragment)this.get(pid, false);
            if (p == null) {
                throw new StorageException("No parent: " + pid);
            }
        } while ((pid = p.get("parentid")) != null);
    }

    protected void checkFreeName(SimpleFragment row, Serializable parentId, String name, boolean complexProp) throws StorageException {
        SimpleFragment prev = this.getChildByName(parentId, name, complexProp);
        if (prev != null) {
            throw new StorageException("Destination name already exists: " + name);
        }
    }

    public void orderBefore(Serializable parentId, Serializable sourceId, Serializable destId) throws StorageException {
        boolean complexProp = false;
        if (!this.isOrderable(parentId, complexProp)) {
            return;
        }
        if (sourceId.equals(destId)) {
            return;
        }
        List<SimpleFragment> fragments = this.getChildren(parentId, null, complexProp);
        int i = 0;
        SimpleFragment source = null;
        Long destPos = null;
        for (SimpleFragment fragment : fragments) {
            Long setPos;
            Serializable id = fragment.getId();
            if (id.equals(destId)) {
                destPos = i;
                ++i;
                if (source != null) {
                    source.put("pos", destPos);
                }
            }
            if (id.equals(sourceId)) {
                --i;
                source = fragment;
                setPos = destPos;
            } else {
                setPos = i;
            }
            if (setPos != null) {
                if (!setPos.equals(fragment.get("pos"))) {
                    fragment.put("pos", setPos);
                }
            }
            ++i;
        }
        if (destId == null) {
            Long setPos = i;
            if (!setPos.equals(source.get("pos"))) {
                source.put("pos", setPos);
            }
        }
    }

    protected Long getNextPos(Serializable nodeId, boolean complexProp) throws StorageException {
        if (!this.isOrderable(nodeId, complexProp)) {
            return null;
        }
        long max = -1L;
        for (SimpleFragment fragment : this.getChildren(nodeId, null, complexProp)) {
            Long pos = (Long)fragment.get("pos");
            if (pos == null || pos <= max) continue;
            max = pos;
        }
        return max + 1L;
    }

    public void moveChild(Node source, Serializable parentId, String name) throws StorageException {
        Serializable id = source.getId();
        SimpleFragment hierFragment = source.getHierFragment();
        Serializable oldParentId = hierFragment.get("parentid");
        String oldName = hierFragment.getString("name");
        if (!oldParentId.equals(parentId)) {
            this.checkNotUnder(parentId, id, "move");
        } else if (oldName.equals(name)) {
            return;
        }
        boolean complexProp = this.complexProp(hierFragment);
        this.checkFreeName(hierFragment, parentId, name, complexProp);
        if (!oldName.equals(name)) {
            hierFragment.put("name", (Serializable)((Object)name));
        }
        this.removeChild(hierFragment, complexProp);
        hierFragment.put("parentid", parentId);
        this.addExistingChild(hierFragment, complexProp);
    }

    public Serializable copyChild(Node source, Serializable parentId, String name) throws StorageException {
        Serializable id = source.getId();
        SimpleFragment hierFragment = source.getHierFragment();
        Serializable oldParentId = hierFragment.get("parentid");
        if (!oldParentId.equals(parentId)) {
            this.checkNotUnder(parentId, id, "copy");
        }
        this.checkFreeName(hierFragment, parentId, name, this.complexProp(hierFragment));
        String typeName = source.getPrimaryType();
        Serializable newId = this.mapper.copyHierarchy(id, typeName, parentId, name, null, null, this.persistenceContext);
        this.get(newId, false);
        return newId;
    }

    @Override
    public void remove(Fragment fragment) throws StorageException {
        this.removeChild((SimpleFragment)fragment, this.complexProp((SimpleFragment)fragment));
        super.remove(fragment);
    }

    @Override
    protected void remapFragmentOnSave(Fragment fragment, Map<Serializable, Serializable> idMap) throws StorageException {
        SimpleFragment row = (SimpleFragment)fragment;
        Serializable newParentId = idMap.get(row.get("parentid"));
        if (newParentId != null) {
            row.put("parentid", newParentId);
        }
    }

    public Map<Serializable, Serializable> saveCreated(Set<Serializable> createdIds) throws StorageException {
        HashMap<Serializable, Serializable> idMap = null;
        for (Serializable id : createdIds) {
            SimpleFragment row = (SimpleFragment)this.modified.remove(id);
            if (row == null) continue;
            if (idMap != null) {
                this.remapFragmentOnSave(row, idMap);
            }
            Serializable newId = this.mapper.insertSingleRow(row);
            row.setPristine();
            this.pristine.put(id, row);
            if (newId.equals(id)) continue;
            if (idMap == null) {
                idMap = new HashMap<Serializable, Serializable>();
            }
            idMap.put(id, newId);
        }
        return idMap == null ? Collections.emptyMap() : idMap;
    }

    @Override
    public void save(Map<Serializable, Serializable> idMap) throws StorageException {
        super.save(idMap);
        for (Serializable id : idMap.keySet()) {
            Serializable newId = idMap.get(id);
            for (Map map : new Map[]{this.childrenRegularSoft, this.childrenRegularHard, this.childrenComplexPropSoft, this.childrenComplexPropHard}) {
                Children children = (Children)map.remove(id);
                if (children == null) continue;
                map.put(newId, children);
            }
        }
        for (Children children : this.childrenRegularHard.values()) {
            children.flush();
        }
        this.childrenRegularHard.clear();
        for (Children children : this.childrenComplexPropHard.values()) {
            children.flush();
        }
        this.childrenComplexPropHard.clear();
    }

    protected void markChildrenAdded(Serializable parentId) {
        for (Map map : new Map[]{this.childrenRegularSoft, this.childrenRegularHard, this.childrenComplexPropSoft, this.childrenComplexPropHard}) {
            Children children = (Children)map.get(parentId);
            if (children == null) continue;
            children.setIncomplete();
        }
        this.modifiedParentsInTransaction.add(parentId);
    }

    @Override
    protected void gatherInvalidations(Invalidations invalidations) {
        super.gatherInvalidations(invalidations);
        invalidations.addModified(INVAL_PARENT, this.modifiedParentsInTransaction);
        this.modifiedParentsInTransaction.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processReceivedInvalidations() {
        super.processReceivedInvalidations();
        Set<Serializable> set = this.modifiedParentsInvalidations;
        synchronized (set) {
            for (Serializable parentId : this.modifiedParentsInvalidations) {
                this.childrenRegularSoft.remove(parentId);
                this.childrenRegularHard.remove(parentId);
                this.childrenComplexPropSoft.remove(parentId);
                this.childrenComplexPropHard.remove(parentId);
            }
            this.modifiedParentsInvalidations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidate(Invalidations invalidations) {
        super.invalidate(invalidations);
        Set<Serializable> set = invalidations.modified.get(INVAL_PARENT);
        if (set != null) {
            Set<Serializable> set2 = this.modifiedParentsInvalidations;
            synchronized (set2) {
                this.modifiedParentsInvalidations.addAll(set);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PositionComparator
    implements Comparator<SimpleFragment> {
        protected final String posKey;

        public PositionComparator(String posKey) {
            this.posKey = posKey;
        }

        @Override
        public int compare(SimpleFragment frag1, SimpleFragment frag2) {
            try {
                Long pos1 = (Long)frag1.get(this.posKey);
                Long pos2 = (Long)frag2.get(this.posKey);
                if (pos1 == null && pos2 == null) {
                    return frag1.hashCode() - frag2.hashCode();
                }
                if (pos1 == null) {
                    return 1;
                }
                if (pos2 == null) {
                    return -1;
                }
                return pos1.compareTo(pos2);
            }
            catch (StorageException e) {
                return frag1.hashCode() - frag2.hashCode();
            }
        }
    }
}

