/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invalidations {
    public final Map<String, Set<Serializable>> modified = new HashMap<String, Set<Serializable>>();
    public final Map<String, Set<Serializable>> deleted = new HashMap<String, Set<Serializable>>();

    public boolean isEmpty() {
        return this.modified.isEmpty() && this.deleted.isEmpty();
    }

    public Map<String, Set<Serializable>> getKindMap(int kind) {
        if (kind == 1) {
            return this.modified;
        }
        if (kind == 2) {
            return this.deleted;
        }
        throw new AssertionError();
    }

    public void addModified(String tableName, Set<Serializable> ids) {
        if (ids.isEmpty()) {
            return;
        }
        Set<Serializable> set = this.modified.get(tableName);
        if (set == null) {
            set = new HashSet<Serializable>();
            this.modified.put(tableName, set);
        }
        set.addAll(ids);
    }

    public void addDeleted(String tableName, Set<Serializable> ids) {
        if (ids.isEmpty()) {
            return;
        }
        Set<Serializable> set = this.deleted.get(tableName);
        if (set == null) {
            set = new HashSet<Serializable>();
            this.deleted.put(tableName, set);
        }
        set.addAll(ids);
    }

    public void add(Serializable id, String[] tableNames, int kind) {
        Map<String, Set<Serializable>> map = this.getKindMap(kind);
        for (String tableName : tableNames) {
            Set<Serializable> set = map.get(tableName);
            if (set == null) {
                set = new HashSet<Serializable>();
                map.put(tableName, set);
            }
            set.add(id);
        }
    }
}

