/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.security.MessageDigest;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.HierarchyContext;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.NXQLQueryMaker;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.Update;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.db.dialect.DialectOracle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper {
    private static final Log log = LogFactory.getLog(Mapper.class);
    protected static boolean debugTestUpgrade;
    private final RepositoryImpl repository;
    private final Model model;
    private final SQLInfo sqlInfo;
    private final XADataSource xadatasource;
    private XAConnection xaconnection;
    private Connection connection;
    private XAResource xaresource;
    private static final AtomicLong instanceCounter;
    protected final long instanceNumber = instanceCounter.incrementAndGet();
    private static final int DEBUG_MAX_ARRAY = 10;
    private static final int DEBUG_MAX_STRING = 100;

    public Mapper(RepositoryImpl repository, Model model, SQLInfo sqlInfo, XADataSource xadatasource) throws StorageException {
        this.repository = repository;
        this.model = model;
        this.sqlInfo = sqlInfo;
        this.xadatasource = xadatasource;
        this.resetConnection();
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (this.xaconnection != null) {
            try {
                this.xaconnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.xaconnection = null;
        this.connection = null;
        this.xaresource = null;
    }

    protected void resetConnection() throws StorageException {
        this.close();
        try {
            this.xaconnection = this.xadatasource.getXAConnection();
            this.connection = this.xaconnection.getConnection();
            this.xaresource = this.xaconnection.getXAResource();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    protected void checkConnectionReset(SQLException e) throws StorageException {
        if (this.sqlInfo.dialect.connectionClosedByException(e)) {
            this.resetConnection();
        }
    }

    protected void checkConnectionReset(XAException e) {
        if (this.sqlInfo.dialect.connectionClosedByException(e)) {
            try {
                this.resetConnection();
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
    }

    protected Model getModel() {
        return this.model;
    }

    protected int getTableSize(String tableName) {
        return this.sqlInfo.getDatabase().getTable(tableName).getColumns().size();
    }

    private static boolean isLogEnabled() {
        return log.isTraceEnabled();
    }

    private void logCount(int count) {
        if (count > 0 && Mapper.isLogEnabled()) {
            this.log("  -> " + count + " row" + (count > 1 ? "s" : ""));
        }
    }

    private void log(String string) {
        log.trace((Object)("(" + this.instanceNumber + ") SQL: " + string));
    }

    private void logResultSet(ResultSet rs, List<Column> columns) throws SQLException {
        LinkedList<String> res = new LinkedList<String>();
        int i = 0;
        for (Column column : columns) {
            Serializable v = column.getFromResultSet(rs, ++i);
            res.add(column.getKey() + "=" + Mapper.loggedValue(v));
        }
        this.log("  -> " + StringUtils.join(res, (String)", "));
    }

    private void logSQL(String sql, List<Column> columns, SimpleFragment row) {
        ArrayList<Serializable> values = new ArrayList<Serializable>(columns.size());
        for (Column column : columns) {
            Object value;
            String key = column.getKey();
            if (key.equals("id")) {
                value = row.getId();
            } else {
                try {
                    value = row.get(key);
                }
                catch (StorageException e) {
                    value = "ACCESSFAILED";
                }
            }
            values.add((Serializable)value);
        }
        this.logSQL(sql, values);
    }

    private void logSQL(String sql, List<Serializable> values) {
        StringBuilder buf = new StringBuilder();
        int start = 0;
        for (Serializable v : values) {
            int index = sql.indexOf(63, start);
            if (index == -1) break;
            buf.append(sql, start, index);
            buf.append(Mapper.loggedValue(v));
            start = index + 1;
        }
        buf.append(sql, start, sql.length());
        this.log(buf.toString());
    }

    private static String loggedValue(Serializable value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof String) {
            String v = (String)((Object)value);
            if (v.length() > 100) {
                v = v.substring(0, 100) + "...(" + v.length() + " chars)...";
            }
            return "'" + v.replace("'", "''") + "'";
        }
        if (value instanceof Calendar) {
            char sign;
            Calendar cal = (Calendar)value;
            int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            return String.format("TIMESTAMP '%04d-%02d-%02dT%02d:%02d:%02d.%03d%c%02d:%02d'", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), Character.valueOf(sign), offset / 60, offset % 60);
        }
        if (value instanceof Binary) {
            return "'" + ((Binary)value).getDigest() + "'";
        }
        if (value.getClass().isArray()) {
            Serializable[] v = (Serializable[])value;
            StringBuilder b = new StringBuilder();
            b.append('[');
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    b.append(',');
                    if (i > 10) {
                        b.append("...(" + v.length + " items)...");
                        break;
                    }
                }
                b.append(Mapper.loggedValue(v[i]));
            }
            b.append(']');
            return b.toString();
        }
        return value.toString();
    }

    protected static void closePreparedStatement(PreparedStatement ps) throws SQLException {
        try {
            ps.close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void createDatabase() throws StorageException {
        try {
            Collection<ConditionalStatement> statements = this.sqlInfo.getConditionalStatements();
            this.executeConditionalStatements(statements, true);
            if (debugTestUpgrade) {
                this.executeConditionalStatements(this.sqlInfo.getTestConditionalStatements(), true);
            }
            this.createTables();
            this.executeConditionalStatements(statements, false);
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    protected String getTableName(String origName) {
        if (this.sqlInfo.dialect instanceof DialectOracle && origName.length() > 30) {
            StringBuilder sb = new StringBuilder(origName.length());
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                sb.append(origName.substring(0, 15));
                sb.append('_');
                digest.update(origName.getBytes());
                sb.append(Dialect.toHexString(digest.digest()).substring(0, 12));
                return sb.toString();
            }
            catch (Exception e) {
                throw new RuntimeException("Error", e);
            }
        }
        return origName;
    }

    protected void createTables() throws SQLException {
        String schemaName = this.sqlInfo.dialect.getConnectionSchema(this.connection);
        DatabaseMetaData metadata = this.connection.getMetaData();
        Set<String> tableNames = Mapper.findTableNames(metadata, schemaName);
        Statement st = this.connection.createStatement();
        for (Table table : this.sqlInfo.getDatabase().getTables()) {
            String tableName = this.getTableName(table.getName());
            if (tableNames.contains(tableName) || tableNames.contains(tableName.toUpperCase())) {
                this.sqlInfo.dialect.existingTableDetected(this.connection, table, this.model, this.sqlInfo.database);
            } else {
                boolean create = this.sqlInfo.dialect.preCreateTable(this.connection, table, this.model, this.sqlInfo.database);
                if (!create) {
                    log.warn((Object)("Creation skipped for table: " + table.getName()));
                    continue;
                }
                String sql = table.getCreateSql();
                this.log(sql);
                st.execute(sql);
                for (String s : table.getPostCreateSqls()) {
                    this.log(s);
                    st.execute(s);
                }
                for (String s : this.sqlInfo.dialect.getPostCreateTableSqls(table, this.model, this.sqlInfo.database)) {
                    this.log(s);
                    st.execute(s);
                }
            }
            ResultSet rs = metadata.getColumns(null, schemaName, tableName, "%");
            HashMap<String, Integer> columnTypes = new HashMap<String, Integer>();
            HashMap<String, String> columnTypeNames = new HashMap<String, String>();
            HashMap<String, Integer> columnTypeSizes = new HashMap<String, Integer>();
            while (rs.next()) {
                String schema = rs.getString("TABLE_SCHEM");
                if (schema != null && "INFORMATION_SCHEMA".equals(schema.toUpperCase())) continue;
                String columnName = rs.getString("COLUMN_NAME").toUpperCase();
                columnTypes.put(columnName, rs.getInt("DATA_TYPE"));
                columnTypeNames.put(columnName, rs.getString("TYPE_NAME"));
                columnTypeSizes.put(columnName, rs.getInt("COLUMN_SIZE"));
            }
            for (Column column : table.getColumns()) {
                Integer actualSize;
                String actualName;
                String upperName = column.getPhysicalName().toUpperCase();
                Integer type = (Integer)columnTypes.remove(upperName);
                if (type == null) {
                    log.warn((Object)("Adding missing column in database: " + column.getFullQuotedName()));
                    String sql = table.getAddColumnSql(column);
                    this.log(sql);
                    st.execute(sql);
                    continue;
                }
                int expected = column.getJdbcType();
                int actual = type;
                if (column.setJdbcType(actual, actualName = (String)columnTypeNames.get(upperName), actualSize = (Integer)columnTypeSizes.get(upperName))) continue;
                log.error((Object)String.format("SQL type mismatch for %s: expected %s, database has %s / %s (%s)", column.getFullQuotedName(), expected, type, actualName, actualSize));
            }
            if (columnTypes.isEmpty()) continue;
            log.warn((Object)("Database contains additional unused columns for table " + table.getQuotedName() + ": " + StringUtils.join(new ArrayList(columnTypes.keySet()), (String)", ")));
        }
        st.close();
    }

    protected static Set<String> findTableNames(DatabaseMetaData metadata, String schemaName) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet rs = metadata.getTables(null, schemaName, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            tableNames.add(tableName);
            tableNames.add(tableName.toUpperCase());
        }
        return tableNames;
    }

    protected void createClusterNode() throws StorageException {
        try {
            Statement st = this.connection.createStatement();
            String sql = this.sqlInfo.getCleanupClusterNodesSql();
            this.log(sql);
            int n = st.executeUpdate(sql);
            if (Mapper.isLogEnabled()) {
                this.logCount(n);
            }
            sql = this.sqlInfo.getCreateClusterNodeSql();
            this.log(sql);
            st.execute(sql);
            st.close();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    protected void removeClusterNode() throws StorageException {
        try {
            Statement st = this.connection.createStatement();
            String sql = this.sqlInfo.getRemoveClusterNodeSql();
            this.log(sql);
            st.execute(sql);
            st.close();
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException(e);
        }
    }

    public void insertClusterInvalidations(Invalidations invalidations) throws StorageException {
        String sql = this.sqlInfo.getClusterInsertInvalidationsSql();
        List<Column> columns = this.sqlInfo.getClusterInsertInvalidationsColumns();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            for (int kind = 1; kind <= 2; ++kind) {
                Map<String, Set<Serializable>> map = invalidations.getKindMap(kind);
                Map<Serializable, Set<String>> m = Mapper.invertMap(map);
                for (Map.Entry<Serializable, Set<String>> e : m.entrySet()) {
                    Serializable id = e.getKey();
                    String[] fragments = Mapper.join((Collection<String>)e.getValue(), ' ');
                    if (Mapper.isLogEnabled()) {
                        this.logSQL(sql, Arrays.asList(id, fragments, kind));
                    }
                    String[] frags = this.sqlInfo.dialect.supportsArrays() ? fragments.split(" ") : fragments;
                    columns.get(0).setToPreparedStatement(ps, 1, id);
                    columns.get(1).setToPreparedStatement(ps, 2, (Serializable)frags);
                    columns.get(2).setToPreparedStatement(ps, 3, Long.valueOf(kind));
                    ps.execute();
                }
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not invalidate", e);
        }
        finally {
            if (ps != null) {
                try {
                    Mapper.closePreparedStatement(ps);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
    }

    public static Map<Serializable, Set<String>> invertMap(Map<String, Set<Serializable>> map) {
        HashMap<Serializable, Set<String>> res = new HashMap<Serializable, Set<String>>();
        for (Map.Entry<String, Set<Serializable>> entry : map.entrySet()) {
            String fragment = entry.getKey();
            for (Serializable id : entry.getValue()) {
                HashSet<String> set = (HashSet<String>)res.get(id);
                if (set == null) {
                    set = new HashSet<String>();
                    res.put(id, set);
                }
                set.add(fragment);
            }
        }
        return res;
    }

    protected static final String join(Collection<String> strings, char sep) {
        if (strings.isEmpty()) {
            throw new RuntimeException();
        }
        if (strings.size() == 1) {
            return strings.iterator().next();
        }
        int size = 0;
        for (String word : strings) {
            size += word.length() + 1;
        }
        StringBuilder buf = new StringBuilder(size);
        for (String word : strings) {
            buf.append(word);
            buf.append(sep);
        }
        buf.setLength(size - 1);
        return buf.toString();
    }

    public Invalidations getClusterInvalidations() throws StorageException {
        Invalidations invalidations = new Invalidations();
        String sql = this.sqlInfo.getClusterGetInvalidationsSql();
        List<Column> columns = this.sqlInfo.getClusterGetInvalidtionsColumns();
        Statement st = null;
        try {
            st = this.connection.createStatement();
            if (Mapper.isLogEnabled()) {
                this.log(sql);
            }
            ResultSet rs = st.executeQuery(sql);
            int n = 0;
            while (rs.next()) {
                ++n;
                Serializable id = columns.get(0).getFromResultSet(rs, 1);
                Serializable frags = columns.get(1).getFromResultSet(rs, 2);
                int kind = ((Long)columns.get(2).getFromResultSet(rs, 3)).intValue();
                String[] fragments = this.sqlInfo.dialect.supportsArrays() ? (String[])frags : ((String)((Object)frags)).split(" ");
                invalidations.add(id, fragments, kind);
            }
            if (Mapper.isLogEnabled()) {
                this.logCount(n);
            }
            Invalidations invalidations2 = invalidations;
            return invalidations2;
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not invalidate", e);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Serializable getRootId(Serializable repositoryId) throws StorageException {
        String sql = this.sqlInfo.getSelectRootIdSql();
        try {
            if (Mapper.isLogEnabled()) {
                this.logSQL(sql, Collections.singletonList(repositoryId));
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                ps.setObject(1, repositoryId);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    if (Mapper.isLogEnabled()) {
                        this.log("  -> (none)");
                    }
                    Serializable serializable = null;
                    return serializable;
                }
                Column column = this.sqlInfo.getSelectRootIdWhatColumn();
                Serializable id = column.getFromResultSet(rs, 1);
                if (Mapper.isLogEnabled()) {
                    this.log("  -> id=" + id);
                }
                if (rs.next()) {
                    throw new StorageException("Row query for " + repositoryId + " returned several rows: " + sql);
                }
                Serializable serializable = id;
                return serializable;
            }
            finally {
                Mapper.closePreparedStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + sql, e);
        }
    }

    protected void executeConditionalStatements(Collection<ConditionalStatement> statements, boolean early) throws SQLException {
        Statement st = this.connection.createStatement();
        for (ConditionalStatement s : statements) {
            boolean doPre;
            if (s.early != early) continue;
            if (s.doPre != null) {
                doPre = s.doPre;
            } else {
                this.log(s.checkStatement);
                ResultSet rs = st.executeQuery(s.checkStatement);
                if (rs.next()) {
                    this.log("  -> (present)");
                    doPre = true;
                } else {
                    doPre = false;
                }
            }
            if (doPre) {
                this.log(s.preStatement);
                st.execute(s.preStatement);
            }
            this.log(s.statement);
            st.execute(s.statement);
        }
        st.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootId(Serializable repositoryId, Serializable id) throws StorageException {
        String sql = this.sqlInfo.getInsertRootIdSql();
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                List<Column> columns = this.sqlInfo.getInsertRootIdColumns();
                ArrayList<Serializable> debugValues = null;
                if (Mapper.isLogEnabled()) {
                    debugValues = new ArrayList<Serializable>(2);
                }
                int i = 0;
                for (Column column : columns) {
                    Serializable v;
                    ++i;
                    String key = column.getKey();
                    if (key.equals("id")) {
                        v = id;
                    } else if (key.equals("name")) {
                        v = repositoryId;
                    } else {
                        throw new RuntimeException(key);
                    }
                    column.setToPreparedStatement(ps, i, v);
                    if (debugValues == null) continue;
                    debugValues.add(v);
                }
                if (debugValues != null) {
                    this.logSQL(sql, debugValues);
                    debugValues.clear();
                }
                ps.execute();
            }
            finally {
                Mapper.closePreparedStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not insert: " + sql, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable insertSingleRow(SimpleFragment row) throws StorageException {
        block10: {
            String tableName = row.getTableName();
            PreparedStatement ps = null;
            try {
                String sql = this.sqlInfo.getInsertSql(tableName);
                List<Column> columns = this.sqlInfo.getInsertColumns(tableName);
                try {
                    if (Mapper.isLogEnabled()) {
                        this.logSQL(sql, columns, row);
                    }
                    ps = this.connection.prepareStatement(sql);
                    int i = 0;
                    for (Column column : columns) {
                        String key = column.getKey();
                        Serializable v = key.equals("id") ? row.getId() : row.get(key);
                        column.setToPreparedStatement(ps, ++i, v);
                    }
                    ps.execute();
                }
                catch (SQLException e) {
                    this.checkConnectionReset(e);
                    throw new StorageException("Could not insert: " + sql, e);
                }
                if (ps == null) break block10;
            }
            catch (Throwable throwable) {
                if (ps == null) throw throwable;
                try {
                    Mapper.closePreparedStatement(ps);
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error((Object)"Cannot close connection", (Throwable)e);
                }
                throw throwable;
            }
            try {
                Mapper.closePreparedStatement(ps);
            }
            catch (SQLException e) {
                log.error((Object)"Cannot close connection", (Throwable)e);
            }
        }
        row.clearDirty();
        return row.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertCollectionRows(CollectionFragment fragment) throws StorageException {
        String tableName = fragment.getTableName();
        PreparedStatement ps = null;
        try {
            String sql = this.sqlInfo.getInsertSql(tableName);
            List<Column> columns = this.sqlInfo.getInsertColumns(tableName);
            try {
                Serializable id = fragment.getId();
                ArrayList<Serializable> debugValues = null;
                if (Mapper.isLogEnabled()) {
                    debugValues = new ArrayList<Serializable>(3);
                }
                ps = this.connection.prepareStatement(sql);
                CollectionFragment.CollectionFragmentIterator it = fragment.getIterator();
                while (it.hasNext()) {
                    Serializable n = (Serializable)it.next();
                    it.setToPreparedStatement(columns, ps, this.model, debugValues);
                    if (debugValues != null) {
                        this.logSQL(sql, debugValues);
                        debugValues.clear();
                    }
                    ps.execute();
                }
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not insert: " + sql, e);
            }
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            if (ps == null) throw throwable;
            try {
                Mapper.closePreparedStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                log.error((Object)"Cannot close connection", (Throwable)e);
            }
            throw throwable;
        }
        try {
            Mapper.closePreparedStatement(ps);
            return;
        }
        catch (SQLException e) {
            log.error((Object)"Cannot close connection", (Throwable)e);
        }
    }

    protected SimpleFragment getSelectRow(SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Context context) throws StorageException {
        Map<String, Serializable> joinMap = Collections.emptyMap();
        List<SimpleFragment> rows = this.getSelectRows(select, criteriaMap, joinMap, true, context);
        if (rows == null) {
            return null;
        }
        return rows.get(0);
    }

    protected List<SimpleFragment> getSelectRows(SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Context context) throws StorageException {
        Map<String, Serializable> joinMap = Collections.emptyMap();
        return this.getSelectRows(select, criteriaMap, joinMap, false, context);
    }

    protected List<SimpleFragment> getSelectRows(SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Map<String, Serializable> joinMap, Context context) throws StorageException {
        return this.getSelectRows(select, criteriaMap, joinMap, false, context);
    }

    protected List<SimpleFragment> getSelectRows(SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Map<String, Serializable> joinMap, boolean limitToOne, Context context) throws StorageException {
        List<Map<String, Serializable>> maps = this.getSelectMaps(select, criteriaMap, joinMap, limitToOne, context);
        if (maps == null) {
            return null;
        }
        LinkedList<SimpleFragment> fragments = new LinkedList<SimpleFragment>();
        for (Map<String, Serializable> map : maps) {
            Serializable id = map.remove("id");
            SimpleFragment fragment = (SimpleFragment)context.getIfPresent(id);
            if (fragment == null) {
                fragment = new SimpleFragment(id, Fragment.State.PRISTINE, context, map);
            } else {
                Fragment.State state = fragment.getState();
                if (state == Fragment.State.DELETED) continue;
                if (state == Fragment.State.ABSENT || state == Fragment.State.INVALIDATED_MODIFIED || state == Fragment.State.INVALIDATED_DELETED) {
                    throw new IllegalStateException(state.toString());
                }
            }
            fragments.add(fragment);
        }
        return fragments;
    }

    protected List<Map<String, Serializable>> getSelectMaps(SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Map<String, Serializable> joinMap, boolean limitToOne, Context context) throws StorageException {
        LinkedList<Map<String, Serializable>> list = new LinkedList<Map<String, Serializable>>();
        if (select.whatColumns.isEmpty() && select.whereColumns.size() == 1 && select.whereColumns.get(0).getKey() == "id" && joinMap == null) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>(criteriaMap);
            if (select.opaqueColumns != null) {
                for (Column column : select.opaqueColumns) {
                    map.put(column.getKey(), SimpleFragment.OPAQUE);
                }
            }
            list.add(map);
            return list;
        }
        PreparedStatement ps = null;
        try {
            LinkedList<Map<String, Serializable>> linkedList;
            ps = this.connection.prepareStatement(select.sql);
            LinkedList<Serializable> debugValues = null;
            if (Mapper.isLogEnabled()) {
                debugValues = new LinkedList<Serializable>();
            }
            int i = 1;
            for (Column column : select.whereColumns) {
                Serializable v;
                String key = column.getKey();
                if (criteriaMap.containsKey(key)) {
                    v = criteriaMap.get(key);
                } else if (joinMap.containsKey(key)) {
                    v = joinMap.get(key);
                } else {
                    throw new RuntimeException(key);
                }
                if (v == null) {
                    throw new StorageException("Null value for key: " + key);
                }
                if (v instanceof List) {
                    for (Object vv : (List)((Object)v)) {
                        column.setToPreparedStatement(ps, i++, (Serializable)vv);
                        if (debugValues == null) continue;
                        debugValues.add((Serializable)vv);
                    }
                    continue;
                }
                column.setToPreparedStatement(ps, i++, v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
            if (debugValues != null) {
                this.logSQL(select.sql, debugValues);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Serializable> map = new HashMap<String, Serializable>(criteriaMap);
                i = 1;
                for (Column column : select.whatColumns) {
                    map.put(column.getKey(), column.getFromResultSet(rs, i++));
                }
                if (select.opaqueColumns != null) {
                    for (Column column : select.opaqueColumns) {
                        map.put(column.getKey(), SimpleFragment.OPAQUE);
                    }
                }
                if (Mapper.isLogEnabled()) {
                    this.logResultSet(rs, select.whatColumns);
                }
                list.add(map);
                if (!limitToOne) continue;
                LinkedList<Map<String, Serializable>> i$ = list;
                return i$;
            }
            if (limitToOne) {
                linkedList = null;
                return linkedList;
            }
            linkedList = list;
            return linkedList;
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + select.sql, e);
        }
        finally {
            if (ps != null) {
                try {
                    Mapper.closePreparedStatement(ps);
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
    }

    public Map<String, Serializable> readSingleRowMap(String tableName, Serializable id, Context context) throws StorageException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectFragmentById.get(tableName);
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("id", id);
        List<Map<String, Serializable>> maps = this.getSelectMaps(select, criteriaMap, null, true, context);
        return maps == null ? null : maps.get(0);
    }

    public Map<Serializable, Map<String, Serializable>> readMultipleRowMaps(String tableName, List<Serializable> ids, Context context) throws StorageException {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size());
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("id", (Serializable)((Object)ids));
        List<Map<String, Serializable>> maps = this.getSelectMaps(select, criteriaMap, null, false, context);
        HashMap<Serializable, Map<String, Serializable>> res = new HashMap<Serializable, Map<String, Serializable>>();
        for (Map<String, Serializable> map : maps) {
            res.put(map.get("id"), map);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SimpleFragment readChildHierRow(Serializable parentId, String childName, boolean complexProp, Context context) throws StorageException {
        String sql = this.sqlInfo.getSelectByChildNameSql(complexProp);
        try {
            ArrayList<Serializable> debugValues = null;
            if (Mapper.isLogEnabled()) {
                debugValues = new ArrayList<Serializable>(2);
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                ResultSet rs;
                int i = 0;
                for (Column column222 : this.sqlInfo.getSelectByChildNameWhereColumns(complexProp)) {
                    Object v;
                    ++i;
                    String key = column222.getKey();
                    if (key.equals("parentid")) {
                        v = parentId;
                    } else {
                        if (!key.equals("name")) throw new RuntimeException("Invalid hier column: " + key);
                        v = childName;
                    }
                    if (v == null) {
                        throw new IllegalStateException("Null value for key: " + key);
                    }
                    column222.setToPreparedStatement(ps, i, (Serializable)v);
                    if (debugValues == null) continue;
                    debugValues.add((Serializable)v);
                }
                if (debugValues != null) {
                    this.logSQL(sql, debugValues);
                }
                if (!(rs = ps.executeQuery()).next()) {
                    Column column222;
                    column222 = null;
                    return column222;
                }
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                i = 0;
                List<Column> columns = this.sqlInfo.getSelectByChildNameWhatColumns(complexProp);
                Serializable id = null;
                for (Column column : columns) {
                    String key = column.getKey();
                    Serializable value = column.getFromResultSet(rs, ++i);
                    if (key.equals("id")) {
                        id = value;
                        continue;
                    }
                    map.put(key, value);
                }
                map.put("parentid", parentId);
                map.put("name", (Serializable)((Object)childName));
                map.put("isproperty", Boolean.valueOf(complexProp));
                SimpleFragment row = new SimpleFragment(id, Fragment.State.PRISTINE, context, map);
                if (Mapper.isLogEnabled()) {
                    this.logResultSet(rs, columns);
                }
                while (rs.next()) {
                    String newName = childName + '.' + System.currentTimeMillis();
                    i = 0;
                    Serializable childId = null;
                    for (Column column : columns) {
                        ++i;
                        if (!column.getKey().equals("id")) continue;
                        childId = column.getFromResultSet(rs, i);
                    }
                    log.error((Object)String.format("Child '%s' appeared twice as child of %s (%s and %s), renaming second to '%s'", childName, parentId, id, childId, newName));
                    HashMap<String, Serializable> rename = new HashMap<String, Serializable>();
                    rename.put("name", (Serializable)((Object)newName));
                    this.updateSingleRowWithValues("hierarchy", childId, rename);
                }
                SimpleFragment simpleFragment = row;
                return simpleFragment;
            }
            finally {
                Mapper.closePreparedStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + sql, e);
        }
    }

    public List<SimpleFragment> readChildHierRows(Serializable parentId, boolean complexProp, Context context) throws StorageException {
        if (parentId == null) {
            throw new IllegalArgumentException("Illegal null parentId");
        }
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectChildrenByIsProperty;
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("parentid", parentId);
        criteriaMap.put("isproperty", Boolean.valueOf(complexProp));
        return this.getSelectRows(select, criteriaMap, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable[] readCollectionArray(Serializable id, Context context) throws StorageException {
        Serializable[] serializableArray;
        String tableName = context.getTableName();
        String sql = this.sqlInfo.selectFragmentById.get((Object)tableName).sql;
        if (Mapper.isLogEnabled()) {
            this.logSQL(sql, Collections.singletonList(id));
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            List<Column> columns = this.sqlInfo.selectFragmentById.get((Object)tableName).whatColumns;
            ps.setObject(1, id);
            ResultSet rs = ps.executeQuery();
            Serializable[] array = this.model.newCollectionArray(rs, columns, context);
            if (Mapper.isLogEnabled()) {
                this.log("  -> " + Arrays.asList(array));
            }
            serializableArray = array;
        }
        catch (Throwable throwable) {
            try {
                Mapper.closePreparedStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not select: " + sql, e);
            }
        }
        Mapper.closePreparedStatement(ps);
        return serializableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Serializable, Serializable[]> readCollectionsArrays(List<Serializable> ids, Context context) throws StorageException {
        Map<Serializable, Serializable[]> map;
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        String tableName = context.getTableName();
        String[] stringArray = new String[2];
        stringArray[0] = "id";
        stringArray[1] = "pos";
        String[] orderBys = stringArray;
        String[] stringArray2 = new String[1];
        stringArray2[0] = "pos";
        HashSet<String> skipColumns = new HashSet<String>(Arrays.asList(stringArray2));
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size(), orderBys, skipColumns);
        String sql = select.sql;
        if (Mapper.isLogEnabled()) {
            this.logSQL(sql, ids);
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            int i = 1;
            for (Serializable id : ids) {
                ps.setObject(i++, id);
            }
            ResultSet rs = ps.executeQuery();
            Map<Serializable, Serializable[]> res = this.model.newCollectionArrays(rs, select.whatColumns, context);
            for (Serializable serializable : ids) {
                if (res.containsKey(serializable)) continue;
                Serializable[] array = this.model.getCollectionFragmentType(tableName).getEmptyArray();
                res.put(serializable, array);
            }
            if (Mapper.isLogEnabled()) {
                for (Map.Entry entry : res.entrySet()) {
                    this.log("  -> " + entry.getKey() + " = " + Arrays.asList((Object[])entry.getValue()));
                }
            }
            map = res;
        }
        catch (Throwable throwable) {
            try {
                Mapper.closePreparedStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not select: " + sql, e);
            }
        }
        Mapper.closePreparedStatement(ps);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSingleRow(SimpleFragment row) throws StorageException {
        Collection<String> dirty = row.getDirty();
        if (dirty.isEmpty()) {
            return;
        }
        String tableName = row.getTableName();
        SQLInfo.SQLInfoSelect update = this.sqlInfo.getUpdateById(tableName, dirty);
        try {
            PreparedStatement ps = this.connection.prepareStatement(update.sql);
            try {
                if (Mapper.isLogEnabled()) {
                    this.logSQL(update.sql, update.whatColumns, row);
                }
                int i = 0;
                for (Column column : update.whatColumns) {
                    String key = column.getKey();
                    Serializable v = key.equals("id") ? row.getId() : row.get(key);
                    column.setToPreparedStatement(ps, ++i, v);
                }
                int count = ps.executeUpdate();
                this.logCount(count);
            }
            finally {
                Mapper.closePreparedStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not update: " + update.sql, e);
        }
        row.clearDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSingleRowWithValues(String tableName, Serializable id, Map<String, Serializable> map) throws StorageException {
        Update update = this.sqlInfo.getUpdateByIdForKeys(tableName, map.keySet());
        Table table = update.getTable();
        String sql = update.getStatement();
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                if (Mapper.isLogEnabled()) {
                    LinkedList<Serializable> values = new LinkedList<Serializable>();
                    values.addAll(map.values());
                    values.add(id);
                    this.logSQL(sql, values);
                }
                int i = 1;
                for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                    String key = entry.getKey();
                    Serializable value = entry.getValue();
                    table.getColumn(key).setToPreparedStatement(ps, i++, value);
                }
                ps.setObject(i, id);
                int count = ps.executeUpdate();
                this.logCount(count);
            }
            finally {
                Mapper.closePreparedStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not update: " + sql, e);
        }
    }

    public void updateCollectionRows(CollectionFragment fragment) throws StorageException {
        this.deleteFragment(fragment);
        this.insertCollectionRows(fragment);
    }

    public void deleteFragment(Fragment fragment) throws StorageException {
        try {
            this.deleteFragment(fragment.getTableName(), fragment.getId());
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not delete: " + fragment.getId().toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteFragment(String tableName, Serializable id) throws SQLException {
        String sql = this.sqlInfo.getDeleteSql(tableName);
        if (Mapper.isLogEnabled()) {
            this.logSQL(sql, Collections.singletonList(id));
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            ps.setObject(1, id);
            int count = ps.executeUpdate();
            this.logCount(count);
            boolean bl = count > 0;
            return bl;
        }
        finally {
            Mapper.closePreparedStatement(ps);
        }
    }

    public Serializable copyHierarchy(Serializable sourceId, String typeName, Serializable destParentId, String destName, Serializable overwriteId, Map<String, Serializable> overwriteMap, PersistenceContext persistenceContext) throws StorageException {
        assert (!this.model.separateMainTable);
        HierarchyContext hierContext = persistenceContext.getHierContext();
        try {
            LinkedHashMap<Serializable, Serializable> idMap = new LinkedHashMap<Serializable, Serializable>();
            HashMap<Serializable, String> idType = new HashMap<Serializable, String>();
            if (overwriteId != null) {
                this.updateSingleRowWithValues(this.model.hierTableName, overwriteId, overwriteMap);
                idMap.put(sourceId, overwriteId);
                hierContext.markInvalidated(overwriteId, true);
            }
            Serializable newRootId = this.copyHierRecursive(sourceId, typeName, destParentId, destName, overwriteId, idMap, idType);
            hierContext.markChildrenAdded(overwriteId == null ? destParentId : overwriteId);
            for (Map.Entry<String, Set<Serializable>> entry : this.model.getPerFragmentIds(idType).entrySet()) {
                boolean overwrite;
                String tableName = entry.getKey();
                if (tableName.equals("acls")) continue;
                Set<Serializable> ids = entry.getValue();
                Boolean invalidation = this.copyFragments(tableName, ids, idMap, (overwrite = overwriteId != null && !tableName.equals(this.model.mainTableName)) ? overwriteId : null);
                if (invalidation == null) continue;
                persistenceContext.getContext(tableName).markInvalidated(overwriteId, invalidation);
            }
            return newRootId;
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not copy: " + sourceId.toString(), e);
        }
    }

    protected Serializable copyHierRecursive(Serializable id, String type, Serializable parentId, String name, Serializable overwriteId, Map<Serializable, Serializable> idMap, Map<Serializable, String> idType) throws SQLException {
        Serializable newId;
        idType.put(id, type);
        if (overwriteId == null) {
            newId = this.copyHier(id, type, parentId, name, idMap);
        } else {
            newId = overwriteId;
            idMap.put(id, newId);
        }
        boolean onlyComplex = parentId == null;
        for (Serializable[] info : this.getChildrenIds(id, onlyComplex)) {
            Serializable childId = info[0];
            String childType = (String)((Object)info[1]);
            this.copyHierRecursive(childId, childType, newId, null, null, idMap, idType);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable copyHier(Serializable id, String type, Serializable parentId, String name, Map<Serializable, Serializable> idMap) throws SQLException {
        boolean createVersion = parentId == null;
        boolean explicitName = name != null;
        Serializable newId = null;
        String sql = this.sqlInfo.getCopyHierSql(explicitName, createVersion);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            newId = this.model.generateNewId();
            ArrayList<Serializable> debugValues = null;
            if (Mapper.isLogEnabled()) {
                debugValues = new ArrayList<Serializable>(4);
            }
            List<Column> columns = this.sqlInfo.getCopyHierColumns(explicitName, createVersion);
            Column whereColumn = this.sqlInfo.getCopyHierWhereColumn();
            ps = this.connection.prepareStatement(sql);
            int i = 1;
            for (Column column : columns) {
                Object v;
                String key = column.getKey();
                if (key.equals("parentid")) {
                    v = parentId;
                } else if (key.equals("name")) {
                    v = name;
                } else if (key.equals("id")) {
                    v = newId;
                } else if (createVersion && (key.equals("baseversionid") || key.equals("ischeckedin"))) {
                    v = null;
                } else {
                    throw new RuntimeException(column.toString());
                }
                column.setToPreparedStatement(ps, i++, (Serializable)v);
                if (debugValues == null) continue;
                debugValues.add((Serializable)v);
            }
            whereColumn.setToPreparedStatement(ps, i, id);
            if (debugValues != null) {
                debugValues.add(id);
                this.logSQL(sql, debugValues);
            }
            int count = ps.executeUpdate();
            this.logCount(count);
            idMap.put(id, newId);
        }
        finally {
            Mapper.closePreparedStatement(ps);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Serializable[]> getChildrenIds(Serializable id, boolean onlyComplex) throws SQLException {
        LinkedList<Serializable[]> childrenIds = new LinkedList<Serializable[]>();
        String sql = this.sqlInfo.getSelectChildrenIdsAndTypesSql(onlyComplex);
        if (Mapper.isLogEnabled()) {
            this.logSQL(sql, Collections.singletonList(id));
        }
        List<Column> columns = this.sqlInfo.getSelectChildrenIdsAndTypesWhatColumns();
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            LinkedList<String> debugValues = null;
            if (Mapper.isLogEnabled()) {
                debugValues = new LinkedList<String>();
            }
            ps.setObject(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Serializable childId = null;
                Serializable childType = null;
                int i = 1;
                for (Column column : columns) {
                    String key = column.getKey();
                    Serializable value = column.getFromResultSet(rs, i++);
                    if (key.equals("id")) {
                        childId = value;
                        continue;
                    }
                    if (!key.equals("primarytype")) continue;
                    childType = value;
                }
                childrenIds.add(new Serializable[]{childId, childType});
                if (debugValues == null) continue;
                debugValues.add(childId + "/" + childType);
            }
            if (debugValues != null) {
                this.log("  -> " + debugValues);
            }
            LinkedList<Serializable[]> linkedList = childrenIds;
            return linkedList;
        }
        finally {
            Mapper.closePreparedStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean copyFragments(String tableName, Set<Serializable> ids, Map<Serializable, Serializable> idMap, Serializable overwriteId) throws SQLException {
        String copySql = this.sqlInfo.getCopySql(tableName);
        Column copyIdColumn = this.sqlInfo.getCopyIdColumn(tableName);
        PreparedStatement copyPs = this.connection.prepareStatement(copySql);
        String deleteSql = this.sqlInfo.getDeleteSql(tableName);
        PreparedStatement deletePs = this.connection.prepareStatement(deleteSql);
        try {
            boolean before = false;
            boolean after = false;
            for (Serializable id : ids) {
                Serializable newId = idMap.get(id);
                boolean overwrite = newId.equals(overwriteId);
                if (overwrite) {
                    if (Mapper.isLogEnabled()) {
                        this.logSQL(deleteSql, Collections.singletonList(newId));
                    }
                    deletePs.setObject(1, newId);
                    int delCount = deletePs.executeUpdate();
                    this.logCount(delCount);
                    before = delCount > 0;
                }
                copyIdColumn.setToPreparedStatement(copyPs, 1, newId);
                copyIdColumn.setToPreparedStatement(copyPs, 2, id);
                if (Mapper.isLogEnabled()) {
                    this.logSQL(copySql, Arrays.asList(newId, id));
                }
                int copyCount = copyPs.executeUpdate();
                this.logCount(copyCount);
                if (!overwrite) continue;
                after = copyCount > 0;
            }
            Boolean bl = after ? Boolean.TRUE : (before ? Boolean.FALSE : null);
            return bl;
        }
        finally {
            Mapper.closePreparedStatement(copyPs);
            Mapper.closePreparedStatement(deletePs);
        }
    }

    public Serializable getVersionByLabel(Serializable versionableId, String label, Context context) throws StorageException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectVersionsByLabel;
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("versionableid", versionableId);
        criteriaMap.put("label", (Serializable)((Object)label));
        List<SimpleFragment> selectRows = this.getSelectRows(select, criteriaMap, context);
        if (selectRows.isEmpty()) {
            return null;
        }
        return selectRows.get(0).getId();
    }

    public SimpleFragment getLastVersion(Serializable versionableId, Context context) throws StorageException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectVersionsByVersionableLastFirst;
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("versionableid", versionableId);
        return this.getSelectRow(select, criteriaMap, context);
    }

    public List<SimpleFragment> getVersions(Serializable versionableId, Context context) throws StorageException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectVersionsByVersionable;
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("versionableid", versionableId);
        return this.getSelectRows(select, criteriaMap, context);
    }

    public List<SimpleFragment> getProxies(Serializable searchId, boolean byTarget, Serializable parentId, Context context) throws StorageException {
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put(byTarget ? "targetid" : "versionableid", searchId);
        if (parentId == null) {
            SQLInfo.SQLInfoSelect select = byTarget ? this.sqlInfo.selectProxiesByTarget : this.sqlInfo.selectProxiesByVersionable;
            return this.getSelectRows(select, criteriaMap, context);
        }
        SQLInfo.SQLInfoSelect select = byTarget ? this.sqlInfo.selectProxiesByTargetAndParent : this.sqlInfo.selectProxiesByVersionableAndParent;
        HashMap<String, Serializable> joinMap = new HashMap<String, Serializable>();
        joinMap.put("parentid", parentId);
        return this.getSelectRows(select, criteriaMap, joinMap, context);
    }

    protected QueryMaker findQueryMaker(String query) throws StorageException {
        List<Class<?>> classes = this.repository.getRepositoryDescriptor().queryMakerClasses;
        if (classes.isEmpty()) {
            classes.add(NXQLQueryMaker.class);
        }
        QueryMaker queryMaker = null;
        for (Class<?> klass : classes) {
            try {
                queryMaker = (QueryMaker)klass.newInstance();
            }
            catch (Exception e) {
                throw new StorageException("Cannot instantiate class: " + klass.getName(), e);
            }
            if (queryMaker.accepts(query)) break;
            queryMaker = null;
        }
        return queryMaker;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal, Session session) throws StorageException {
        PartialList<Serializable> partialList;
        QueryMaker queryMaker = this.findQueryMaker(query);
        if (queryMaker == null) {
            throw new StorageException("No QueryMaker accepts query: " + query);
        }
        QueryMaker.Query q = queryMaker.buildQuery(this.sqlInfo, this.model, session, query, queryFilter, new Object[0]);
        if (q == null) {
            this.log("Query cannot return anything due to conflicting clauses");
            return new PartialList<Serializable>(Collections.emptyList(), 0L);
        }
        long limit = queryFilter.getLimit();
        long offset = queryFilter.getOffset();
        if (Mapper.isLogEnabled()) {
            String sql = q.selectInfo.sql;
            if (limit != 0L) {
                sql = sql + " -- LIMIT " + limit + " OFFSET " + offset;
            }
            if (countTotal) {
                sql = sql + " -- COUNT TOTAL";
            }
            this.logSQL(sql, q.selectParams);
        }
        PreparedStatement ps = null;
        try {
            boolean available;
            ps = this.connection.prepareStatement(q.selectInfo.sql, 1004, 1007);
            int i = 1;
            for (Serializable object : q.selectParams) {
                if (object instanceof Calendar) {
                    Calendar cal = (Calendar)object;
                    Timestamp ts = new Timestamp(cal.getTimeInMillis());
                    ps.setTimestamp(i++, ts, cal);
                    continue;
                }
                if (object instanceof String[]) {
                    Array array = this.sqlInfo.dialect.createArrayOf(12, (Object[])object, this.connection);
                    ps.setArray(i++, array);
                    continue;
                }
                ps.setObject(i++, object);
            }
            ResultSet rs = ps.executeQuery();
            long totalSize = -1L;
            if (limit == 0L || offset == 0L) {
                available = rs.first();
                if (!available) {
                    totalSize = 0L;
                }
                if (limit == 0L) {
                    limit = -1L;
                }
            } else {
                available = rs.absolute((int)offset + 1);
            }
            Column column = q.selectInfo.whatColumns.get(0);
            LinkedList<Serializable> ids = new LinkedList<Serializable>();
            int rowNum = 0;
            while (available && limit != 0L) {
                Serializable id = column.getFromResultSet(rs, 1);
                ids.add(id);
                rowNum = rs.getRow();
                available = rs.next();
                --limit;
            }
            if (countTotal && totalSize == -1L) {
                if (!available && rowNum != 0) {
                    totalSize = rowNum;
                } else {
                    rs.last();
                    totalSize = rs.getRow();
                }
            }
            if (Mapper.isLogEnabled()) {
                AbstractList debugIds = ids;
                String end = "";
                if (ids.size() > 10) {
                    debugIds = new ArrayList(10);
                    i = 0;
                    for (Serializable id : ids) {
                        debugIds.add(id);
                        if (++i != 10) continue;
                    }
                    end = "...(" + ids.size() + " ids)...";
                }
                if (countTotal) {
                    end = end + " (total " + totalSize + ')';
                }
                this.log("  -> " + debugIds + end);
            }
            partialList = new PartialList<Serializable>(ids, totalSize);
            if (ps == null) return partialList;
        }
        catch (SQLException e) {
            try {
                this.checkConnectionReset(e);
                throw new StorageException("Invalid query: " + query, e);
            }
            catch (Throwable throwable) {
                if (ps == null) throw throwable;
                try {
                    Mapper.closePreparedStatement(ps);
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)"Cannot close connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            Mapper.closePreparedStatement(ps);
            return partialList;
        }
        catch (SQLException e) {
            log.error((Object)"Cannot close connection", (Throwable)e);
        }
        return partialList;
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, boolean countTotal, Session session, Object ... params) throws StorageException {
        QueryMaker queryMaker = this.findQueryMaker(queryType);
        if (queryMaker == null) {
            throw new StorageException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        try {
            return new IterableQueryResultImpl(queryMaker, query, queryFilter, session, this, params);
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Invalid query: " + queryType + ": " + query, e);
        }
    }

    public void updateReadAcls() throws StorageException {
        if (!this.sqlInfo.dialect.supportsReadAcl()) {
            return;
        }
        log.debug((Object)"updateReadAcls: updating ...");
        try {
            Statement st = this.connection.createStatement();
            st.execute(this.sqlInfo.dialect.getUpdateReadAclsSql());
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to update read acls", e);
        }
        log.debug((Object)"updateReadAcls: done.");
    }

    public void rebuildReadAcls() throws StorageException {
        if (!this.sqlInfo.dialect.supportsReadAcl()) {
            return;
        }
        log.debug((Object)"rebuildReadAcls: rebuilding ...");
        try {
            Statement st = this.connection.createStatement();
            st.execute(this.sqlInfo.dialect.getRebuildReadAclsSql());
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Failed to rebuild read acls", e);
        }
        log.debug((Object)"rebuildReadAcls: done.");
    }

    protected void start(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.start(xid, flags);
        }
        catch (XAException e) {
            this.checkConnectionReset(e);
            log.error((Object)("XA error on start: " + e.getMessage()));
            throw e;
        }
    }

    protected void end(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.end(xid, flags);
        }
        catch (XAException e) {
            log.error((Object)("XA error on end: " + e.getMessage()));
            throw e;
        }
    }

    protected int prepare(Xid xid) throws XAException {
        try {
            return this.xaresource.prepare(xid);
        }
        catch (XAException e) {
            log.error((Object)("XA error on prepare: " + e.getMessage()));
            throw e;
        }
    }

    protected void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaresource.commit(xid, onePhase);
        }
        catch (XAException e) {
            log.error((Object)("XA error on commit: " + e.getMessage()));
            throw e;
        }
    }

    protected void rollback(Xid xid) throws XAException {
        try {
            this.xaresource.rollback(xid);
        }
        catch (XAException e) {
            log.error((Object)("XA error on rollback: " + e.getMessage()));
            throw e;
        }
    }

    protected void forget(Xid xid) throws XAException {
        this.xaresource.forget(xid);
    }

    protected Xid[] recover(int flag) throws XAException {
        return this.xaresource.recover(flag);
    }

    protected boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaresource.setTransactionTimeout(seconds);
    }

    protected int getTransactionTimeout() throws XAException {
        return this.xaresource.getTransactionTimeout();
    }

    static {
        instanceCounter = new AtomicLong(0L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IterableQueryResultImpl
    implements IterableQueryResult,
    Iterator<Map<String, Serializable>> {
        private final long instanceNumber;
        private QueryMaker.Query q;
        private PreparedStatement ps;
        private ResultSet rs;
        private Map<String, Serializable> next = null;
        private boolean eof;

        protected IterableQueryResultImpl(QueryMaker queryMaker, String query, QueryFilter queryFilter, Session session, Mapper mapper, Object ... params) throws StorageException, SQLException {
            this.instanceNumber = mapper.instanceNumber;
            this.q = queryMaker.buildQuery(mapper.sqlInfo, mapper.model, session, query, queryFilter, params);
            if (this.q == null) {
                this.log("Query cannot return anything due to conflicting clauses");
                this.ps = null;
                this.rs = null;
                this.eof = true;
                return;
            }
            this.eof = false;
            if (Mapper.isLogEnabled()) {
                mapper.logSQL(this.q.selectInfo.sql, this.q.selectParams);
            }
            this.ps = mapper.connection.prepareStatement(this.q.selectInfo.sql, 1004, 1007);
            int i = 1;
            for (Serializable object : this.q.selectParams) {
                if (object instanceof Calendar) {
                    Calendar cal = (Calendar)object;
                    Timestamp ts = new Timestamp(cal.getTimeInMillis());
                    this.ps.setTimestamp(i++, ts, cal);
                    continue;
                }
                if (object instanceof String[]) {
                    Array array = ((Mapper)mapper).sqlInfo.dialect.createArrayOf(12, (Object[])object, mapper.connection);
                    this.ps.setArray(i++, array);
                    continue;
                }
                this.ps.setObject(i++, object);
            }
            this.rs = this.ps.executeQuery();
        }

        private void log(String string) {
            log.trace((Object)("(" + this.instanceNumber + ") SQL: " + string));
        }

        private void logResultSet(ResultSet rs, List<Column> columns) throws SQLException {
            LinkedList<String> res = new LinkedList<String>();
            int i = 1;
            for (Column column : columns) {
                Serializable v = column.getFromResultSet(rs, i++);
                res.add(column.getKey() + "=" + Mapper.loggedValue(v));
            }
            this.log("  -> " + StringUtils.join(res, (String)", "));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.rs != null) {
                try {
                    this.rs.close();
                    Mapper.closePreparedStatement(this.ps);
                }
                catch (SQLException e) {
                    log.error((Object)("Error closing statement: " + e.getMessage()), (Throwable)e);
                }
                finally {
                    this.rs = null;
                    this.ps = null;
                    this.q = null;
                }
            }
        }

        public void skipTo(long skipCount) {
            if (this.rs == null || skipCount < 0L) {
                return;
            }
            try {
                boolean available = this.rs.absolute((int)skipCount + 1);
                if (available) {
                    this.next = this.fetchCurrent();
                    this.eof = false;
                } else {
                    this.next = null;
                    this.eof = true;
                }
            }
            catch (SQLException e) {
                log.error((Object)("Error skipping to: " + skipCount + ": " + e.getMessage()), (Throwable)e);
            }
        }

        public Iterator<Map<String, Serializable>> iterator() {
            return this;
        }

        protected Map<String, Serializable> fetchNext() throws StorageException, SQLException {
            if (this.rs == null) {
                return null;
            }
            if (!this.rs.next()) {
                if (Mapper.isLogEnabled()) {
                    this.log("  -> END");
                }
                this.close();
                return null;
            }
            return this.fetchCurrent();
        }

        protected Map<String, Serializable> fetchCurrent() throws SQLException {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            int i = 1;
            for (Column column : this.q.selectInfo.whatColumns) {
                String key = this.q.selectInfo.whatColumnsAliases == null ? column.getKey() : this.q.selectInfo.whatColumnsAliases.get(i - 1);
                map.put(key, column.getFromResultSet(this.rs, i++));
            }
            if (Mapper.isLogEnabled()) {
                this.logResultSet(this.rs, this.q.selectInfo.whatColumns);
            }
            return map;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.eof) {
                return false;
            }
            try {
                this.next = this.fetchNext();
            }
            catch (Exception e) {
                log.error((Object)("Error fetching next: " + e.getMessage()), (Throwable)e);
            }
            this.eof = this.next == null;
            return !this.eof;
        }

        @Override
        public Map<String, Serializable> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map<String, Serializable> n = this.next;
            this.next = null;
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

