/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.sql.ACLsFragment;
import org.nuxeo.ecm.core.storage.sql.ArrayFragment;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    private static final Log log = LogFactory.getLog(Model.class);
    public static final String ROOT_TYPE = "Root";
    public static final String REPOINFO_TABLE_NAME = "repositories";
    public static final String REPOINFO_REPONAME_KEY = "name";
    public static final String MAIN_KEY = "id";
    public final String hierTableName;
    public final String mainTableName;
    public static final String CLUSTER_NODES_TABLE_NAME = "cluster_nodes";
    public static final String CLUSTER_NODES_NODEID_KEY = "nodeid";
    public static final String CLUSTER_NODES_CREATED_KEY = "created";
    public static final String CLUSTER_INVALS_TABLE_NAME = "cluster_invals";
    public static final String CLUSTER_INVALS_NODEID_KEY = "nodeid";
    public static final String CLUSTER_INVALS_ID_KEY = "id";
    public static final String CLUSTER_INVALS_FRAGMENTS_KEY = "fragments";
    public static final String CLUSTER_INVALS_KIND_KEY = "kind";
    public static final String MAIN_TABLE_NAME = "types";
    public static final String MAIN_PRIMARY_TYPE_PROP = "ecm:primaryType";
    public static final String MAIN_PRIMARY_TYPE_KEY = "primarytype";
    public static final String MAIN_BASE_VERSION_PROP = "ecm:baseVersion";
    public static final String MAIN_BASE_VERSION_KEY = "baseversionid";
    public static final String MAIN_CHECKED_IN_PROP = "ecm:isCheckedIn";
    public static final String MAIN_CHECKED_IN_KEY = "ischeckedin";
    public static final String MAIN_MAJOR_VERSION_PROP = "ecm:majorVersion";
    public static final String MAIN_MAJOR_VERSION_KEY = "majorversion";
    public static final String MAIN_MINOR_VERSION_PROP = "ecm:minorVersion";
    public static final String MAIN_MINOR_VERSION_KEY = "minorversion";
    public static final String UID_SCHEMA_NAME = "uid";
    public static final String UID_MAJOR_VERSION_KEY = "major_version";
    public static final String UID_MINOR_VERSION_KEY = "minor_version";
    public static final String HIER_TABLE_NAME = "hierarchy";
    public static final String HIER_PARENT_KEY = "parentid";
    public static final String HIER_CHILD_NAME_KEY = "name";
    public static final String HIER_CHILD_POS_KEY = "pos";
    public static final String HIER_CHILD_ISPROPERTY_KEY = "isproperty";
    public static final String DESCENDANTS_TABLE_NAME = "descendants";
    public static final String DESCENDANTS_DESCENDANT_KEY = "descendantid";
    public static final String COLL_TABLE_POS_KEY = "pos";
    public static final String COLL_TABLE_VALUE_KEY = "item";
    public static final String MISC_TABLE_NAME = "misc";
    public static final String MISC_LIFECYCLE_POLICY_PROP = "ecm:lifeCyclePolicy";
    public static final String MISC_LIFECYCLE_POLICY_KEY = "lifecyclepolicy";
    public static final String MISC_LIFECYCLE_STATE_PROP = "ecm:lifeCycleState";
    public static final String MISC_LIFECYCLE_STATE_KEY = "lifecyclestate";
    public static final String MISC_DIRTY_PROP = "ecm:dirty";
    public static final String MISC_DIRTY_KEY = "dirty";
    public static final String MISC_WF_IN_PROGRESS_PROP = "ecm:wfInProgress";
    public static final String MISC_WF_IN_PROGRESS_KEY = "wfinprogress";
    public static final String MISC_WF_INC_OPTION_PROP = "ecm:wfIncOption";
    public static final String MISC_WF_INC_OPTION_KEY = "wfincoption";
    public static final String ACL_TABLE_NAME = "acls";
    public static final String ACL_PROP = "ecm:acl";
    public static final String ACL_POS_KEY = "pos";
    public static final String ACL_NAME_KEY = "name";
    public static final String ACL_GRANT_KEY = "grant";
    public static final String ACL_PERMISSION_KEY = "permission";
    public static final String ACL_USER_KEY = "user";
    public static final String ACL_GROUP_KEY = "group";
    public static final String VERSION_TABLE_NAME = "versions";
    public static final String VERSION_VERSIONABLE_PROP = "ecm:versionableId";
    public static final String VERSION_VERSIONABLE_KEY = "versionableid";
    public static final String VERSION_CREATED_PROP = "ecm:versionCreated";
    public static final String VERSION_CREATED_KEY = "created";
    public static final String VERSION_LABEL_PROP = "ecm:versionLabel";
    public static final String VERSION_LABEL_KEY = "label";
    public static final String VERSION_DESCRIPTION_PROP = "ecm:versionDescription";
    public static final String VERSION_DESCRIPTION_KEY = "description";
    public static final String PROXY_TYPE = "ecm:proxy";
    public static final String PROXY_TABLE_NAME = "proxies";
    public static final String PROXY_TARGET_PROP = "ecm:proxyTargetId";
    public static final String PROXY_TARGET_KEY = "targetid";
    public static final String PROXY_VERSIONABLE_PROP = "ecm:proxyVersionableId";
    public static final String PROXY_VERSIONABLE_KEY = "versionableid";
    public static final String LOCK_TABLE_NAME = "locks";
    public static final String LOCK_PROP = "ecm:lock";
    public static final String LOCK_KEY = "lock";
    public static final String FULLTEXT_DEFAULT_INDEX = "default";
    public static final String FULLTEXT_TABLE_NAME = "fulltext";
    public static final String FULLTEXT_FULLTEXT_PROP = "ecm:fulltext";
    public static final String FULLTEXT_FULLTEXT_KEY = "fulltext";
    public static final String FULLTEXT_SIMPLETEXT_PROP = "ecm:simpleText";
    public static final String FULLTEXT_SIMPLETEXT_KEY = "simpletext";
    public static final String FULLTEXT_BINARYTEXT_PROP = "ecm:binaryText";
    public static final String FULLTEXT_BINARYTEXT_KEY = "binarytext";
    public static final String HIER_READ_ACL_TABLE_NAME = "hierarchy_read_acl";
    public static final String HIER_READ_ACL_ID = "id";
    public static final String HIER_READ_ACL_ACL_ID = "acl_id";
    public static final String FIELD_TYPE_LARGETEXT = "largetext";
    public static final List<String> COMMON_SIMPLE_FRAGMENTS = Collections.singletonList("misc");
    public static final String[] COMMON_COLLECTION_FRAGMENTS = new String[]{"acls"};
    public static final String[] ALWAYS_PREFETCHED_FRAGMENTS = new String[]{"acls", "versions", "locks", "misc"};
    private final BinaryManager binaryManager;
    protected final RepositoryDescriptor repositoryDescriptor;
    private final Dialect dialect;
    public final RepositoryDescriptor.IdGenPolicy idGenPolicy;
    protected final boolean separateMainTable;
    private final AtomicLong temporaryIdCounter;
    private final Map<String, Type> specialPropertyTypes;
    private final HashMap<String, Map<String, PropertyInfo>> schemaPropertyInfos;
    private final Map<String, PropertyInfo> sharedPropertyInfos;
    private final Map<String, PropertyInfo> mergedPropertyInfos;
    private final Map<String, Map<String, PropertyInfo>> pathPropertyInfos;
    private final Map<String, Set<String>> typeSimpleTextPaths;
    private final Map<String, PropertyInfo> allPathPropertyInfos;
    private final Map<String, Map<String, ColumnType>> fragmentsKeys;
    private final Map<String, PropertyType> collectionTables;
    private final Map<String, CollectionFragment.CollectionMaker> collectionMakers;
    private final Map<String, String> collectionOrderBy;
    private final Map<String, String> schemaFragment;
    protected final Map<String, Set<String>> typeSimpleFragments;
    protected final Map<String, Set<String>> typeCollectionFragments;
    protected final Map<String, Set<String>> typeFragments;
    protected final Map<String, Set<String>> typePrefetchedFragments;
    protected final Map<String, Set<String>> documentTypesFacets;
    protected final Map<String, String> documentSuperTypes;
    protected final Map<String, Set<String>> documentSubTypes;
    protected final Map<String, Set<String>> fieldFragments;
    protected final FulltextInfo fulltextInfo;

    public Model(RepositoryImpl repository, SchemaManager schemaManager, Dialect dialect) {
        this.binaryManager = repository.getBinaryManager();
        this.repositoryDescriptor = repository.getRepositoryDescriptor();
        this.idGenPolicy = this.repositoryDescriptor.idGenPolicy;
        this.separateMainTable = this.repositoryDescriptor.separateMainTable;
        this.dialect = dialect;
        this.temporaryIdCounter = new AtomicLong(0L);
        this.hierTableName = HIER_TABLE_NAME;
        this.mainTableName = this.separateMainTable ? MAIN_TABLE_NAME : HIER_TABLE_NAME;
        this.schemaPropertyInfos = new HashMap();
        this.sharedPropertyInfos = new HashMap<String, PropertyInfo>();
        this.mergedPropertyInfos = new HashMap<String, PropertyInfo>();
        this.pathPropertyInfos = new HashMap<String, Map<String, PropertyInfo>>();
        this.typeSimpleTextPaths = new HashMap<String, Set<String>>();
        this.allPathPropertyInfos = new HashMap<String, PropertyInfo>();
        this.fulltextInfo = new FulltextInfo();
        this.fragmentsKeys = new HashMap<String, Map<String, ColumnType>>();
        this.collectionTables = new HashMap<String, PropertyType>();
        this.collectionOrderBy = new HashMap<String, String>();
        this.collectionMakers = new HashMap<String, CollectionFragment.CollectionMaker>();
        this.schemaFragment = new HashMap<String, String>();
        this.typeFragments = new HashMap<String, Set<String>>();
        this.typeSimpleFragments = new HashMap<String, Set<String>>();
        this.typeCollectionFragments = new HashMap<String, Set<String>>();
        this.typePrefetchedFragments = new HashMap<String, Set<String>>();
        this.fieldFragments = new HashMap<String, Set<String>>();
        this.documentTypesFacets = new HashMap<String, Set<String>>();
        this.documentSuperTypes = new HashMap<String, String>();
        this.documentSubTypes = new HashMap<String, Set<String>>();
        this.specialPropertyTypes = new HashMap<String, Type>();
        this.initMainModel();
        this.initVersionsModel();
        this.initProxiesModel();
        this.initLocksModel();
        this.initAclModel();
        this.initMiscModel();
        this.initModels(schemaManager);
        if (!this.repositoryDescriptor.fulltextDisabled) {
            this.initFullTextModel();
        }
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public Binary getBinary(String digest) {
        return this.binaryManager.getBinary(digest);
    }

    public Serializable generateNewId() {
        switch (this.idGenPolicy) {
            case APP_UUID: {
                return UUID.randomUUID().toString();
            }
            case DB_IDENTITY: {
                return "T" + this.temporaryIdCounter.incrementAndGet();
            }
        }
        throw new AssertionError((Object)this.idGenPolicy);
    }

    public Serializable unHackStringId(String id) {
        switch (this.idGenPolicy) {
            case APP_UUID: {
                return id;
            }
            case DB_IDENTITY: {
                if (id.startsWith("T")) {
                    return id;
                }
                return Long.valueOf(id);
            }
        }
        throw new AssertionError((Object)this.idGenPolicy);
    }

    private void addPropertyInfo(String schemaName, String propertyName, PropertyType propertyType, String fragmentName, String fragmentKey, boolean readonly, Type coreType, ColumnType type) {
        PropertyInfo previous;
        Map<String, PropertyInfo> propertyInfos;
        if (schemaName == null) {
            propertyInfos = this.sharedPropertyInfos;
        } else {
            propertyInfos = this.schemaPropertyInfos.get(schemaName);
            if (propertyInfos == null) {
                propertyInfos = new HashMap<String, PropertyInfo>();
                this.schemaPropertyInfos.put(schemaName, propertyInfos);
            }
        }
        PropertyInfo propertyInfo = new PropertyInfo(propertyType, fragmentName, fragmentKey, readonly);
        propertyInfos.put(propertyName, propertyInfo);
        if (fragmentKey != null) {
            Map<String, ColumnType> fragmentKeys = this.fragmentsKeys.get(fragmentName);
            if (fragmentKeys == null) {
                fragmentKeys = new LinkedHashMap<String, ColumnType>();
                this.fragmentsKeys.put(fragmentName, fragmentKeys);
            }
            fragmentKeys.put(fragmentKey, type);
        }
        if (coreType != null) {
            this.specialPropertyTypes.put(propertyName, coreType);
        }
        if ((previous = this.mergedPropertyInfos.get(propertyName)) == null) {
            this.mergedPropertyInfos.put(propertyName, propertyInfo);
        } else {
            log.debug((Object)String.format("Schemas '%s' and '%s' both have a property '%s', unqualified reference in queries will use schema '%1$s'", previous.fragmentName, fragmentName, propertyName));
        }
        if (!propertyName.contains(":") && (previous = this.mergedPropertyInfos.get(propertyName = schemaName + ':' + propertyName)) == null) {
            this.mergedPropertyInfos.put(propertyName, propertyInfo);
        }
    }

    private void inferTypePropertyInfos(String typeName, String[] schemaNames) {
        Map<String, PropertyInfo> propertyInfos = this.schemaPropertyInfos.get(typeName);
        if (propertyInfos == null) {
            propertyInfos = new HashMap<String, PropertyInfo>();
            this.schemaPropertyInfos.put(typeName, propertyInfos);
        }
        for (String schemaName : schemaNames) {
            Map<String, PropertyInfo> infos = this.schemaPropertyInfos.get(schemaName);
            if (infos == null) continue;
            for (Map.Entry<String, PropertyInfo> info : infos.entrySet()) {
                propertyInfos.put(info.getKey(), info.getValue());
            }
        }
    }

    private void inferTypePropertyPaths(DocumentType documentType) {
        String typeName = documentType.getName();
        HashMap<String, PropertyInfo> propertyInfoByPath = new HashMap<String, PropertyInfo>();
        for (Schema schema : documentType.getSchemas()) {
            if (schema == null) continue;
            this.inferTypePropertyPaths((ComplexType)schema, "", propertyInfoByPath, null);
        }
        this.pathPropertyInfos.put(typeName, propertyInfoByPath);
        this.allPathPropertyInfos.putAll(propertyInfoByPath);
        HashSet simplePaths = new HashSet();
        for (Map.Entry entry : propertyInfoByPath.entrySet()) {
            PropertyInfo pi = (PropertyInfo)entry.getValue();
            if (pi.propertyType != PropertyType.STRING && pi.propertyType != PropertyType.ARRAY_STRING) continue;
            simplePaths.add(entry.getKey());
        }
        this.typeSimpleTextPaths.put(typeName, simplePaths);
    }

    private void inferTypePropertyPaths(ComplexType complexType, String prefix, Map<String, PropertyInfo> propertyInfoByPath, Set<String> done) {
        String typeName;
        if (done == null) {
            done = new LinkedHashSet<String>();
        }
        if (done.contains(typeName = complexType.getName())) {
            log.warn((Object)("Complex type " + typeName + " refers to itself recursively: " + done));
            return;
        }
        done.add(typeName);
        for (Field field : complexType.getFields()) {
            Type listFieldType;
            String propertyName = field.getName().getPrefixedName();
            String path = prefix + propertyName;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                this.inferTypePropertyPaths((ComplexType)fieldType, path + '/', propertyInfoByPath, done);
                continue;
            }
            if (fieldType.isListType() && !(listFieldType = ((ListType)fieldType).getFieldType()).isSimpleType()) {
                this.inferTypePropertyPaths((ComplexType)listFieldType, path + "/*/", propertyInfoByPath, done);
                continue;
            }
            PropertyInfo pi = this.schemaPropertyInfos.get(typeName).get(propertyName);
            propertyInfoByPath.put(path, pi);
        }
        done.remove(typeName);
    }

    private void inferFulltextInfo() {
        List<RepositoryDescriptor.FulltextIndexDescriptor> descs = this.repositoryDescriptor.fulltextIndexes;
        if (descs == null) {
            descs = new ArrayList<RepositoryDescriptor.FulltextIndexDescriptor>(1);
        }
        if (descs.isEmpty()) {
            descs.add(new RepositoryDescriptor.FulltextIndexDescriptor());
        }
        for (RepositoryDescriptor.FulltextIndexDescriptor desc : descs) {
            String name = desc.name == null ? FULLTEXT_DEFAULT_INDEX : desc.name;
            this.fulltextInfo.indexNames.add(name);
            this.fulltextInfo.indexAnalyzer.put(name, desc.analyzer == null ? this.repositoryDescriptor.fulltextAnalyzer : desc.analyzer);
            this.fulltextInfo.indexCatalog.put(name, desc.catalog == null ? this.repositoryDescriptor.fulltextCatalog : desc.catalog);
            if (desc.fields == null) {
                desc.fields = new HashSet<String>();
            }
            if (desc.excludeFields == null) {
                desc.excludeFields = new HashSet<String>();
            }
            if (desc.fieldType != null) {
                if (desc.fieldType.equals("string")) {
                    this.fulltextInfo.indexesAllSimple.add(name);
                } else if (desc.fieldType.equals("blob")) {
                    this.fulltextInfo.indexesAllBinary.add(name);
                } else {
                    log.error((Object)("Ignoring unknow repository fulltext configuration fieldType: " + desc.fieldType));
                }
            }
            if (desc.fields.isEmpty() && desc.fieldType == null) {
                this.fulltextInfo.indexesAllSimple.add(name);
                this.fulltextInfo.indexesAllBinary.add(name);
            }
            for (Set fields : Arrays.asList(desc.fields, desc.excludeFields)) {
                for (String path : fields) {
                    Map<String, Set<String>> propPathsByIndex;
                    Map<String, Set<String>> indexesByPropPath;
                    PropertyInfo pi = this.allPathPropertyInfos.get(path);
                    if (pi == null) {
                        log.error((Object)String.format("Ignoring unknown property '%s' in fulltext configuration: %s", path, name));
                        continue;
                    }
                    if (pi.propertyType == PropertyType.STRING || pi.propertyType == PropertyType.ARRAY_STRING) {
                        indexesByPropPath = fields == desc.fields ? this.fulltextInfo.indexesByPropPathSimple : this.fulltextInfo.indexesByPropPathExcludedSimple;
                        propPathsByIndex = fields == desc.fields ? this.fulltextInfo.propPathsByIndexSimple : this.fulltextInfo.propPathsExcludedByIndexSimple;
                    } else if (pi.propertyType == PropertyType.BINARY) {
                        indexesByPropPath = fields == desc.fields ? this.fulltextInfo.indexesByPropPathBinary : this.fulltextInfo.indexesByPropPathExcludedBinary;
                        propPathsByIndex = fields == desc.fields ? this.fulltextInfo.propPathsByIndexBinary : this.fulltextInfo.propPathsExcludedByIndexBinary;
                    } else {
                        log.error((Object)String.format("Ignoring property '%s' with bad type %s in fulltext configuration: %s", new Object[]{path, pi.propertyType, name}));
                        continue;
                    }
                    Set<String> indexes = indexesByPropPath.get(path);
                    if (indexes == null) {
                        indexes = new HashSet<String>();
                        indexesByPropPath.put(path, indexes);
                    }
                    indexes.add(name);
                    Set<String> paths = propPathsByIndex.get(name);
                    if (paths == null) {
                        paths = new LinkedHashSet<String>();
                        propPathsByIndex.put(name, paths);
                    }
                    paths.add(path);
                }
            }
        }
    }

    public PropertyInfo getPropertyInfo(String schemaName, String propertyName) {
        Map<String, PropertyInfo> propertyInfos = this.schemaPropertyInfos.get(schemaName);
        if (propertyInfos == null) {
            return null;
        }
        PropertyInfo propertyInfo = propertyInfos.get(propertyName);
        return propertyInfo != null ? propertyInfo : this.sharedPropertyInfos.get(propertyName);
    }

    public PropertyInfo getPropertyInfo(String propertyName) {
        return this.mergedPropertyInfos.get(propertyName);
    }

    public Set<String> getPropertyInfoNames() {
        return this.mergedPropertyInfos.keySet();
    }

    public PropertyInfo getPathPropertyInfo(String typeName, String path) {
        Map<String, PropertyInfo> propertyInfoByPath = this.pathPropertyInfos.get(typeName);
        if (propertyInfoByPath == null) {
            return null;
        }
        return propertyInfoByPath.get(path);
    }

    public Set<String> getTypeSimpleTextPropertyPaths(String typeName) {
        return this.typeSimpleTextPaths.get(typeName);
    }

    public FulltextInfo getFulltextInfo() {
        return this.fulltextInfo;
    }

    public PropertyType getFulltextFieldType(String fragmentName, String fragmentKey) {
        if (fragmentKey == null) {
            PropertyType type = this.collectionTables.get(fragmentName);
            if (type == PropertyType.ARRAY_STRING || type == PropertyType.ARRAY_BINARY) {
                return type.getArrayBaseType();
            }
            return null;
        }
        Map<String, PropertyInfo> infos = this.schemaPropertyInfos.get(fragmentName);
        if (infos == null) {
            return null;
        }
        PropertyInfo info = infos.get(fragmentKey);
        if (info != null && info.fulltext) {
            return info.propertyType;
        }
        return null;
    }

    private void addCollectionFragmentInfos(String fragmentName, PropertyType propertyType, CollectionFragment.CollectionMaker maker, String orderBy, Map<String, ColumnType> keysType) {
        this.collectionTables.put(fragmentName, propertyType);
        this.collectionMakers.put(fragmentName, maker);
        this.collectionOrderBy.put(fragmentName, orderBy);
        Map<String, ColumnType> old = this.fragmentsKeys.get(fragmentName);
        if (old == null) {
            this.fragmentsKeys.put(fragmentName, keysType);
        } else {
            old.putAll(keysType);
        }
    }

    public Type getSpecialPropertyType(String propertyName) {
        return this.specialPropertyTypes.get(propertyName);
    }

    public PropertyType getCollectionFragmentType(String fragmentName) {
        return this.collectionTables.get(fragmentName);
    }

    public boolean isCollectionFragment(String fragmentName) {
        return this.collectionTables.containsKey(fragmentName);
    }

    public String getCollectionOrderBy(String fragmentName) {
        return this.collectionOrderBy.get(fragmentName);
    }

    public Set<String> getFragmentNames() {
        return this.fragmentsKeys.keySet();
    }

    public Map<String, ColumnType> getFragmentKeysType(String fragmentName) {
        return this.fragmentsKeys.get(fragmentName);
    }

    public Serializable[] newCollectionArray(ResultSet rs, List<Column> columns, Context context) throws SQLException {
        CollectionFragment.CollectionMaker maker = this.collectionMakers.get(context.getTableName());
        if (maker == null) {
            throw new IllegalArgumentException(context.getTableName());
        }
        return maker.makeArray(rs, columns, context, this);
    }

    public Map<Serializable, Serializable[]> newCollectionArrays(ResultSet rs, List<Column> columns, Context context) throws SQLException {
        CollectionFragment.CollectionMaker maker = this.collectionMakers.get(context.getTableName());
        if (maker == null) {
            throw new IllegalArgumentException(context.getTableName());
        }
        return maker.makeArrays(rs, columns, context, this);
    }

    public CollectionFragment newCollectionFragment(Serializable id, Serializable[] array, Context context) {
        CollectionFragment.CollectionMaker maker = this.collectionMakers.get(context.getTableName());
        if (maker == null) {
            throw new IllegalArgumentException(context.getTableName());
        }
        return maker.makeCollection(id, array, context);
    }

    public CollectionFragment newEmptyCollectionFragment(Serializable id, Context context) {
        CollectionFragment.CollectionMaker maker = this.collectionMakers.get(context.getTableName());
        if (maker == null) {
            throw new IllegalArgumentException(context.getTableName());
        }
        return maker.makeEmpty(id, context, this);
    }

    protected void addTypeSimpleFragment(String typeName, String fragmentName) {
        Set<String> fragments = this.typeSimpleFragments.get(typeName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.typeSimpleFragments.put(typeName, fragments);
        }
        if (fragmentName != null) {
            fragments.add(fragmentName);
        }
        this.addTypeFragment(typeName, fragmentName);
    }

    protected void addTypeCollectionFragment(String typeName, String fragmentName) {
        Set<String> fragments = this.typeCollectionFragments.get(typeName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.typeCollectionFragments.put(typeName, fragments);
        }
        fragments.add(fragmentName);
        this.addTypeFragment(typeName, fragmentName);
    }

    protected void addTypeFragment(String typeName, String fragmentName) {
        Set<String> fragments = this.typeFragments.get(typeName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.typeFragments.put(typeName, fragments);
        }
        if (fragmentName != null) {
            fragments.add(fragmentName);
        }
    }

    protected void addFieldFragment(Field field, String fragmentName) {
        String fieldName = field.getName().toString();
        Set<String> fragments = this.fieldFragments.get(fieldName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.fieldFragments.put(fieldName, fragments);
        }
        fragments.add(fragmentName);
    }

    protected void addTypePrefetchedFragment(String typeName, String fragmentName) {
        Set<String> fragments = this.typePrefetchedFragments.get(typeName);
        if (fragments == null) {
            fragments = new HashSet<String>();
            this.typePrefetchedFragments.put(typeName, fragments);
        }
        fragments.add(fragmentName);
    }

    public Set<String> getTypeSimpleFragments(String typeName) {
        return this.typeSimpleFragments.get(typeName);
    }

    public Set<String> getTypeFragments(String typeName) {
        return this.typeFragments.get(typeName);
    }

    protected Set<String> getFieldFragments(Field field) {
        return this.fieldFragments.get(field.getName().toString());
    }

    public Set<String> getTypePrefetchedFragments(String typeName) {
        return this.typePrefetchedFragments.get(typeName);
    }

    public boolean isType(String typeName) {
        return this.typeFragments.containsKey(typeName);
    }

    public boolean isDocumentType(String typeName) {
        return this.documentTypesFacets.containsKey(typeName);
    }

    public String getDocumentSuperType(String typeName) {
        return this.documentSuperTypes.get(typeName);
    }

    public Set<String> getDocumentSubTypes(String typeName) {
        return this.documentSubTypes.get(typeName);
    }

    public Set<String> getDocumentTypeFacets(String typeName) {
        Set<String> facets = this.documentTypesFacets.get(typeName);
        return facets == null ? Collections.emptySet() : facets;
    }

    public Map<String, Set<Serializable>> getPerFragmentIds(Map<Serializable, String> idType) {
        HashMap<String, Set<Serializable>> allFragmentIds = new HashMap<String, Set<Serializable>>();
        for (Map.Entry<Serializable, String> e : idType.entrySet()) {
            Serializable id = e.getKey();
            String type = e.getValue();
            Set<String> fragmentNames = this.getTypeFragments(type);
            if (fragmentNames == null) continue;
            for (String fragmentName : fragmentNames) {
                HashSet<Serializable> fragmentIds = (HashSet<Serializable>)allFragmentIds.get(fragmentName);
                if (fragmentIds == null) {
                    fragmentIds = new HashSet<Serializable>();
                    allFragmentIds.put(fragmentName, fragmentIds);
                }
                fragmentIds.add(id);
            }
        }
        return allFragmentIds;
    }

    private PropertyType mainIdType() {
        switch (this.idGenPolicy) {
            case APP_UUID: {
                return PropertyType.STRING;
            }
            case DB_IDENTITY: {
                return PropertyType.LONG;
            }
        }
        throw new AssertionError((Object)this.idGenPolicy);
    }

    private void initModels(SchemaManager schemaManager) {
        log.debug((Object)("Schemas fields from descriptor: " + this.repositoryDescriptor.schemaFields));
        for (DocumentType documentType : schemaManager.getDocumentTypes()) {
            String typeName = documentType.getName();
            this.addTypeSimpleFragment(typeName, null);
            for (Schema schema : documentType.getSchemas()) {
                if (schema == null) continue;
                String fragmentName = this.initTypeModel((ComplexType)schema);
                this.addTypeSimpleFragment(typeName, fragmentName);
                Set<String> cols = this.typeCollectionFragments.get(schema.getName());
                if (cols == null) continue;
                for (String string : cols) {
                    this.addTypeCollectionFragment(typeName, string);
                }
            }
            this.inferTypePropertyInfos(typeName, documentType.getSchemaNames());
            this.inferTypePropertyPaths(documentType);
            for (String fragmentName : this.getCommonSimpleFragments()) {
                this.addTypeSimpleFragment(typeName, fragmentName);
            }
            for (String fragmentName : COMMON_COLLECTION_FRAGMENTS) {
                this.addTypeCollectionFragment(typeName, fragmentName);
            }
            PrefetchInfo prefetch = documentType.getPrefetchInfo();
            if (prefetch != null) {
                Set<String> typeFragments = this.getTypeFragments(typeName);
                for (Field field : prefetch.getFields()) {
                    Set<String> fragments = this.getFieldFragments(field);
                    if (fragments == null) continue;
                    for (String fragment : fragments) {
                        if (!typeFragments.contains(fragment)) continue;
                        this.addTypePrefetchedFragment(typeName, fragment);
                    }
                }
                for (Field field : prefetch.getSchemas()) {
                    Set<String> collectionFragments;
                    String fragment = this.schemaFragment.get(field.getName());
                    if (fragment != null) {
                        this.addTypePrefetchedFragment(typeName, fragment);
                    }
                    if ((collectionFragments = this.typeCollectionFragments.get(typeName)) == null) continue;
                    for (String fragmentName : collectionFragments) {
                        this.addTypePrefetchedFragment(typeName, fragmentName);
                    }
                }
            }
            for (String fragmentName : ALWAYS_PREFETCHED_FRAGMENTS) {
                this.addTypePrefetchedFragment(typeName, fragmentName);
            }
            log.debug((Object)("Fragments for " + typeName + ": " + this.getTypeFragments(typeName) + ", prefetch: " + this.getTypePrefetchedFragments(typeName)));
            this.documentTypesFacets.put(typeName, new HashSet(documentType.getFacets()));
            Type superType = documentType.getSuperType();
            if (superType == null) continue;
            String superTypeName = superType.getName();
            this.documentSuperTypes.put(typeName, superTypeName);
        }
        Iterator<String> i$ = this.documentTypesFacets.keySet().iterator();
        while (i$.hasNext()) {
            String type;
            String superType = type = i$.next();
            do {
                Set<String> subTypes;
                if ((subTypes = this.documentSubTypes.get(superType)) == null) {
                    subTypes = new HashSet<String>();
                    this.documentSubTypes.put(superType, subTypes);
                }
                subTypes.add(type);
            } while ((superType = this.documentSuperTypes.get(superType)) != null);
        }
        if (!this.repositoryDescriptor.fulltextDisabled) {
            this.inferFulltextInfo();
        }
    }

    protected List<String> getCommonSimpleFragments() {
        List<String> fragments = COMMON_SIMPLE_FRAGMENTS;
        if (!this.repositoryDescriptor.fulltextDisabled) {
            fragments = new ArrayList<String>(fragments);
            fragments.add("fulltext");
        }
        return fragments;
    }

    private void initMainModel() {
        this.addPropertyInfo(null, MAIN_PRIMARY_TYPE_PROP, PropertyType.STRING, this.mainTableName, MAIN_PRIMARY_TYPE_KEY, true, null, ColumnType.SYSNAME);
        this.addPropertyInfo(null, MAIN_CHECKED_IN_PROP, PropertyType.BOOLEAN, this.mainTableName, MAIN_CHECKED_IN_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(null, MAIN_BASE_VERSION_PROP, this.mainIdType(), this.mainTableName, MAIN_BASE_VERSION_KEY, false, (Type)StringType.INSTANCE, ColumnType.NODEVAL);
        this.addPropertyInfo(null, MAIN_MAJOR_VERSION_PROP, PropertyType.LONG, this.mainTableName, MAIN_MAJOR_VERSION_KEY, false, (Type)LongType.INSTANCE, ColumnType.INTEGER);
        this.addPropertyInfo(null, MAIN_MINOR_VERSION_PROP, PropertyType.LONG, this.mainTableName, MAIN_MINOR_VERSION_KEY, false, (Type)LongType.INSTANCE, ColumnType.INTEGER);
    }

    private void initMiscModel() {
        this.addPropertyInfo(null, MISC_LIFECYCLE_POLICY_PROP, PropertyType.STRING, MISC_TABLE_NAME, MISC_LIFECYCLE_POLICY_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(null, MISC_LIFECYCLE_STATE_PROP, PropertyType.STRING, MISC_TABLE_NAME, MISC_LIFECYCLE_STATE_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(null, MISC_DIRTY_PROP, PropertyType.BOOLEAN, MISC_TABLE_NAME, MISC_DIRTY_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(null, MISC_WF_IN_PROGRESS_PROP, PropertyType.BOOLEAN, MISC_TABLE_NAME, MISC_WF_IN_PROGRESS_KEY, false, (Type)BooleanType.INSTANCE, ColumnType.BOOLEAN);
        this.addPropertyInfo(null, MISC_WF_INC_OPTION_PROP, PropertyType.STRING, MISC_TABLE_NAME, MISC_WF_INC_OPTION_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
    }

    private void initVersionsModel() {
        this.addPropertyInfo(null, VERSION_VERSIONABLE_PROP, this.mainIdType(), VERSION_TABLE_NAME, "versionableid", false, (Type)StringType.INSTANCE, ColumnType.NODEVAL);
        this.addPropertyInfo(null, VERSION_CREATED_PROP, PropertyType.DATETIME, VERSION_TABLE_NAME, "created", false, (Type)DateType.INSTANCE, ColumnType.TIMESTAMP);
        this.addPropertyInfo(null, VERSION_LABEL_PROP, PropertyType.STRING, VERSION_TABLE_NAME, VERSION_LABEL_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
        this.addPropertyInfo(null, VERSION_DESCRIPTION_PROP, PropertyType.STRING, VERSION_TABLE_NAME, VERSION_DESCRIPTION_KEY, false, (Type)StringType.INSTANCE, ColumnType.VARCHAR);
    }

    private void initProxiesModel() {
        this.addPropertyInfo(PROXY_TYPE, PROXY_TARGET_PROP, this.mainIdType(), PROXY_TABLE_NAME, PROXY_TARGET_KEY, false, null, ColumnType.NODEIDFKNP);
        this.addPropertyInfo(PROXY_TYPE, PROXY_VERSIONABLE_PROP, this.mainIdType(), PROXY_TABLE_NAME, "versionableid", false, null, ColumnType.NODEVAL);
        this.addTypeSimpleFragment(PROXY_TYPE, PROXY_TABLE_NAME);
    }

    private void initLocksModel() {
        this.addPropertyInfo(null, LOCK_PROP, PropertyType.STRING, LOCK_TABLE_NAME, LOCK_KEY, false, (Type)StringType.INSTANCE, ColumnType.SYSNAME);
    }

    private void initFullTextModel() {
        for (String indexName : this.fulltextInfo.indexNames) {
            String suffix = this.getFulltextIndexSuffix(indexName);
            if (this.dialect.getMaterializeFulltextSyntheticColumn()) {
                this.addPropertyInfo(null, FULLTEXT_FULLTEXT_PROP + suffix, PropertyType.STRING, "fulltext", "fulltext" + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTINDEXED);
            }
            this.addPropertyInfo(null, FULLTEXT_SIMPLETEXT_PROP + suffix, PropertyType.STRING, "fulltext", FULLTEXT_SIMPLETEXT_KEY + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTSTORED);
            this.addPropertyInfo(null, FULLTEXT_BINARYTEXT_PROP + suffix, PropertyType.STRING, "fulltext", FULLTEXT_BINARYTEXT_KEY + suffix, false, (Type)StringType.INSTANCE, ColumnType.FTSTORED);
        }
    }

    public String getFulltextIndexSuffix(String indexName) {
        return indexName.equals(FULLTEXT_DEFAULT_INDEX) ? "" : '_' + indexName;
    }

    private void initAclModel() {
        LinkedHashMap<String, ColumnType> keysType = new LinkedHashMap<String, ColumnType>();
        keysType.put("pos", ColumnType.INTEGER);
        keysType.put("name", ColumnType.SYSNAME);
        keysType.put(ACL_GRANT_KEY, ColumnType.BOOLEAN);
        keysType.put(ACL_PERMISSION_KEY, ColumnType.SYSNAME);
        keysType.put(ACL_USER_KEY, ColumnType.SYSNAME);
        keysType.put(ACL_GROUP_KEY, ColumnType.SYSNAME);
        String fragmentName = ACL_TABLE_NAME;
        this.addCollectionFragmentInfos(fragmentName, PropertyType.COLL_ACL, ACLsFragment.MAKER, "pos", keysType);
        this.addPropertyInfo(null, ACL_PROP, PropertyType.COLL_ACL, fragmentName, null, false, null, null);
    }

    private String initTypeModel(ComplexType complexType) {
        String typeName = complexType.getName();
        if (this.schemaFragment.containsKey(typeName)) {
            return this.schemaFragment.get(typeName);
        }
        log.debug((Object)("Making model for type " + typeName));
        String thisFragmentName = null;
        for (Field field : complexType.getFields()) {
            String subFragmentName;
            Type fieldType = field.getType();
            if (fieldType.isComplexType()) {
                ComplexType fieldComplexType = (ComplexType)fieldType;
                String subTypeName = fieldComplexType.getName();
                subFragmentName = this.initTypeModel(fieldComplexType);
                this.addTypeSimpleFragment(subTypeName, subFragmentName);
                continue;
            }
            String propertyName = field.getName().getPrefixedName();
            if (fieldType.isListType()) {
                Type listFieldType = ((ListType)fieldType).getFieldType();
                if (listFieldType.isSimpleType()) {
                    String fragmentName = this.collectionFragmentName(propertyName);
                    PropertyType propertyType = PropertyType.fromFieldType(listFieldType, true);
                    ColumnType type = ColumnType.fromFieldType(listFieldType);
                    this.addPropertyInfo(typeName, propertyName, propertyType, fragmentName, null, false, null, null);
                    LinkedHashMap<String, ColumnType> keysType = new LinkedHashMap<String, ColumnType>();
                    keysType.put("pos", ColumnType.INTEGER);
                    keysType.put(COLL_TABLE_VALUE_KEY, type);
                    this.addCollectionFragmentInfos(fragmentName, propertyType, ArrayFragment.MAKER, "pos", keysType);
                    this.addTypeCollectionFragment(typeName, fragmentName);
                    this.addFieldFragment(field, fragmentName);
                    continue;
                }
                subFragmentName = this.initTypeModel((ComplexType)listFieldType);
                this.addTypeSimpleFragment(listFieldType.getName(), subFragmentName);
                continue;
            }
            String fragmentName = this.typeFragmentName(complexType);
            PropertyType propertyType = PropertyType.fromFieldType(fieldType, false);
            ColumnType type = ColumnType.fromFieldType(fieldType);
            if (type == ColumnType.VARCHAR) {
                for (RepositoryDescriptor.FieldDescriptor fd : this.repositoryDescriptor.schemaFields) {
                    if (!propertyName.equals(fd.field) || !FIELD_TYPE_LARGETEXT.equals(fd.type)) continue;
                    type = ColumnType.CLOB;
                }
                log.debug((Object)("  String field '" + propertyName + "' using column type " + (Object)((Object)type)));
            }
            String fragmentKey = field.getName().getLocalName();
            if (fragmentName.equals(UID_SCHEMA_NAME) && (fragmentKey.equals(UID_MAJOR_VERSION_KEY) || fragmentKey.equals(UID_MINOR_VERSION_KEY))) {
                fragmentKey = fragmentKey.equals(UID_MAJOR_VERSION_KEY) ? MAIN_MAJOR_VERSION_KEY : MAIN_MINOR_VERSION_KEY;
                this.addPropertyInfo(typeName, propertyName, propertyType, this.mainTableName, fragmentKey, false, null, type);
            } else {
                this.addPropertyInfo(typeName, propertyName, propertyType, fragmentName, fragmentKey, false, null, type);
                thisFragmentName = fragmentName;
            }
            this.addFieldFragment(field, fragmentName);
        }
        this.schemaFragment.put(typeName, thisFragmentName);
        return thisFragmentName;
    }

    private String typeFragmentName(ComplexType type) {
        return type.getName();
    }

    private String collectionFragmentName(String propertyName) {
        return propertyName;
    }

    public static class FulltextInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String PROP_TYPE_STRING = "string";
        public static final String PROP_TYPE_BLOB = "blob";
        public Set<String> indexNames = new LinkedHashSet<String>();
        public Map<String, String> indexAnalyzer = new HashMap<String, String>();
        public Map<String, String> indexCatalog = new HashMap<String, String>();
        public Set<String> indexesAllSimple = new HashSet<String>();
        public Set<String> indexesAllBinary = new HashSet<String>();
        public Map<String, Set<String>> indexesByPropPathSimple = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> indexesByPropPathBinary = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> indexesByPropPathExcludedSimple = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> indexesByPropPathExcludedBinary = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> propPathsByIndexSimple = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> propPathsByIndexBinary = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> propPathsExcludedByIndexSimple = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> propPathsExcludedByIndexBinary = new HashMap<String, Set<String>>();
    }

    public static class PropertyInfo {
        public final PropertyType propertyType;
        public final String fragmentName;
        public final String fragmentKey;
        public final boolean readonly;
        public final boolean fulltext;

        public PropertyInfo(PropertyType propertyType, String fragmentName, String fragmentKey, boolean readonly) {
            this.propertyType = propertyType;
            this.fragmentName = fragmentName;
            this.fragmentKey = fragmentKey;
            this.readonly = readonly;
            this.fulltext = !(!propertyType.equals((Object)PropertyType.STRING) && !propertyType.equals((Object)PropertyType.BINARY) && !propertyType.equals((Object)PropertyType.ARRAY_STRING) || fragmentKey != null && fragmentKey.equals("id") || fragmentName.equals(Model.HIER_TABLE_NAME) || fragmentName.equals(Model.MAIN_TABLE_NAME) || fragmentName.equals(Model.VERSION_TABLE_NAME) || fragmentName.equals(Model.PROXY_TABLE_NAME) || fragmentName.equals("fulltext") || fragmentName.equals(Model.LOCK_TABLE_NAME) || fragmentName.equals(Model.UID_SCHEMA_NAME) || fragmentName.equals(Model.MISC_TABLE_NAME));
        }

        public String toString() {
            return "PropertyInfo(" + this.fragmentName + ", " + this.fragmentKey + ", " + (Object)((Object)this.propertyType) + (this.readonly ? ", RO" : "") + (this.fulltext ? ", FT" : "") + ')';
        }
    }
}

