/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Select;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.TableAlias;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

public class NXQLQueryMaker
implements QueryMaker {
    public static final String FACET_IMMUTABLE = "Immutable";
    protected static final String TABLE_HIER_ALIAS = "_H";
    protected static final String COL_ORDER_ALIAS_PREFIX = "_C";
    protected static final String UNION_ALIAS = "_T";
    protected static final String JOIN_ON = "%s ON %s = %s";
    protected SQLInfo sqlInfo;
    protected Database database;
    protected Dialect dialect;
    protected Model model;
    protected Session session;

    public String getName() {
        return "NXQL";
    }

    public boolean accepts(String queryString) {
        return queryString.equals("NXQL") || queryString.toLowerCase().trim().startsWith("select ");
    }

    public QueryMaker.Query buildQuery(SQLInfo sqlInfo, Model model, Session session, String query, QueryFilter queryFilter, Object ... params) throws StorageException {
        DocKind[] docKinds;
        this.sqlInfo = sqlInfo;
        this.database = sqlInfo.database;
        this.dialect = sqlInfo.dialect;
        this.model = model;
        this.session = session;
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        for (SQLQuery.Transformer transformer : queryFilter.getQueryTransformers()) {
            sqlQuery = transformer.transform(sqlQuery);
        }
        QueryAnalyzer info = new QueryAnalyzer();
        try {
            info.visitQuery(sqlQuery);
        }
        catch (QueryCannotMatchException e) {
            return null;
        }
        catch (QueryMakerException e) {
            throw new StorageException(e.getMessage(), e);
        }
        HashSet<String> types = new HashSet<String>();
        for (String typeName : info.fromTypes) {
            Set<String> subTypes;
            if ("document".equals(typeName)) {
                typeName = "Document";
            }
            if ((subTypes = model.getDocumentSubTypes(typeName)) == null) {
                throw new StorageException("Unknown type: " + typeName);
            }
            types.addAll(subTypes);
        }
        types.remove("Root");
        types.removeAll(info.typesExcluded);
        if (!info.typesAnyRequired.isEmpty()) {
            types.retainAll(info.typesAnyRequired);
        }
        if (types.isEmpty()) {
            return null;
        }
        FacetFilter facetFilter = queryFilter.getFacetFilter();
        if (facetFilter == null) {
            facetFilter = FacetFilter.ALLOW;
        }
        info.mixinsExcluded.addAll(facetFilter.excluded);
        if (info.mixinsExcluded.remove(FACET_IMMUTABLE)) {
            if (info.immutableClause == Boolean.TRUE) {
                return null;
            }
            info.immutableClause = Boolean.FALSE;
        }
        info.mixinsAllRequired.addAll(facetFilter.required);
        if (info.mixinsAllRequired.remove(FACET_IMMUTABLE)) {
            if (info.immutableClause == Boolean.FALSE) {
                return null;
            }
            info.immutableClause = Boolean.TRUE;
        }
        HashSet<String> fragmentNames = new HashSet<String>();
        for (String prop : info.props) {
            Model.PropertyInfo propertyInfo = model.getPropertyInfo(prop);
            if (propertyInfo == null) {
                throw new StorageException("Unknown field: " + prop);
            }
            fragmentNames.add(propertyInfo.fragmentName);
        }
        fragmentNames.remove(model.hierTableName);
        if (info.needsVersionsTable || info.immutableClause != null) {
            fragmentNames.add("versions");
        }
        if (info.proxyClause == Boolean.TRUE) {
            if (info.immutableClause == Boolean.FALSE) {
                return null;
            }
            docKinds = new DocKind[]{DocKind.PROXY};
        } else {
            docKinds = info.proxyClause == Boolean.FALSE || info.immutableClause == Boolean.FALSE ? new DocKind[]{DocKind.DIRECT} : new DocKind[]{DocKind.DIRECT, DocKind.PROXY};
        }
        Table hier = this.database.getTable(model.hierTableName);
        boolean aliasColumns = docKinds.length > 1;
        Select select = null;
        String orderBy = null;
        ArrayList<String> statements = new ArrayList<String>(2);
        LinkedList<Serializable> selectParams = new LinkedList<Serializable>();
        for (DocKind docKind : docKinds) {
            WhereBuilder whereBuilder;
            String dataHierId;
            Table dataHierTable;
            String hierId;
            Table hierTable;
            LinkedList<String> joins = new LinkedList<String>();
            LinkedList joinsParams = new LinkedList();
            LinkedList<String> leftJoins = new LinkedList<String>();
            LinkedList<String> leftJoinsParams = new LinkedList<String>();
            LinkedList<String> whereClauses = new LinkedList<String>();
            LinkedList<Object> whereParams = new LinkedList<Object>();
            switch (docKind) {
                case DIRECT: {
                    hierTable = hier;
                    hierId = hierTable.getColumn("id").getFullQuotedName();
                    dataHierTable = hierTable;
                    dataHierId = hierId;
                    joins.add(hierTable.getQuotedName());
                    break;
                }
                case PROXY: {
                    hierTable = new TableAlias(hier, TABLE_HIER_ALIAS);
                    String hierFrom = hier.getQuotedName() + " " + hierTable.getQuotedName();
                    hierId = hierTable.getColumn("id").getFullQuotedName();
                    dataHierTable = hier;
                    dataHierId = hier.getColumn("id").getFullQuotedName();
                    Table proxies = this.database.getTable("proxies");
                    String proxiesid = proxies.getColumn("id").getFullQuotedName();
                    String proxiestargetid = proxies.getColumn("targetid").getFullQuotedName();
                    joins.add(hierFrom);
                    joins.add(String.format(JOIN_ON, proxies.getQuotedName(), hierId, proxiesid));
                    joins.add(String.format(JOIN_ON, dataHierTable.getQuotedName(), dataHierId, proxiestargetid));
                    break;
                }
                default: {
                    throw new AssertionError((Object)docKind);
                }
            }
            for (String fragmentName : fragmentNames) {
                Table table = this.database.getTable(fragmentName);
                boolean useHier = "versions".equals(fragmentName);
                Object[] objectArray = new Object[3];
                objectArray[0] = table.getQuotedName();
                objectArray[1] = useHier ? hierId : dataHierId;
                objectArray[2] = table.getColumn("id").getFullQuotedName();
                leftJoins.add(String.format(JOIN_ON, objectArray));
            }
            ArrayList<String> typeStrings = new ArrayList<String>(types.size());
            block14: for (String type : types) {
                Set<String> facets = model.getDocumentTypeFacets(type);
                for (String facet : info.mixinsExcluded) {
                    if (!facets.contains(facet)) continue;
                    continue block14;
                }
                for (String facet : info.mixinsAllRequired) {
                    if (facets.contains(facet)) continue;
                    continue block14;
                }
                if (!info.mixinsAnyRequired.isEmpty()) {
                    HashSet<String> intersection = new HashSet<String>(info.mixinsAnyRequired);
                    intersection.retainAll(facets);
                    if (intersection.isEmpty()) continue;
                }
                typeStrings.add("?");
                whereParams.add(type);
            }
            if (typeStrings.isEmpty()) {
                return null;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = dataHierTable.getColumn("primarytype").getFullQuotedName();
            objectArray[1] = StringUtils.join(typeStrings, (String)", ");
            whereClauses.add(String.format("%s IN (%s)", objectArray));
            if (docKind == DocKind.DIRECT && info.immutableClause != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.database.getTable("versions").getColumn("id").getFullQuotedName();
                objectArray2[1] = info.immutableClause != false ? "NOT NULL" : "NULL";
                String where = String.format("%s IS %s", objectArray2);
                whereClauses.add(where);
            }
            try {
                whereBuilder = new WhereBuilder(this.database, session, hierTable, hierId, dataHierTable, dataHierId, docKind == DocKind.PROXY, aliasColumns);
            }
            catch (QueryMakerException e) {
                throw new StorageException(e.getMessage(), e);
            }
            if (info.wherePredicate != null) {
                info.wherePredicate.accept((IVisitor)whereBuilder);
                leftJoins.addAll(whereBuilder.joins);
                leftJoinsParams.addAll(whereBuilder.joinsParams);
                String where = whereBuilder.buf.toString();
                if (where.length() != 0) {
                    whereClauses.add(where);
                    whereParams.addAll(whereBuilder.whereParams);
                }
            }
            if (queryFilter.getPrincipals() != null) {
                Object principals = queryFilter.getPrincipals();
                Object permissions = queryFilter.getPermissions();
                if (!this.dialect.supportsArrays()) {
                    principals = StringUtils.join((Object[])principals, (char)'|');
                    permissions = StringUtils.join((Object[])permissions, (char)'|');
                }
                if (this.dialect.supportsReadAcl()) {
                    whereClauses.add(this.dialect.getReadAclsCheckSql("r.acl_id"));
                    whereParams.add(principals);
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = "hierarchy_read_acl";
                    objectArray3[1] = hierId;
                    joins.add(String.format("%s AS r ON %s = r.id", objectArray3));
                } else {
                    whereClauses.add(this.dialect.getSecurityCheckSql(hierId));
                    whereParams.add(principals);
                    whereParams.add(permissions);
                }
            }
            String selectWhat = hierId;
            if (aliasColumns) {
                int n = 0;
                for (String key : info.orderKeys) {
                    Column column = whereBuilder.findColumn(key, false, true);
                    String qname = column.getFullQuotedName();
                    selectWhat = selectWhat + ", " + qname + " AS " + this.dialect.openQuote() + COL_ORDER_ALIAS_PREFIX + ++n + this.dialect.closeQuote();
                }
            }
            if (orderBy == null && sqlQuery.orderBy != null) {
                whereBuilder.buf.setLength(0);
                sqlQuery.orderBy.accept((IVisitor)whereBuilder);
                orderBy = whereBuilder.buf.toString();
            }
            select = new Select(null);
            select.setWhat(selectWhat);
            leftJoins.addFirst(StringUtils.join(joins, (String)" JOIN "));
            select.setFrom(StringUtils.join(leftJoins, (String)" LEFT JOIN "));
            select.setWhere(StringUtils.join(whereClauses, (String)" AND "));
            selectParams.addAll(joinsParams);
            selectParams.addAll(leftJoinsParams);
            selectParams.addAll(whereParams);
            statements.add(select.getStatement());
        }
        if (statements.size() > 1) {
            select = new Select(null);
            select.setWhat(hier.getColumn("id").getQuotedName());
            String from = '(' + StringUtils.join(statements, (String)" UNION ALL ") + ')';
            if (this.dialect.needsAliasForDerivedTable()) {
                from = from + " AS " + this.dialect.openQuote() + UNION_ALIAS + this.dialect.closeQuote();
            }
            select.setFrom(from);
        }
        select.setOrderBy(orderBy);
        List<Column> whatColumns = Collections.singletonList(hier.getColumn("id"));
        QueryMaker.Query q = new QueryMaker.Query();
        q.selectInfo = new SQLInfo.SQLInfoSelect(select.getStatement(), whatColumns, null, null);
        q.selectParams = selectParams;
        return q;
    }

    public static class WhereBuilder
    extends DefaultQueryVisitor {
        private static final long serialVersionUID = 1L;
        public static final String PATH_SEP = "/";
        public final StringBuilder buf = new StringBuilder();
        public final List<String> joins = new LinkedList<String>();
        public final List<String> joinsParams = new LinkedList<String>();
        public final List<Serializable> whereParams = new LinkedList<Serializable>();
        private final Session session;
        private final Model model;
        private final Dialect dialect;
        private final Database database;
        private final Table hierTable;
        private final String hierId;
        private final Table dataHierTable;
        private final String dataHierId;
        private boolean isProxies;
        private boolean aliasColumns;
        private boolean allowArray;
        private boolean inOrderBy;
        private int orderByCount;
        private int ftJoinNumber;

        public WhereBuilder(Database database, Session session, Table hierTable, String hierId, Table dataHierTable, String dataHierId, boolean isProxies, boolean aliasColumns) {
            try {
                this.session = session;
                this.model = session.getModel();
                this.dialect = this.model.getDialect();
                this.database = database;
                this.hierTable = hierTable;
                this.hierId = hierId;
                this.dataHierTable = dataHierTable;
                this.dataHierId = dataHierId;
                this.isProxies = isProxies;
                this.aliasColumns = aliasColumns;
            }
            catch (StorageException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }

        public Column findColumn(String name, boolean allowArray, boolean inOrderBy) {
            Column column;
            if (name.startsWith("ecm:")) {
                column = this.getSpecialColumn(name);
            } else {
                Model.PropertyInfo propertyInfo = this.model.getPropertyInfo(name);
                if (propertyInfo == null) {
                    throw new QueryMakerException("Unknown field: " + name);
                }
                Table table = this.database.getTable(propertyInfo.fragmentName);
                if (propertyInfo.propertyType.isArray()) {
                    if (!allowArray) {
                        String msg = inOrderBy ? "Cannot use collection %s in ORDER BY clause" : "Can only use collection %s with =, <>, IN or NOT IN clause";
                        throw new QueryMakerException(String.format(msg, name));
                    }
                    column = table.getColumn("item");
                } else {
                    column = table.getColumn(propertyInfo.fragmentKey);
                }
            }
            return column;
        }

        protected Column getSpecialColumn(String name) {
            if ("ecm:primaryType".equals(name)) {
                return this.dataHierTable.getColumn("primarytype");
            }
            if ("ecm:mixinType".equals(name)) {
                throw new QueryMakerException("Cannot use non-toplevel " + name + " in query");
            }
            if ("ecm:uuid".equals(name)) {
                return this.hierTable.getColumn("id");
            }
            if ("ecm:name".equals(name)) {
                return this.hierTable.getColumn("name");
            }
            if ("ecm:parentId".equals(name)) {
                return this.hierTable.getColumn("parentid");
            }
            if ("ecm:currentLifeCycleState".equals(name)) {
                return this.database.getTable("misc").getColumn("lifecyclestate");
            }
            if (name.startsWith("ecm:fulltext")) {
                throw new QueryMakerException("ecm:fulltext must be used as left-hand operand");
            }
            if ("ecm:versionLabel".equals(name)) {
                return this.database.getTable("versions").getColumn("label");
            }
            throw new QueryMakerException("Unknown field: " + name);
        }

        public void visitQuery(SQLQuery node) {
            super.visitQuery(node);
        }

        public void visitMultiExpression(MultiExpression node) {
            Iterator it = node.values.iterator();
            while (it.hasNext()) {
                ((Operand)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                node.operator.accept((IVisitor)this);
            }
        }

        public void visitExpression(Expression node) {
            this.buf.append('(');
            String name = node.lvalue instanceof Reference ? ((Reference)node.lvalue).name : null;
            Operator op = node.operator;
            if (op == Operator.STARTSWITH) {
                this.visitExpressionStartsWith(node, name);
            } else if ("ecm:path".equals(name)) {
                this.visitExpressionEcmPath(node);
            } else if ("ecm:isProxy".equals(name)) {
                this.visitExpressionIsProxy(node);
            } else if ("ecm:isCheckedInVersion".equals(name)) {
                this.visitExpressionIsVersion(node);
            } else if (name != null && name.startsWith("ecm:fulltext")) {
                this.visitExpressionFulltext(node, name);
            } else if (op == Operator.ILIKE) {
                this.visitExpressionIlike(node, name);
            } else if (!(op != Operator.EQ && op != Operator.NOTEQ && op != Operator.IN && op != Operator.NOTIN && op != Operator.LIKE && op != Operator.NOTLIKE || name == null || name.startsWith("ecm:"))) {
                Model.PropertyInfo propertyInfo = this.model.getPropertyInfo(name);
                if (propertyInfo == null) {
                    throw new QueryMakerException("Unknown field: " + name);
                }
                if (propertyInfo.propertyType.isArray()) {
                    boolean direct;
                    boolean bl = direct = op == Operator.EQ || op == Operator.IN || op == Operator.LIKE;
                    Operator directOp = direct ? op : (op == Operator.NOTEQ ? Operator.EQ : (op == Operator.NOTIN ? Operator.IN : Operator.LIKE));
                    Table table = this.database.getTable(propertyInfo.fragmentName);
                    if (!direct) {
                        this.buf.append("NOT ");
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = table.getQuotedName();
                    objectArray[1] = this.dataHierId;
                    objectArray[2] = table.getColumn("id").getFullQuotedName();
                    this.buf.append(String.format("EXISTS (SELECT 1 FROM %s WHERE %s = %s AND (", objectArray));
                    this.allowArray = true;
                    node.lvalue.accept((IVisitor)this);
                    this.allowArray = false;
                    directOp.accept((IVisitor)this);
                    node.rvalue.accept((IVisitor)this);
                    this.buf.append("))");
                } else {
                    if (propertyInfo.propertyType == PropertyType.BOOLEAN) {
                        if (!(node.rvalue instanceof IntegerLiteral)) {
                            throw new QueryMakerException("Boolean expressions require literal 0 or 1 as right argument");
                        }
                        long v = ((IntegerLiteral)node.rvalue).value;
                        if (v != 0L && v != 1L) {
                            throw new QueryMakerException("Boolean expressions require literal 0 or 1 as right argument");
                        }
                        node = new Predicate(node.lvalue, node.operator, (Operand)new BooleanLiteral(v == 1L));
                    }
                    super.visitExpression(node);
                }
            } else if (node.operator == Operator.BETWEEN || node.operator == Operator.NOTBETWEEN) {
                LiteralList l = (LiteralList)node.rvalue;
                node.lvalue.accept((IVisitor)this);
                this.buf.append(' ');
                node.operator.accept((IVisitor)this);
                this.buf.append(' ');
                ((Literal)l.get(0)).accept((IVisitor)this);
                this.buf.append(" AND ");
                ((Literal)l.get(1)).accept((IVisitor)this);
            } else {
                super.visitExpression(node);
            }
            this.buf.append(')');
        }

        protected void visitExpressionStartsWith(Expression node, String name) {
            if (name == null) {
                throw new QueryMakerException("Illegal left argument for " + Operator.STARTSWITH + ": " + node.lvalue);
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMakerException(Operator.STARTSWITH + " requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            if ("ecm:path".equals(name)) {
                this.visitExpressionStartsWithPath(node, path);
            } else {
                this.visitExpressionStartsWithNonPath(node, name, path);
            }
        }

        protected void visitExpressionStartsWithPath(Expression node, String path) {
            Serializable id;
            try {
                Node n = this.session.getNodeByPath(path, null);
                id = n == null ? null : n.getId();
            }
            catch (StorageException e) {
                throw new QueryMakerException((Throwable)((Object)e));
            }
            if (id == null) {
                this.buf.append("0=1");
            } else {
                this.buf.append(this.dialect.getInTreeSql(this.hierId));
                this.whereParams.add(id);
            }
        }

        protected void visitExpressionStartsWithNonPath(Expression node, String name, String path) {
            Model.PropertyInfo propertyInfo = this.model.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new QueryMakerException("Unknown field: " + name);
            }
            boolean isArray = propertyInfo.propertyType.isArray();
            if (isArray) {
                Table table = this.database.getTable(propertyInfo.fragmentName);
                Object[] objectArray = new Object[3];
                objectArray[0] = table.getQuotedName();
                objectArray[1] = this.dataHierId;
                objectArray[2] = table.getColumn("id").getFullQuotedName();
                this.buf.append(String.format("EXISTS (SELECT 1 FROM %s WHERE %s = %s AND ", objectArray));
            }
            this.buf.append('(');
            this.allowArray = true;
            node.lvalue.accept((IVisitor)this);
            this.buf.append(" = ");
            node.rvalue.accept((IVisitor)this);
            this.buf.append(" OR ");
            node.lvalue.accept((IVisitor)this);
            this.buf.append(" LIKE ");
            new StringLiteral(path + PATH_SEP + '%').accept((IVisitor)this);
            this.allowArray = false;
            this.buf.append(')');
            if (isArray) {
                this.buf.append(')');
            }
        }

        protected void visitExpressionEcmPath(Expression node) {
            Serializable id;
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMakerException("ecm:path requires = or <> operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMakerException("ecm:path requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            try {
                Node n = this.session.getNodeByPath(path, null);
                id = n == null ? null : n.getId();
            }
            catch (StorageException e) {
                throw new QueryMakerException((Throwable)((Object)e));
            }
            if (id == null) {
                this.buf.append("0=1");
            } else {
                this.buf.append(this.hierTable.getColumn("id").getFullQuotedName() + " = ?");
                this.whereParams.add(id);
            }
        }

        protected void visitExpressionIsProxy(Expression node) {
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMakerException("ecm:isProxy requires = or <> operator");
            }
            if (!(node.rvalue instanceof IntegerLiteral)) {
                throw new QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)node.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            boolean bool = node.operator == Operator.EQ ^ v == 0L;
            this.buf.append(this.isProxies == bool ? "1=1" : "0=1");
        }

        protected void visitExpressionIsVersion(Expression node) {
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMakerException("ecm:isCheckedInVersion requires = or <> operator");
            }
            if (!(node.rvalue instanceof IntegerLiteral)) {
                throw new QueryMakerException("ecm:isCheckedInVersion requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)node.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMakerException("ecm:isCheckedInVersion requires literal 0 or 1 as right argument");
            }
            boolean bool = node.operator == Operator.EQ ^ v == 0L;
            this.buf.append(this.database.getTable("versions").getColumn("id").getFullQuotedName());
            this.buf.append(bool ? " IS NOT NULL" : " IS NULL");
        }

        protected void visitExpressionFulltext(Expression node, String name) {
            if (name.equals("ecm:fulltext")) {
                name = "default";
            } else if (!this.model.fulltextInfo.indexNames.contains(name = name.substring("ecm:fulltext".length() + 1))) {
                throw new QueryMakerException("No such fulltext index: " + name);
            }
            if (node.operator != Operator.EQ && node.operator != Operator.LIKE) {
                throw new QueryMakerException("ecm:fulltext requires = or LIKE operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMakerException("ecm:fulltext requires literal string as right argument");
            }
            String fulltextQuery = ((StringLiteral)node.rvalue).value;
            fulltextQuery = this.dialect.getDialectFulltextQuery(fulltextQuery);
            Column mainColumn = this.dataHierTable.getColumn("id");
            String[] info = this.dialect.getFulltextMatch(name, fulltextQuery, mainColumn, this.model, this.database);
            String joinExpr = info[0];
            String joinParam = info[1];
            String whereExpr = info[2];
            String whereParam = info[3];
            String joinAlias = this.getFtJoinAlias();
            if (joinExpr != null) {
                this.joins.add(String.format(joinExpr, joinAlias));
                if (joinParam != null) {
                    this.joinsParams.add(joinParam);
                }
            }
            this.buf.append(String.format(whereExpr, joinAlias));
            if (whereParam != null) {
                this.whereParams.add((Serializable)((Object)whereParam));
            }
        }

        private String getFtJoinAlias() {
            ++this.ftJoinNumber;
            if (this.ftJoinNumber == 1) {
                return "_FT";
            }
            return "_FT" + this.ftJoinNumber;
        }

        private void visitExpressionIlike(Expression node, String name) {
            if (this.dialect.supportsIlike()) {
                super.visitExpression(node);
            } else {
                this.buf.append("UPPER(");
                node.lvalue.accept((IVisitor)this);
                this.buf.append(")");
                this.buf.append(" LIKE ");
                this.buf.append("UPPER(");
                node.rvalue.accept((IVisitor)this);
                this.buf.append(")");
            }
        }

        public void visitOperator(Operator node) {
            if (node != Operator.NOT) {
                this.buf.append(' ');
            }
            this.buf.append(node.toString());
            this.buf.append(' ');
        }

        public void visitReference(Reference node) {
            String colFmt;
            Column column = this.findColumn(node.name, this.allowArray, this.inOrderBy);
            String qname = column.getFullQuotedName();
            if (column.getJdbcType() == 2005 && (colFmt = this.dialect.getClobCast(this.inOrderBy)) != null) {
                qname = String.format(colFmt, qname, 255);
            }
            this.buf.append(qname);
        }

        public void visitLiteralList(LiteralList node) {
            this.buf.append('(');
            Iterator it = node.iterator();
            while (it.hasNext()) {
                ((Literal)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                this.buf.append(", ");
            }
            this.buf.append(')');
        }

        public void visitDateLiteral(DateLiteral node) {
            this.buf.append('?');
            this.whereParams.add(node.toCalendar());
        }

        public void visitStringLiteral(StringLiteral node) {
            this.buf.append('?');
            this.whereParams.add((Serializable)((Object)node.value));
        }

        public void visitDoubleLiteral(DoubleLiteral node) {
            this.buf.append('?');
            this.whereParams.add(Double.valueOf(node.value));
        }

        public void visitIntegerLiteral(IntegerLiteral node) {
            this.buf.append('?');
            this.whereParams.add(Long.valueOf(node.value));
        }

        public void visitBooleanLiteral(BooleanLiteral node) {
            this.buf.append('?');
            this.whereParams.add(Boolean.valueOf(node.value));
        }

        public void visitOrderByList(OrderByList node) {
            this.inOrderBy = true;
            this.orderByCount = 0;
            Iterator it = node.iterator();
            while (it.hasNext()) {
                ((OrderByExpr)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                this.buf.append(", ");
            }
            this.inOrderBy = false;
        }

        public void visitOrderByExpr(OrderByExpr node) {
            if (this.aliasColumns) {
                this.buf.append(this.dialect.openQuote());
                this.buf.append(NXQLQueryMaker.COL_ORDER_ALIAS_PREFIX);
                this.buf.append(++this.orderByCount);
                this.buf.append(this.dialect.closeQuote());
            } else {
                node.reference.accept((IVisitor)this);
            }
            if (node.isDescending) {
                this.buf.append(" DESC");
            }
        }
    }

    protected static class BooleanLiteral
    extends Literal {
        private static final long serialVersionUID = 1L;
        public final boolean value;

        public BooleanLiteral(boolean value) {
            this.value = value;
        }

        public void accept(IVisitor visitor) {
            ((WhereBuilder)visitor).visitBooleanLiteral(this);
        }

        public String asString() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BooleanLiteral) {
                return this.value == ((BooleanLiteral)((Object)obj)).value;
            }
            return false;
        }

        public int hashCode() {
            return Boolean.valueOf(this.value).hashCode();
        }
    }

    public class QueryAnalyzer
    extends DefaultQueryVisitor {
        private static final long serialVersionUID = 1L;
        public final Set<String> fromTypes = new HashSet<String>();
        public final Set<String> props = new HashSet<String>();
        public final Set<String> orderKeys = new HashSet<String>();
        public boolean needsVersionsTable;
        protected boolean inOrderBy;
        protected final List<Operand> toplevelOperands = new LinkedList<Operand>();
        protected final Set<String> typesAnyRequired = new HashSet<String>();
        protected final Set<String> typesExcluded = new HashSet<String>();
        protected final Set<String> mixinsAnyRequired = new HashSet<String>();
        protected final Set<String> mixinsAllRequired = new HashSet<String>();
        protected final Set<String> mixinsExcluded = new HashSet<String>();
        protected Boolean immutableClause;
        protected Boolean proxyClause;
        protected MultiExpression wherePredicate;

        public void visitFromClause(FromClause node) {
            FromList elements = node.elements;
            for (int i = 0; i < elements.size(); ++i) {
                String type = (String)elements.get(i);
                this.fromTypes.add(type);
            }
        }

        public void visitWhereClause(WhereClause node) {
            this.analyzeToplevelOperands((Operand)node.predicate);
            this.wherePredicate = new MultiExpression(Operator.AND, this.toplevelOperands);
            super.visitMultiExpression(this.wherePredicate);
        }

        /*
         * Unable to fully structure code
         */
        protected void analyzeToplevelOperands(Operand node) {
            block28: {
                if (!(node instanceof Expression)) break block28;
                expr = (Expression)node;
                op = expr.operator;
                if (op == Operator.AND) {
                    this.analyzeToplevelOperands(expr.lvalue);
                    this.analyzeToplevelOperands(expr.rvalue);
                    return;
                }
                if (op == Operator.EQ || op == Operator.NOTEQ) {
                    v0 = isEq = op == Operator.EQ;
                    if (expr.rvalue instanceof Reference) {
                        expr = new Expression(expr.rvalue, op, expr.lvalue);
                    }
                    if (expr.lvalue instanceof Reference && expr.rvalue instanceof StringLiteral) {
                        name = ((Reference)expr.lvalue).name;
                        value = ((StringLiteral)expr.rvalue).value;
                        if ("ecm:primaryType".equals(name)) {
                            (isEq != false ? this.typesAnyRequired : this.typesExcluded).add(value);
                            return;
                        }
                        if ("ecm:mixinType".equals(name)) {
                            if ("Immutable".equals(value)) {
                                im = isEq;
                                if (this.immutableClause != null && this.immutableClause != im) {
                                    throw new QueryCannotMatchException();
                                }
                                this.immutableClause = im;
                                this.needsVersionsTable = true;
                            } else {
                                (isEq != false ? this.mixinsAllRequired : this.mixinsExcluded).add(value);
                            }
                            return;
                        }
                    }
                    if (expr.lvalue instanceof Reference && expr.rvalue instanceof IntegerLiteral) {
                        name = ((Reference)expr.lvalue).name;
                        v = ((IntegerLiteral)expr.rvalue).value;
                        if ("ecm:isProxy".equals(name)) {
                            if (v != 0L && v != 1L) {
                                throw new QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
                            }
                            pr = v == 1L;
                            if (this.proxyClause != null && this.proxyClause != pr) {
                                throw new QueryCannotMatchException();
                            }
                            this.proxyClause = pr;
                            return;
                        }
                    }
                }
                if (op != Operator.IN && op != Operator.NOTIN) break block28;
                v1 = isIn = op == Operator.IN;
                if (expr.rvalue instanceof Reference) {
                    expr = new Expression(expr.rvalue, op, expr.lvalue);
                }
                if (!(expr.lvalue instanceof Reference) || !(expr.rvalue instanceof LiteralList)) break block28;
                name = ((Reference)expr.lvalue).name;
                if ("ecm:primaryType".equals(name)) {
                    set = new HashSet<String>();
                    for (Literal literal : (LiteralList)expr.rvalue) {
                        if (!(literal instanceof StringLiteral)) {
                            throw new QueryMakerException("ecm:primaryType IN requires string literals");
                        }
                        set.add(((StringLiteral)literal).value);
                    }
                    if (isIn) {
                        if (this.typesAnyRequired.isEmpty()) {
                            this.typesAnyRequired.addAll(set);
                        } else {
                            this.typesAnyRequired.retainAll(set);
                            if (this.typesAnyRequired.isEmpty()) {
                                throw new QueryCannotMatchException();
                            }
                        }
                    } else {
                        this.typesExcluded.addAll(set);
                    }
                    return;
                }
                if (!"ecm:mixinType".equals(name)) break block28;
                set = new HashSet<E>();
                for (Literal literal : (LiteralList)expr.rvalue) {
                    if (!(literal instanceof StringLiteral)) {
                        throw new QueryMakerException("ecm:mixinType IN requires string literals");
                    }
                    value = ((StringLiteral)literal).value;
                    if ("Immutable".equals(value)) {
                        im = isIn;
                        if (this.immutableClause != null && this.immutableClause != im) {
                            throw new QueryCannotMatchException();
                        }
                        this.immutableClause = im;
                        this.needsVersionsTable = true;
                        continue;
                    }
                    set.add(value);
                }
                if (!isIn) ** GOTO lbl90
                if (this.mixinsAnyRequired.isEmpty()) {
                    this.mixinsAnyRequired.addAll(set);
                } else {
                    throw new QueryMakerException("ecm:mixinType cannot have more than one IN clause");
lbl90:
                    // 1 sources

                    this.mixinsExcluded.addAll(set);
                }
                return;
            }
            this.toplevelOperands.add(node);
        }

        public void visitReference(Reference node) {
            String name = node.name;
            if ("ecm:path".equals(name)) {
                if (this.inOrderBy) {
                    throw new QueryMakerException("Cannot order by: " + name);
                }
                return;
            }
            if ("ecm:isProxy".equals(name)) {
                if (this.inOrderBy) {
                    throw new QueryMakerException("Cannot order by: " + name);
                }
                return;
            }
            if ("ecm:isCheckedInVersion".equals(name)) {
                if (this.inOrderBy) {
                    throw new QueryMakerException("Cannot order by: " + name);
                }
                this.needsVersionsTable = true;
                return;
            }
            if ("ecm:primaryType".equals(name) || "ecm:mixinType".equals(name) || "ecm:uuid".equals(name) || "ecm:name".equals(name) || "ecm:parentId".equals(name)) {
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if ("ecm:currentLifeCycleState".equals(name)) {
                Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                this.props.add("ecm:lifeCycleState");
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if ("ecm:versionLabel".equals(name)) {
                Model cfr_ignored_1 = NXQLQueryMaker.this.model;
                this.props.add("ecm:versionLabel");
                if (this.inOrderBy) {
                    this.orderKeys.add(name);
                }
                return;
            }
            if (name.startsWith("ecm:fulltext")) {
                if (NXQLQueryMaker.this.model.getRepositoryDescriptor().fulltextDisabled) {
                    throw new QueryMakerException("Fulltext disabled by configuration");
                }
                if (NXQLQueryMaker.this.dialect.isFulltextTableNeeded()) {
                    Model cfr_ignored_2 = NXQLQueryMaker.this.model;
                    this.props.add("ecm:simpleText");
                }
                return;
            }
            if (name.startsWith("ecm:")) {
                throw new QueryMakerException("Unknown field: " + name);
            }
            Model.PropertyInfo propertyInfo = NXQLQueryMaker.this.model.getPropertyInfo(name);
            if (propertyInfo == null) {
                throw new QueryMakerException("Unknown field: " + name);
            }
            if (!propertyInfo.propertyType.isArray()) {
                this.props.add(name);
            }
            if (this.inOrderBy) {
                this.orderKeys.add(name);
            }
        }

        public void visitFunction(Function node) {
            throw new QueryMakerException("Function not supported: " + node.toString());
        }

        public void visitOrderByClause(OrderByClause node) {
            this.inOrderBy = true;
            super.visitOrderByClause(node);
            this.inOrderBy = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DocKind {
        DIRECT,
        PROXY;

    }

    private static class QueryCannotMatchException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private QueryCannotMatchException() {
        }
    }

    private static class QueryMakerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public QueryMakerException(String message) {
            super(message);
        }

        public QueryMakerException(Throwable cause) {
            super(cause);
        }
    }
}

