/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BaseProperty;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.CollectionProperty;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.SimpleProperty;

public class Node {
    private final PersistenceContext context;
    private final Model model;
    protected final SimpleFragment mainFragment;
    private final SimpleFragment hierFragment;
    private final FragmentsMap fragments;
    private final Map<String, BaseProperty> propertyCache;
    private Boolean isVersion;

    protected Node(Session session, PersistenceContext context, FragmentGroup rowGroup) throws StorageException {
        this.context = context;
        this.model = session.getModel();
        this.mainFragment = rowGroup.main;
        this.hierFragment = rowGroup.hier;
        this.fragments = rowGroup.fragments == null ? new FragmentsMap() : rowGroup.fragments;
        this.propertyCache = new ReferenceMap(0, 1);
    }

    public Serializable getId() {
        return this.mainFragment.getId();
    }

    public String getName() {
        try {
            return this.getHierFragment().getString("name");
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public String getPrimaryType() {
        try {
            return this.mainFragment.getString("primarytype");
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public String getParentId() {
        try {
            return this.getHierFragment().getString("parentid");
        }
        catch (StorageException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    protected SimpleFragment getHierFragment() {
        return this.hierFragment == null ? this.mainFragment : this.hierFragment;
    }

    public boolean isVersion() {
        if (this.isVersion == null) {
            String name;
            Serializable parentId;
            SimpleFragment hier = this.getHierFragment();
            try {
                parentId = hier.get("parentid");
                name = hier.getString("name");
            }
            catch (StorageException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
            this.isVersion = parentId == null && name != null && name.length() > 0;
        }
        return this.isVersion;
    }

    public boolean isProxy() {
        return this.getPrimaryType().equals("ecm:proxy");
    }

    protected void remove() throws StorageException {
        this.context.remove(this.mainFragment);
        if (this.hierFragment != null) {
            this.context.remove(this.hierFragment);
        }
        for (Fragment fragment : this.fragments.values()) {
            this.context.remove(fragment);
        }
    }

    public SimpleProperty getSimpleProperty(String name) throws StorageException {
        SimpleProperty property = (SimpleProperty)this.propertyCache.get(name);
        if (property == null) {
            Model.PropertyInfo propertyInfo = this.model.getPropertyInfo(this.getPrimaryType(), name);
            if (propertyInfo == null) {
                throw new IllegalArgumentException("Unknown field: " + name);
            }
            String fragmentName = propertyInfo.fragmentName;
            Fragment row = (Fragment)this.fragments.get(fragmentName);
            if (row == null) {
                row = this.context.get(fragmentName, this.getId(), true);
                this.fragments.put(fragmentName, row);
            }
            property = new SimpleProperty(name, propertyInfo.propertyType, propertyInfo.readonly, (SimpleFragment)row, propertyInfo.fragmentKey);
            this.propertyCache.put(name, property);
        }
        return property;
    }

    public CollectionProperty getCollectionProperty(String name) throws StorageException {
        CollectionProperty property = (CollectionProperty)this.propertyCache.get(name);
        if (property == null) {
            Model.PropertyInfo propertyInfo = this.model.getPropertyInfo(this.getPrimaryType(), name);
            if (propertyInfo == null) {
                throw new IllegalArgumentException("Unknown field: " + name);
            }
            String fragmentName = propertyInfo.fragmentName;
            Fragment fragment = this.context.get(fragmentName, this.getId(), true);
            property = new CollectionProperty(name, propertyInfo.propertyType, false, (CollectionFragment)fragment);
            this.propertyCache.put(name, property);
        }
        return property;
    }

    public BaseProperty getProperty(String name) throws StorageException {
        BaseProperty property = this.propertyCache.get(name);
        if (property != null) {
            return property;
        }
        Model.PropertyInfo propertyInfo = this.model.getPropertyInfo(this.getPrimaryType(), name);
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Unknown field: " + name);
        }
        if (propertyInfo.propertyType.isArray()) {
            return this.getCollectionProperty(name);
        }
        return this.getSimpleProperty(name);
    }

    public void setSingleProperty(String name, Serializable value) throws StorageException {
        SimpleProperty property = this.getSimpleProperty(name);
        property.setValue(value);
    }

    public void setCollectionProperty(String name, Serializable[] value) throws StorageException {
        CollectionProperty property = this.getCollectionProperty(name);
        property.setValue(value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Node) {
            return this.equals((Node)other);
        }
        return false;
    }

    private boolean equals(Node other) {
        return this.getId() == other.getId();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

