/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.HierarchyContext;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContext {
    private static final Log log = LogFactory.getLog(PersistenceContext.class);
    private final Mapper mapper;
    private final Map<String, Context> contexts;
    private final HierarchyContext hierContext;
    private final Model model;
    private EventProducer eventProducer;
    private final Set<Serializable> createdIds;
    private final HashMap<Serializable, Serializable> oldIdMap;

    public PersistenceContext(Mapper mapper) {
        this.mapper = mapper;
        this.model = mapper.getModel();
        this.contexts = new ConcurrentHashMap<String, Context>();
        this.hierContext = new HierarchyContext(mapper, this);
        this.contexts.put(this.model.hierTableName, this.hierContext);
        this.createdIds = new LinkedHashSet<Serializable>();
        this.oldIdMap = new HashMap();
    }

    protected EventProducer getEventProducer() throws StorageException {
        if (this.eventProducer == null) {
            try {
                this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
            }
            catch (Exception e) {
                throw new StorageException("Unable to find EventProducer", e);
            }
        }
        return this.eventProducer;
    }

    protected int clearCaches() {
        int n = 0;
        for (Context context : this.contexts.values()) {
            n += context.clearCaches();
        }
        this.createdIds.clear();
        return n;
    }

    protected Context getContextOrNull(String tableName) {
        return this.contexts.get(tableName);
    }

    protected Context getContext(String tableName) {
        Context context = this.contexts.get(tableName);
        if (context == null) {
            context = new Context(tableName, this.mapper, this);
            this.contexts.put(tableName, context);
        }
        return context;
    }

    protected HierarchyContext getHierContext() {
        return this.hierContext;
    }

    public Serializable generateNewId(Serializable id) {
        if (id == null) {
            id = this.model.generateNewId();
        }
        this.createdIds.add(id);
        return id;
    }

    protected boolean isIdNew(Serializable id) {
        return this.createdIds.contains(id);
    }

    protected Serializable getRootId(Serializable repositoryId) throws StorageException {
        return this.mapper.getRootId(repositoryId);
    }

    protected void setRootId(Serializable repositoryId, Serializable id) throws StorageException {
        this.mapper.setRootId(repositoryId, id);
    }

    public void close() {
        this.mapper.close();
        for (Context context : this.contexts.values()) {
            context.close();
        }
    }

    protected void updateFulltext(Session session) throws StorageException {
        HashSet<Serializable> dirtyStrings = new HashSet<Serializable>();
        HashSet<Serializable> dirtyBinaries = new HashSet<Serializable>();
        for (Context context : this.contexts.values()) {
            context.findDirtyDocuments(dirtyStrings, dirtyBinaries);
        }
        if (dirtyStrings.isEmpty() && dirtyBinaries.isEmpty()) {
            return;
        }
        for (Serializable docId : dirtyStrings) {
            if (docId == null) {
                log.error((Object)"Got null doc id in fulltext update, cannot happen");
                continue;
            }
            Node document = session.getNodeById(docId);
            if (document == null) continue;
            for (String indexName : this.model.getFulltextInfo().indexNames) {
                Set<String> paths = this.model.getFulltextInfo().indexesAllSimple.contains(indexName) ? this.model.getTypeSimpleTextPropertyPaths(document.getPrimaryType()) : this.model.getFulltextInfo().propPathsByIndexSimple.get(indexName);
                String strings = this.findFulltext(session, document, paths);
                String propName = "ecm:simpleText" + this.model.getFulltextIndexSuffix(indexName);
                document.setSingleProperty(propName, (Serializable)((Object)strings));
            }
        }
        if (!dirtyBinaries.isEmpty()) {
            log.debug((Object)("Queued documents for asynchronous fulltext extraction: " + dirtyBinaries.size()));
            EventContextImpl eventContext = new EventContextImpl(new Object[]{dirtyBinaries, this.model.getFulltextInfo()});
            eventContext.setRepositoryName(session.getRepositoryName());
            Event event = eventContext.newEvent("event_storage_binaries_doc");
            try {
                this.getEventProducer().fireEvent(event);
            }
            catch (ClientException e) {
                throw new StorageException(e);
            }
        }
    }

    private String findFulltext(Session session, Node document, Set<String> paths) throws StorageException {
        if (paths == null) {
            return "";
        }
        String documentType = document.getPrimaryType();
        LinkedList<String> strings = new LinkedList<String>();
        for (String path : paths) {
            Model.PropertyInfo pi = this.model.getPathPropertyInfo(documentType, path);
            if (pi == null || pi.propertyType != PropertyType.STRING && pi.propertyType != PropertyType.ARRAY_STRING) continue;
            List<Node> nodes = new ArrayList<Node>(Collections.singleton(document));
            String[] names = path.split("/");
            for (int i = 0; i < names.length; ++i) {
                List<Object> newNodes;
                String name = names[i];
                if (i + 1 < names.length && "*".equals(names[i + 1])) {
                    ++i;
                    newNodes = new ArrayList();
                    for (Node node : nodes) {
                        newNodes.addAll(session.getChildren(node, name, true));
                    }
                } else if (i == names.length - 1) {
                    for (Node node : nodes) {
                        if (pi.propertyType == PropertyType.STRING) {
                            String v = node.getSimpleProperty(name).getString();
                            if (v == null) continue;
                            strings.add(v);
                            continue;
                        }
                        for (Serializable v : node.getCollectionProperty(name).getValue()) {
                            if (v == null) continue;
                            strings.add((String)((Object)v));
                        }
                    }
                    newNodes = Collections.emptyList();
                } else {
                    newNodes = new ArrayList(nodes.size());
                    for (Node node : nodes) {
                        if ((node = session.getChildNode(node, name, true)) == null) continue;
                        newNodes.add(node);
                    }
                }
                nodes = newNodes;
            }
        }
        return StringUtils.join(strings, (String)" ");
    }

    public void save() throws StorageException {
        log.debug((Object)"Saving persistence context");
        assert (!this.model.separateMainTable);
        Map<Serializable, Serializable> idMap = this.hierContext.saveCreated(this.createdIds);
        this.createdIds.clear();
        for (Context context : this.contexts.values()) {
            context.save(idMap);
        }
        this.oldIdMap.putAll(idMap);
        log.debug((Object)"End of save");
    }

    public void rollback() {
        this.clearCaches();
    }

    protected Invalidations gatherInvalidations() {
        Invalidations invalidations = new Invalidations();
        for (Context context : this.contexts.values()) {
            if (context.getTableName().equals("fulltext")) continue;
            context.gatherInvalidations(invalidations);
        }
        return invalidations;
    }

    protected void processReceivedInvalidations() {
        for (Context context : this.contexts.values()) {
            context.processReceivedInvalidations();
        }
    }

    protected void invalidate(Invalidations invalidations) {
        for (Context context : this.contexts.values()) {
            context.invalidate(invalidations);
        }
    }

    protected Serializable getOldId(Serializable id) {
        return this.oldIdMap.get(id);
    }

    public SimpleFragment createSimpleFragment(String tableName, Serializable id, Map<String, Serializable> map) throws StorageException {
        return this.getContext(tableName).create(id, map);
    }

    public Fragment get(String tableName, Serializable id, boolean allowAbsent) throws StorageException {
        return this.getContext(tableName).get(id, allowAbsent);
    }

    public List<Fragment> getMulti(String tableName, List<Serializable> ids, boolean allowAbsent) throws StorageException {
        return this.getContext(tableName).getMulti(ids, allowAbsent);
    }

    public SimpleFragment getChildByName(Serializable parentId, String name, boolean complexProp) throws StorageException {
        return this.hierContext.getChildByName(parentId, name, complexProp);
    }

    public List<SimpleFragment> getChildren(Serializable parentId, String name, boolean complexProp) throws StorageException {
        return this.hierContext.getChildren(parentId, name, complexProp);
    }

    public void orderBefore(Serializable parentId, Serializable sourceId, Serializable destId) throws StorageException {
        this.hierContext.orderBefore(parentId, sourceId, destId);
    }

    protected Long getNextPos(Serializable nodeId, boolean complexProp) throws StorageException {
        return this.hierContext.getNextPos(nodeId, complexProp);
    }

    public void move(Node source, Serializable parentId, String name) throws StorageException {
        this.hierContext.moveChild(source, parentId, name);
    }

    public Serializable copy(Node source, Serializable parentId, String name) throws StorageException {
        return this.hierContext.copyChild(source, parentId, name);
    }

    public void remove(Fragment row) throws StorageException {
        String tableName = row.getTableName();
        Context context = this.contexts.get(tableName);
        if (context == null) {
            log.error((Object)("Removing row not in a context: " + row));
            return;
        }
        context.remove(row);
    }

    public Serializable checkIn(Node node, String label, String description) throws StorageException {
        Boolean checkedIn = (Boolean)node.mainFragment.get("ischeckedin");
        if (Boolean.TRUE.equals(checkedIn)) {
            throw new StorageException("Already checked in");
        }
        Serializable id = node.getId();
        String typeName = node.getPrimaryType();
        Serializable newId = this.mapper.copyHierarchy(id, typeName, null, null, null, null, this);
        this.get(this.model.hierTableName, newId, false);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("versionableid", id);
        map.put("created", new GregorianCalendar());
        map.put("label", (Serializable)((Object)label));
        map.put("description", (Serializable)((Object)description));
        SimpleFragment versionRow = this.createSimpleFragment("versions", newId, map);
        node.mainFragment.put("ischeckedin", Boolean.TRUE);
        node.mainFragment.put("baseversionid", newId);
        this.save();
        return newId;
    }

    public void checkOut(Node node) throws StorageException {
        Boolean checkedIn = (Boolean)node.mainFragment.get("ischeckedin");
        if (!Boolean.TRUE.equals(checkedIn)) {
            throw new StorageException("Already checked out");
        }
        node.mainFragment.put("ischeckedin", Boolean.FALSE);
    }

    public void restoreByLabel(Node node, String label) throws StorageException {
        String typeName = node.getPrimaryType();
        Serializable versionableId = node.getId();
        Context versionsContext = this.getContext("versions");
        Serializable versionId = this.mapper.getVersionByLabel(versionableId, label, versionsContext);
        if (versionId == null) {
            throw new StorageException("Unknown version: " + label);
        }
        List<SimpleFragment> children = this.getChildren(versionableId, null, true);
        for (Fragment child : children.toArray(new Fragment[children.size()])) {
            this.remove(child);
        }
        this.save();
        HashMap<String, Serializable> overwriteMap = new HashMap<String, Serializable>();
        SimpleFragment versionHier = (SimpleFragment)this.hierContext.get(versionId, false);
        for (String key : this.model.getFragmentKeysType(this.model.hierTableName).keySet()) {
            if (key.equals("parentid")) continue;
            if (key.equals("name")) continue;
            if (key.equals("pos")) continue;
            if (key.equals("isproperty")) continue;
            if (key.equals("primarytype")) continue;
            if (key.equals("ischeckedin")) continue;
            if (key.equals("baseversionid")) continue;
            overwriteMap.put(key, versionHier.get(key));
        }
        overwriteMap.put("ischeckedin", Boolean.TRUE);
        overwriteMap.put("baseversionid", versionId);
        this.mapper.copyHierarchy(versionId, typeName, (Serializable)((Object)node.getParentId()), null, versionableId, overwriteMap, this);
    }

    public Serializable getVersionByLabel(Serializable versionableId, String label) throws StorageException {
        Context versionsContext = this.getContext("versions");
        return this.mapper.getVersionByLabel(versionableId, label, versionsContext);
    }

    public Serializable getLastVersion(Serializable versionableId) throws StorageException {
        Context versionsContext = this.getContext("versions");
        SimpleFragment result = this.mapper.getLastVersion(versionableId, versionsContext);
        return result == null ? null : result.getId();
    }

    public List<SimpleFragment> getVersions(Serializable versionableId) throws StorageException {
        Context versionsContext = this.getContext("versions");
        return this.mapper.getVersions(versionableId, versionsContext);
    }

    public List<SimpleFragment> getProxies(Node document, Node parent) throws StorageException {
        Object searchId;
        boolean byTarget;
        if (document.isVersion()) {
            byTarget = true;
            searchId = document.getId();
        } else {
            byTarget = false;
            searchId = document.isProxy() ? document.getSimpleProperty("ecm:proxyVersionableId").getString() : document.getId();
        }
        Serializable parentId = parent == null ? null : parent.getId();
        Context proxiesContext = this.getContext("proxies");
        return this.mapper.getProxies((Serializable)searchId, byTarget, parentId, proxiesContext);
    }

    protected Serializable getContainingDocument(Serializable id) throws StorageException {
        return this.hierContext.getContainingDocument(id);
    }
}

