/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;

@XObject(value="repository")
public class RepositoryDescriptor {
    private static final Log log = LogFactory.getLog(RepositoryDescriptor.class);
    @XNode(value="@name")
    public String name;
    @XNode(value="clustering@enabled")
    public boolean clusteringEnabled;
    @XNode(value="clustering@delay")
    public long clusteringDelay;
    @XNodeList(value="schema/field", type=ArrayList.class, componentType=FieldDescriptor.class)
    public List<FieldDescriptor> schemaFields = Collections.emptyList();
    @XNode(value="indexing/fulltext@disabled")
    public boolean fulltextDisabled;
    @XNode(value="indexing/fulltext@analyzer")
    public String fulltextAnalyzer;
    @XNode(value="indexing/fulltext@catalog")
    public String fulltextCatalog;
    @XNodeList(value="indexing/queryMaker@class", type=ArrayList.class, componentType=Class.class)
    public List<Class<?>> queryMakerClasses;
    @XNodeList(value="indexing/fulltext/index", type=ArrayList.class, componentType=FulltextIndexDescriptor.class)
    public List<FulltextIndexDescriptor> fulltextIndexes;
    @XNode(value="pathOptimizations@enabled")
    public boolean pathOptimizationsEnabled = true;
    @XNode(value="aclOptimizations@enabled")
    public boolean aclOptimizationsEnabled = true;
    @XNode(value="binaryManager@class")
    public Class<? extends BinaryManager> binaryManagerClass;
    @XNode(value="binaryManager@key")
    public String binaryManagerKey;
    @XNode(value="binaryStore@path")
    public String binaryStorePath;
    @XNode(value="xa-datasource")
    public String xaDataSourceName;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties;
    public IdGenPolicy idGenPolicy = IdGenPolicy.APP_UUID;
    public boolean separateMainTable = false;

    public void mergeFrom(RepositoryDescriptor other) {
        this.clusteringEnabled = other.clusteringEnabled;
        this.clusteringDelay = other.clusteringDelay;
        this.schemaFields = other.schemaFields;
        this.fulltextDisabled = other.fulltextDisabled;
        this.fulltextAnalyzer = other.fulltextAnalyzer;
        this.fulltextCatalog = other.fulltextCatalog;
        this.queryMakerClasses = other.queryMakerClasses;
        this.fulltextIndexes = other.fulltextIndexes;
        this.pathOptimizationsEnabled = other.pathOptimizationsEnabled;
        this.aclOptimizationsEnabled = other.aclOptimizationsEnabled;
        this.binaryStorePath = other.binaryStorePath;
        this.binaryManagerClass = other.binaryManagerClass;
        this.binaryManagerKey = other.binaryManagerKey;
    }

    @XNode(value="id-generation")
    public void setIdGeneration(String value) {
        try {
            this.idGenPolicy = IdGenPolicy.fromString(value);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Illegal id generation policy: " + value + ", using default: " + this.idGenPolicy.getValue()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdGenPolicy {
        APP_UUID("application-uuid"),
        DB_IDENTITY("database-identity");

        private final String value;

        private IdGenPolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static IdGenPolicy fromString(String value) {
            for (IdGenPolicy e : IdGenPolicy.values()) {
                if (!e.value.equals(value)) continue;
                return e;
            }
            throw new IllegalArgumentException(value);
        }
    }

    @XObject(value="field")
    public static class FieldDescriptor {
        @XNode(value="@type")
        public String type;
        @XNode
        public String field;

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.field + ",type=" + this.type + ")";
        }
    }

    @XObject(value="index")
    public static class FulltextIndexDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@analyzer")
        public String analyzer;
        @XNode(value="@catalog")
        public String catalog;
        @XNode(value="fieldType")
        public String fieldType;
        @XNodeList(value="field", type=HashSet.class, componentType=String.class)
        public Set<String> fields;
        @XNodeList(value="excludeField", type=HashSet.class, componentType=String.class)
        public Set<String> excludeFields;
    }
}

