/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Reference;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ConnectionSpecImpl;
import org.nuxeo.ecm.core.storage.sql.DefaultBinaryManager;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;

public class RepositoryImpl
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryImpl.class);
    protected final SchemaManager schemaManager;
    private final RepositoryDescriptor repositoryDescriptor;
    private final Collection<SessionImpl> sessions;
    private final BinaryManager binaryManager;
    private final XADataSource xadatasource;
    private boolean initialized;
    private Dialect dialect;
    private Model model;
    private SQLInfo sqlInfo;
    private Mapper clusterMapper;
    private long clusterLastInvalidationTimeMillis;
    private Reference reference;

    public RepositoryImpl(RepositoryDescriptor repositoryDescriptor, SchemaManager schemaManager) throws StorageException {
        this.repositoryDescriptor = repositoryDescriptor;
        this.schemaManager = schemaManager;
        this.sessions = new CopyOnWriteArrayList<SessionImpl>();
        this.xadatasource = this.getXADataSource();
        try {
            Class<? extends BinaryManager> klass = repositoryDescriptor.binaryManagerClass;
            if (klass == null) {
                klass = DefaultBinaryManager.class;
            }
            Constructor<? extends BinaryManager> constructor = klass.getConstructor(RepositoryDescriptor.class);
            this.binaryManager = constructor.newInstance(repositoryDescriptor);
        }
        catch (InvocationTargetException e) {
            throw new StorageException(e.getCause());
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
    }

    protected RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    protected BinaryManager getBinaryManager() {
        return this.binaryManager;
    }

    public SessionImpl getConnection() throws StorageException {
        return this.getConnection(null);
    }

    public synchronized SessionImpl getConnection(ConnectionSpec connectionSpec) throws StorageException {
        Credentials credentials;
        assert (connectionSpec == null || connectionSpec instanceof ConnectionSpecImpl);
        Credentials credentials2 = credentials = connectionSpec == null ? null : ((ConnectionSpecImpl)connectionSpec).getCredentials();
        if (!this.initialized) {
            this.initialize();
        }
        Mapper mapper = new Mapper(this, this.model, this.sqlInfo, this.xadatasource);
        if (!this.initialized) {
            mapper.createDatabase();
            if (this.repositoryDescriptor.clusteringEnabled) {
                log.info((Object)("Clustering enabled with " + this.repositoryDescriptor.clusteringDelay + " ms delay for repository: " + this.getName()));
                this.clusterMapper = mapper;
                this.clusterMapper.createClusterNode();
                this.processClusterInvalidationsNext();
                mapper = new Mapper(this, this.model, this.sqlInfo, this.xadatasource);
            }
            this.initialized = true;
        }
        SessionImpl session = new SessionImpl(this, this.schemaManager, mapper, credentials);
        this.sessions.add(session);
        return session;
    }

    public ResourceAdapterMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public RecordFactory getRecordFactory() {
        throw new UnsupportedOperationException();
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        for (SessionImpl session : this.sessions) {
            if (!session.isLive()) continue;
            session.closeSession();
        }
        this.sessions.clear();
        if (this.clusterMapper != null) {
            Mapper mapper = this.clusterMapper;
            synchronized (mapper) {
                try {
                    this.clusterMapper.removeClusterNode();
                }
                catch (StorageException e) {
                    log.error((Object)e.getMessage(), (Throwable)((Object)e));
                }
                this.clusterMapper.close();
            }
            this.clusterMapper = null;
        }
    }

    public String getName() {
        return this.repositoryDescriptor.name;
    }

    public int getActiveSessionsCount() {
        return this.sessions.size();
    }

    public int clearCaches() {
        int n = 0;
        for (SessionImpl session : this.sessions) {
            n += session.clearCaches();
        }
        return n;
    }

    public void processClusterInvalidationsNext() {
        this.clusterLastInvalidationTimeMillis = System.currentTimeMillis() - this.repositoryDescriptor.clusteringDelay - 1L;
    }

    protected void closeSession(SessionImpl session) {
        this.sessions.remove(session);
    }

    private XADataSource getXADataSource() throws StorageException {
        Object instance;
        Class<?> klass;
        String className = this.repositoryDescriptor.xaDataSourceName;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new StorageException("Unknown class: " + className, e);
        }
        try {
            instance = klass.newInstance();
        }
        catch (Exception e) {
            throw new StorageException("Cannot instantiate class: " + className, e);
        }
        if (!(instance instanceof XADataSource)) {
            throw new StorageException("Not a XADataSource: " + className);
        }
        XADataSource xadatasource = (XADataSource)instance;
        for (Map.Entry<String, String> entry : this.repositoryDescriptor.properties.entrySet()) {
            String name = entry.getKey();
            String value = Framework.expandVars((String)entry.getValue());
            if (name.contains("/")) {
                name = name.substring(0, name.indexOf(47));
            }
            if (Character.isLowerCase(name.charAt(1))) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            try {
                BeanUtils.setProperty((Object)xadatasource, (String)name, (Object)value);
            }
            catch (Exception e) {
                log.error((Object)String.format("Cannot set %s = %s", name, value));
            }
        }
        return xadatasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws StorageException {
        log.debug((Object)"Initializing");
        try {
            XAConnection xaconnection = this.xadatasource.getXAConnection();
            Connection connection = null;
            try {
                connection = xaconnection.getConnection();
                this.dialect = Dialect.createDialect(connection, this.repositoryDescriptor);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                xaconnection.close();
            }
        }
        catch (SQLException e) {
            throw new StorageException("Cannot get XAConnection", e);
        }
        this.model = new Model(this, this.schemaManager, this.dialect);
        this.sqlInfo = new SQLInfo(this.model, this.dialect);
    }

    public Binary getBinary(InputStream in) throws IOException {
        return this.binaryManager.getBinary(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(Invalidations invalidations, SessionImpl fromSession) throws StorageException {
        for (SessionImpl session : this.sessions) {
            if (session == fromSession) continue;
            session.invalidate(invalidations);
        }
        if (this.clusterMapper != null) {
            Mapper mapper = this.clusterMapper;
            synchronized (mapper) {
                this.clusterMapper.insertClusterInvalidations(invalidations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveClusterInvalidations() throws StorageException {
        if (this.clusterMapper != null) {
            Invalidations invalidations;
            Mapper mapper = this.clusterMapper;
            synchronized (mapper) {
                if (this.clusterLastInvalidationTimeMillis + this.repositoryDescriptor.clusteringDelay > System.currentTimeMillis()) {
                    return;
                }
                invalidations = this.clusterMapper.getClusterInvalidations();
                this.clusterLastInvalidationTimeMillis = System.currentTimeMillis();
            }
            if (invalidations.isEmpty()) {
                return;
            }
            for (SessionImpl session : this.sessions) {
                session.invalidate(invalidations);
            }
        }
    }
}

