/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.FragmentGroup;
import org.nuxeo.ecm.core.storage.sql.FragmentsMap;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SimpleFragment;
import org.nuxeo.ecm.core.storage.sql.TransactionalSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements Session {
    private static final Log log = LogFactory.getLog(SessionImpl.class);
    private final RepositoryImpl repository;
    protected final SchemaManager schemaManager;
    private final Mapper mapper;
    private final Model model;
    private final PersistenceContext context;
    private boolean live;
    private final TransactionalSession transactionalSession;
    private Node rootNode;
    private long threadId;
    private boolean readAclsChanged;
    private String threadName;

    SessionImpl(RepositoryImpl repository, SchemaManager schemaManager, Mapper mapper, Credentials credentials) throws StorageException {
        this.repository = repository;
        this.schemaManager = schemaManager;
        this.mapper = mapper;
        this.model = mapper.getModel();
        this.context = new PersistenceContext(mapper);
        this.live = true;
        this.readAclsChanged = false;
        this.transactionalSession = new TransactionalSession(this, mapper);
        this.computeRootNode();
    }

    public XAResource getXAResource() {
        return this.transactionalSession;
    }

    protected int clearCaches() {
        if (this.transactionalSession.isInTransaction()) {
            return 0;
        }
        int n = this.context.clearCaches();
        this.checkThreadEnd();
        return n;
    }

    protected void checkThread() {
        if (this.threadId == 0L) {
            return;
        }
        long currentThreadId = Thread.currentThread().getId();
        if (this.threadId == currentThreadId) {
            return;
        }
        String currentThreadName = Thread.currentThread().getName();
        String msg = String.format("Concurrency Error: Session was started in thread %s (%s) but is being used in thread %s (%s)", this.threadId, this.threadName, currentThreadId, currentThreadName);
        log.debug((Object)msg, (Throwable)new Exception(msg));
    }

    protected void checkThreadStart() {
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
    }

    protected void checkThreadEnd() {
        this.threadId = 0L;
    }

    public void close() {
        this.closeSession();
        this.repository.closeSession(this);
    }

    protected void closeSession() {
        this.live = false;
        this.context.close();
    }

    public Interaction createInteraction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Node getRootNode() {
        this.checkThread();
        this.checkLive();
        return this.rootNode;
    }

    @Override
    public Binary getBinary(InputStream in) throws StorageException {
        try {
            return this.repository.getBinary(in);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void save() throws StorageException {
        this.checkLive();
        this.flush();
        if (!this.transactionalSession.isInTransaction()) {
            this.sendInvalidationsToOthers();
            this.processReceivedInvalidations();
        }
    }

    protected void flush() throws StorageException {
        this.checkThread();
        if (!this.repository.getRepositoryDescriptor().fulltextDisabled) {
            this.context.updateFulltext(this);
        }
        this.context.save();
        if (this.readAclsChanged) {
            this.updateReadAcls();
        }
    }

    protected void sendInvalidationsToOthers() throws StorageException {
        this.repository.invalidate(this.context.gatherInvalidations(), this);
    }

    protected void processReceivedInvalidations() throws StorageException {
        this.repository.receiveClusterInvalidations();
        this.context.processReceivedInvalidations();
    }

    protected void invalidate(Invalidations invalidations) {
        this.context.invalidate(invalidations);
    }

    protected void rollback() {
        this.context.rollback();
    }

    @Override
    public Node getNodeById(Serializable id) throws StorageException {
        String name;
        Serializable parentId;
        SimpleFragment childHier;
        this.checkThread();
        this.checkLive();
        if (id == null) {
            throw new IllegalArgumentException("Illegal null id");
        }
        SimpleFragment childMain = (SimpleFragment)this.context.get(this.model.mainTableName, id, false);
        if (childMain == null) {
            if ((id = this.context.getOldId(id)) == null) {
                return null;
            }
            childMain = (SimpleFragment)this.context.get(this.model.mainTableName, id, false);
            if (childMain == null) {
                return null;
            }
        }
        String childTypeName = (String)((Object)childMain.get("primarytype"));
        if (this.model.separateMainTable) {
            childHier = (SimpleFragment)this.context.get(this.model.hierTableName, id, false);
            parentId = childHier.get("parentid");
            name = childHier.getString("name");
        } else {
            childHier = null;
            parentId = childMain.get("parentid");
            name = childMain.getString("name");
        }
        FragmentsMap childFragments = this.getFragments(id, childTypeName, parentId, name);
        FragmentGroup childGroup = new FragmentGroup(childMain, childHier, childFragments);
        return new Node(this, this.context, childGroup);
    }

    @Override
    public List<Node> getNodesByIds(List<Serializable> ids) throws StorageException {
        this.checkThread();
        this.checkLive();
        List<Fragment> mainFragments = this.context.getMulti(this.model.mainTableName, ids, false);
        HashSet<String> fragmentNames = new HashSet<String>();
        HashSet<String> typesDone = new HashSet<String>();
        ArrayList<FragmentsMap> maps = new ArrayList<FragmentsMap>(ids.size());
        for (Fragment fragment : mainFragments) {
            Set<String> f;
            if (fragment == null) {
                maps.add(null);
                continue;
            }
            FragmentsMap fragmentsMap = new FragmentsMap();
            fragmentsMap.put(this.model.mainTableName, fragment);
            maps.add(fragmentsMap);
            String typeName = (String)((Object)((SimpleFragment)fragment).get("primarytype"));
            if (!typesDone.add(typeName) || (f = this.model.getTypePrefetchedFragments(typeName)) == null) continue;
            fragmentNames.addAll(f);
        }
        fragmentNames.remove(this.model.mainTableName);
        for (String fragmentName : fragmentNames) {
            List<Fragment> fragments = this.context.getMulti(fragmentName, ids, true);
            Iterator mapsit = maps.iterator();
            for (Fragment fragment : fragments) {
                FragmentsMap fragmentsMap = (FragmentsMap)mapsit.next();
                if (fragment == null || fragmentsMap == null) continue;
                fragmentsMap.put(fragmentName, fragment);
            }
        }
        ArrayList<Node> nodes = new ArrayList<Node>(ids.size());
        Iterator mapsit = maps.iterator();
        for (Fragment main : mainFragments) {
            Node node;
            FragmentsMap fragmentsMap = (FragmentsMap)mapsit.next();
            if (main == null) {
                node = null;
            } else {
                FragmentGroup childGroup = new FragmentGroup((SimpleFragment)main, null, fragmentsMap);
                node = new Node(this, this.context, childGroup);
            }
            nodes.add(node);
        }
        return nodes;
    }

    protected FragmentsMap getFragments(Serializable id, String typeName, Serializable parentId, String name) throws StorageException {
        FragmentsMap fragments = new FragmentsMap();
        Set<String> fragmentNames = this.model.getTypePrefetchedFragments(typeName);
        if (fragmentNames != null) {
            if (parentId != null) {
                fragmentNames.remove("versions");
            }
            for (String fragmentName : fragmentNames) {
                fragments.put(fragmentName, this.context.get(fragmentName, id, true));
            }
        }
        return fragments;
    }

    @Override
    public Node getParentNode(Node node) throws StorageException {
        this.checkLive();
        if (node == null) {
            throw new IllegalArgumentException("Illegal null node");
        }
        Serializable id = node.getHierFragment().get("parentid");
        if (id == null) {
            return null;
        }
        return this.getNodeById(id);
    }

    @Override
    public String getPath(Node node) throws StorageException {
        this.checkLive();
        LinkedList<String> list = new LinkedList<String>();
        while (node != null) {
            list.add(node.getName());
            node = this.getParentNode(node);
        }
        if (list.size() == 1) {
            return "/";
        }
        Collections.reverse(list);
        return StringUtils.join(list, (String)"/");
    }

    @Override
    public Node getNodeByPath(String path, Node node) throws StorageException {
        int i;
        this.checkLive();
        if (path == null) {
            throw new IllegalArgumentException("Illegal null path");
        }
        if (path.startsWith("/")) {
            node = this.getRootNode();
            if (path.equals("/")) {
                return node;
            }
            i = 1;
        } else {
            if (node == null) {
                throw new IllegalArgumentException("Illegal relative path with null node: " + path);
            }
            i = 0;
        }
        String[] names = path.split("/", -1);
        while (i < names.length) {
            String name = names[i];
            if (name.length() == 0) {
                throw new IllegalArgumentException("Illegal path with empty component: " + path);
            }
            if ((node = this.getChildNode(node, name, false)) == null) {
                return null;
            }
            ++i;
        }
        return node;
    }

    @Override
    public Node addChildNode(Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        if (pos == null && !complexProp) {
            pos = this.context.getNextPos(parent.getId(), complexProp);
        }
        return this.addChildNode(null, parent, name, pos, typeName, complexProp);
    }

    @Override
    public Node addChildNode(Serializable id, Node parent, String name, Long pos, String typeName, boolean complexProp) throws StorageException {
        this.checkLive();
        if (name == null || name.contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        if (!this.model.isType(typeName)) {
            throw new IllegalArgumentException("Unknown type: " + typeName);
        }
        id = this.context.generateNewId(id);
        Serializable parentId = parent == null ? null : parent.mainFragment.getId();
        HashMap<String, Serializable> mainMap = new HashMap<String, Serializable>();
        mainMap.put("primarytype", (Serializable)((Object)typeName));
        HashMap<String, Serializable> hierMap = this.model.separateMainTable ? new HashMap() : mainMap;
        hierMap.put("parentid", parentId);
        hierMap.put("pos", pos);
        hierMap.put("name", (Serializable)((Object)name));
        hierMap.put("isproperty", Boolean.valueOf(complexProp));
        SimpleFragment mainRow = this.context.createSimpleFragment(this.model.mainTableName, id, mainMap);
        SimpleFragment hierRow = this.model.separateMainTable ? this.context.createSimpleFragment(this.model.hierTableName, id, hierMap) : null;
        FragmentsMap fragments = new FragmentsMap();
        FragmentGroup rowGroup = new FragmentGroup(mainRow, hierRow, fragments);
        this.requireReadAclsUpdate();
        return new Node(this, this.context, rowGroup);
    }

    @Override
    public Node addProxy(Serializable targetId, Serializable versionableId, Node parent, String name, Long pos) throws StorageException {
        Node proxy = this.addChildNode(parent, name, pos, "ecm:proxy", false);
        proxy.setSingleProperty("ecm:proxyTargetId", targetId);
        proxy.setSingleProperty("ecm:proxyVersionableId", versionableId);
        return proxy;
    }

    @Override
    public boolean hasChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        return this.context.getChildByName(parent.getId(), name, complexProp) != null;
    }

    @Override
    public Node getChildNode(Node parent, String name, boolean complexProp) throws StorageException {
        SimpleFragment childMain;
        this.checkLive();
        if (name == null || name.contains("/") || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        Serializable parentId = parent.getId();
        SimpleFragment childHier = this.context.getChildByName(parentId, name, complexProp);
        if (childHier == null) {
            return null;
        }
        Serializable childId = childHier.getId();
        if (this.model.separateMainTable) {
            childMain = (SimpleFragment)this.context.get(this.model.mainTableName, childId, false);
        } else {
            childMain = childHier;
            childHier = null;
        }
        String childTypeName = (String)((Object)childMain.get("primarytype"));
        FragmentsMap childFragments = this.getFragments(childId, childTypeName, parentId, name);
        FragmentGroup childGroup = new FragmentGroup(childMain, childHier, childFragments);
        return new Node(this, this.context, childGroup);
    }

    @Override
    public boolean hasChildren(Node parent, boolean complexProp) throws StorageException {
        this.checkLive();
        return this.context.getChildren(parent.getId(), null, complexProp).size() > 0;
    }

    @Override
    public List<Node> getChildren(Node parent, String name, boolean complexProp) throws StorageException {
        this.checkLive();
        List<SimpleFragment> fragments = this.context.getChildren(parent.getId(), name, complexProp);
        ArrayList<Node> nodes = new ArrayList<Node>(fragments.size());
        for (SimpleFragment fragment : fragments) {
            Node node = this.getNodeById(fragment.getId());
            if (node == null) {
                log.error((Object)("Child node cannot be created: " + fragment.getId()));
                continue;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void orderBefore(Node parent, Node source, Node dest) throws StorageException {
        this.checkLive();
        this.context.orderBefore(parent.getId(), source.getId(), dest == null ? null : dest.getId());
    }

    @Override
    public Node move(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        this.context.save();
        this.context.move(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return source;
    }

    @Override
    public Node copy(Node source, Node parent, String name) throws StorageException {
        this.checkLive();
        this.context.save();
        Serializable id = this.context.copy(source, parent.getId(), name);
        this.requireReadAclsUpdate();
        return this.getNodeById(id);
    }

    @Override
    public void removeNode(Node node) throws StorageException {
        this.checkLive();
        node.remove();
    }

    @Override
    public Node checkIn(Node node, String label, String description) throws StorageException {
        this.checkLive();
        this.context.save();
        Serializable id = this.context.checkIn(node, label, description);
        this.requireReadAclsUpdate();
        return this.getNodeById(id);
    }

    @Override
    public void checkOut(Node node) throws StorageException {
        this.checkLive();
        this.context.checkOut(node);
        this.requireReadAclsUpdate();
    }

    @Override
    public void restoreByLabel(Node node, String label) throws StorageException {
        this.checkLive();
        this.context.restoreByLabel(node, label);
        this.requireReadAclsUpdate();
    }

    @Override
    public Node getVersionByLabel(Serializable versionableId, String label) throws StorageException {
        this.checkLive();
        Serializable id = this.context.getVersionByLabel(versionableId, label);
        if (id == null) {
            return null;
        }
        return this.getNodeById(id);
    }

    @Override
    public Node getLastVersion(Node node) throws StorageException {
        this.checkLive();
        this.context.save();
        Serializable id = this.context.getLastVersion(node.getId());
        if (id == null) {
            return null;
        }
        return this.getNodeById(id);
    }

    @Override
    public List<Node> getVersions(Node versionableNode) throws StorageException {
        this.checkLive();
        this.context.save();
        List<SimpleFragment> fragments = this.context.getVersions(versionableNode.getId());
        ArrayList<Node> nodes = new ArrayList<Node>(fragments.size());
        for (SimpleFragment fragment : fragments) {
            nodes.add(this.getNodeById(fragment.getId()));
        }
        return nodes;
    }

    @Override
    public List<Node> getProxies(Node document, Node parent) throws StorageException {
        this.checkLive();
        this.context.save();
        List<SimpleFragment> fragments = this.context.getProxies(document, parent);
        ArrayList<Node> nodes = new ArrayList<Node>(fragments.size());
        for (SimpleFragment fragment : fragments) {
            nodes.add(this.getNodeById(fragment.getId()));
        }
        return nodes;
    }

    @Override
    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal) throws StorageException {
        return this.mapper.query(query, queryFilter, countTotal, this);
    }

    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) throws StorageException {
        return this.mapper.queryAndFetch(query, queryType, queryFilter, true, this, params);
    }

    @Override
    public void requireReadAclsUpdate() {
        this.readAclsChanged = true;
    }

    @Override
    public void updateReadAcls() throws StorageException {
        this.mapper.updateReadAcls();
        this.readAclsChanged = false;
    }

    @Override
    public void rebuildReadAcls() throws StorageException {
        this.mapper.rebuildReadAcls();
        this.readAclsChanged = false;
    }

    protected Context getContext(String tableName) {
        return this.context.getContextOrNull(tableName);
    }

    private void checkLive() {
        if (!this.live) {
            throw new IllegalStateException("Session is not live");
        }
    }

    private void computeRootNode() throws StorageException {
        String repositoryId = "default";
        Serializable rootId = this.context.getRootId((Serializable)((Object)repositoryId));
        if (rootId == null) {
            log.debug((Object)"Creating root");
            this.rootNode = this.addRootNode();
            this.addRootACP();
            this.save();
            this.context.setRootId((Serializable)((Object)repositoryId), this.rootNode.getId());
        } else {
            this.rootNode = this.getNodeById(rootId);
        }
    }

    private Node addRootNode() throws StorageException {
        this.requireReadAclsUpdate();
        Serializable id = this.context.generateNewId(null);
        HashMap<String, Serializable> mainMap = new HashMap<String, Serializable>();
        mainMap.put("primarytype", (Serializable)((Object)"Root"));
        HashMap<String, Serializable> hierMap = this.model.separateMainTable ? new HashMap() : mainMap;
        hierMap.put("parentid", null);
        hierMap.put("pos", null);
        hierMap.put("name", (Serializable)((Object)""));
        hierMap.put("isproperty", Boolean.FALSE);
        SimpleFragment mainRow = this.context.createSimpleFragment(this.model.mainTableName, id, mainMap);
        SimpleFragment hierRow = this.model.separateMainTable ? this.context.createSimpleFragment(this.model.hierTableName, id, hierMap) : null;
        FragmentGroup rowGroup = new FragmentGroup(mainRow, hierRow, null);
        return new Node(this, this.context, rowGroup);
    }

    private void addRootACP() throws StorageException {
        Serializable[] aclrows = new ACLRow[]{new ACLRow(0, "local", true, "Everything", "administrators", null), new ACLRow(1, "local", true, "Everything", "Administrator", null), new ACLRow(2, "local", true, "Read", "members", null), new ACLRow(3, "local", true, "Version", "members", null)};
        this.rootNode.setCollectionProperty("ecm:acl", aclrows);
        this.requireReadAclsUpdate();
    }

    public void checkPermission(String absPath, String actions) throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }

    public boolean hasPendingChanges() throws StorageException {
        this.checkLive();
        throw new RuntimeException("Not implemented");
    }
}

