/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Context;
import org.nuxeo.ecm.core.storage.sql.Fragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFragment
extends Fragment {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SimpleFragment.class);
    public static final SimpleFragment UNKNOWN = new SimpleFragment(null, Fragment.State.DETACHED, null, null);
    public static final Serializable OPAQUE = OpaqueValue.OPAQUE_VALUE;
    private Serializable[] data;
    private int size;

    public SimpleFragment(Serializable id, Fragment.State state, Context context, Map<String, Serializable> map) {
        super(id, state, context);
        this.data = new Serializable[context == null ? 3 : context.getTableSize() * 3];
        if (map != null) {
            this.addMap(map);
        }
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.data.length) {
            log.warn((Object)("Had to extend capacity from " + this.data.length + " to fit " + minCapacity + " for " + this));
            Serializable[] old = this.data;
            int newCapacity = this.data.length * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new Serializable[newCapacity];
            System.arraycopy(old, 0, this.data, 0, this.size);
        }
    }

    private void addMap(Map<String, Serializable> map) {
        this.ensureCapacity(3 * map.size());
        for (Map.Entry<String, Serializable> entry : map.entrySet()) {
            this.data[this.size++] = (Serializable)((Object)entry.getKey());
            Serializable value = entry.getValue();
            this.data[this.size++] = value;
            this.data[this.size++] = value;
        }
    }

    @Override
    protected Fragment.State refetch() throws StorageException {
        Fragment.State state;
        Context context = this.getContext();
        Map<String, Serializable> map = context.mapper.readSingleRowMap(context.getTableName(), this.getId(), context);
        if (map == null) {
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = null;
            }
            this.size = 0;
            state = Fragment.State.ABSENT;
        } else {
            int oldSize = this.size;
            this.size = 0;
            this.addMap(map);
            for (int i = this.size; i < oldSize; ++i) {
                this.data[i] = null;
            }
            state = Fragment.State.PRISTINE;
        }
        return state;
    }

    public void put(String key, Serializable value) throws StorageException {
        this.accessed();
        for (int i = 0; i < this.size; i += 3) {
            if (!key.equals(this.data[i])) continue;
            this.data[i + 1] = value;
            this.markModified();
            return;
        }
        this.ensureCapacity(this.size + 3);
        this.data[this.size++] = key;
        this.data[this.size++] = value;
        this.data[this.size++] = null;
        this.markModified();
    }

    public Collection<String> getDirty() {
        LinkedList<String> dirty = new LinkedList<String>();
        for (int i = 0; i < this.size; i += 3) {
            Serializable value = this.data[i + 1];
            Serializable oldValue = this.data[i + 2];
            if (value == null) {
                if (oldValue == null) continue;
                dirty.add((String)((Object)this.data[i]));
                continue;
            }
            if (value.equals(oldValue)) continue;
            dirty.add((String)((Object)this.data[i]));
        }
        return dirty;
    }

    public void clearDirty() {
        for (int i = 0; i < this.size; i += 3) {
            this.data[i + 2] = this.data[i + 1];
        }
    }

    public Serializable get(String key) throws StorageException {
        this.accessed();
        for (int i = 0; i < this.size; i += 3) {
            if (!key.equals(this.data[i])) continue;
            return this.data[i + 1];
        }
        return null;
    }

    public String getString(String key) throws StorageException {
        return (String)((Object)this.get(key));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('(');
        buf.append(this.getTableName());
        buf.append(", id=");
        buf.append(this.getId());
        buf.append(", state=");
        buf.append((Object)this.getState());
        buf.append(", ");
        buf.append('{');
        for (int i = 0; i < this.size; i += 3) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
            buf.append('=');
            Object value = this.data[i + 1];
            boolean truncated = false;
            if (value instanceof String && ((String)value).length() > 100) {
                value = ((String)value).substring(0, 100);
                truncated = true;
            }
            buf.append(value);
            if (!truncated) continue;
            buf.append("...");
        }
        buf.append("})");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OpaqueValue {
        OPAQUE_VALUE;

    }
}

