/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;

public class TransactionalSession
implements XAResource {
    private static final Log log = LogFactory.getLog(TransactionalSession.class);
    private final SessionImpl session;
    private final Mapper mapper;
    private boolean inTransaction;

    public TransactionalSession(SessionImpl session, Mapper mapper) {
        this.session = session;
        this.mapper = mapper;
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public boolean isSameRM(XAResource xaresource) {
        return xaresource == this;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0) {
            try {
                this.session.processReceivedInvalidations();
            }
            catch (Exception e) {
                log.error((Object)"Could not start transaction", (Throwable)e);
                throw (XAException)new XAException(-3).initCause(e);
            }
        }
        this.mapper.start(xid, flags);
        this.inTransaction = true;
        this.session.checkThreadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        boolean failed = true;
        try {
            if (flags != 0x20000000) {
                try {
                    this.session.flush();
                }
                catch (Exception e) {
                    log.error((Object)"Could not end transaction", (Throwable)e);
                    throw (XAException)new XAException(-3).initCause(e);
                }
            }
            failed = false;
            this.mapper.end(xid, flags);
        }
        finally {
            if (failed) {
                try {
                    this.mapper.end(xid, 0x20000000);
                }
                finally {
                    this.rollback(xid);
                }
            }
        }
    }

    public int prepare(Xid xid) throws XAException {
        return this.mapper.prepare(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.mapper.commit(xid, onePhase);
        }
        finally {
            this.inTransaction = false;
            try {
                try {
                    this.session.sendInvalidationsToOthers();
                }
                finally {
                    this.session.checkThreadEnd();
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not commit transaction", (Throwable)e);
                throw (XAException)new XAException(-3).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            try {
                this.mapper.rollback(xid);
            }
            finally {
                this.session.rollback();
            }
        }
        finally {
            this.inTransaction = false;
            try {
                try {
                    this.session.sendInvalidationsToOthers();
                }
                finally {
                    this.session.checkThreadEnd();
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not rollback transaction", (Throwable)e);
                throw (XAException)new XAException(-3).initCause(e);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        this.mapper.forget(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.mapper.recover(flag);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.mapper.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws XAException {
        return this.mapper.getTransactionTimeout();
    }
}

