/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLComplexProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLContentProperty
extends SQLComplexProperty {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String ENCODING = "encoding";
    public static final String MIME_TYPE = "mime-type";
    public static final String FILE_NAME = "name";
    public static final String DIGEST = "digest";
    public static final String LENGTH = "length";
    public static final String BINARY = "data";

    public SQLContentProperty(Node node, ComplexType type, SQLSession session, boolean readonly) {
        super(node, type, session, readonly);
    }

    public Object getValue() throws DocumentException {
        Map map = (Map)super.getValue();
        Binary binary = (Binary)map.get(BINARY);
        if (binary == null) {
            return null;
        }
        String filename = (String)map.get(FILE_NAME);
        String mimeType = (String)map.get(MIME_TYPE);
        String encoding = (String)map.get(ENCODING);
        String digest = (String)map.get(DIGEST);
        return new SQLBlob(binary, filename, mimeType, encoding, digest);
    }

    public void setValue(Object value) throws DocumentException {
        HashMap<String, Object> map;
        this.checkWritable();
        if (value == null) {
            map = null;
        } else if (value instanceof Blob) {
            Binary binary;
            map = new HashMap<String, Object>();
            Blob blob = (Blob)value;
            if (blob instanceof SQLBlob) {
                binary = ((SQLBlob)blob).binary;
            } else {
                InputStream stream;
                try {
                    stream = blob.getStream();
                }
                catch (IOException e) {
                    throw new DocumentException((Throwable)e);
                }
                binary = this.session.getBinary(stream);
            }
            String filename = blob.getFilename();
            String mimeType = blob.getMimeType();
            if (mimeType == null) {
                mimeType = APPLICATION_OCTET_STREAM;
            }
            String encoding = blob.getEncoding();
            String digest = blob.getDigest();
            Long length = binary.getLength();
            map.put(BINARY, binary);
            map.put(FILE_NAME, filename);
            map.put(MIME_TYPE, mimeType);
            map.put(ENCODING, encoding);
            map.put(DIGEST, digest);
            map.put(LENGTH, length);
        } else {
            throw new DocumentException("Setting a non-Blob value: " + value);
        }
        super.setValue(map);
    }
}

