/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLComplexProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentListIterator;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersionIterator;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.ecm.core.versioning.DocumentVersion;
import org.nuxeo.ecm.core.versioning.DocumentVersionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDocument
extends SQLComplexProperty
implements Document {
    protected static final String BINARY_TEXT_SYS_PROP = "binaryText";
    private static final Log log = LogFactory.getLog(SQLDocument.class);
    protected String lock;
    protected static final Map<String, String> systemPropNameMap = new HashMap<String, String>();

    protected SQLDocument(Node node, ComplexType type, SQLSession session, boolean readonly) {
        super(node, type, session, readonly);
    }

    public DocumentType getType() {
        return (DocumentType)this.type;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isFolder() {
        return this._isFolder();
    }

    protected boolean _isFolder() {
        return ((DocumentType)this.type).isFolder();
    }

    public String getUUID() {
        return this.getHierarchyNode().getId().toString();
    }

    public Document getParent() throws DocumentException {
        return this.session.getParent(this.getHierarchyNode());
    }

    public String getPath() throws DocumentException {
        return this.session.getPath(this.getHierarchyNode());
    }

    public Calendar getLastModified() {
        throw new UnsupportedOperationException("unused");
    }

    public boolean isProxy() {
        return false;
    }

    public Repository getRepository() {
        return this.session.getRepository();
    }

    public void remove() throws DocumentException {
        this.session.remove(this.getHierarchyNode());
    }

    public void save() throws DocumentException {
        this.session.save();
    }

    public boolean isDirty() throws DocumentException {
        Boolean value = (Boolean)this.getProperty("ecm:dirty").getValue();
        return value == null ? true : value;
    }

    public void setDirty(boolean value) throws DocumentException {
        this.setBoolean("ecm:dirty", value);
    }

    public void readDocumentPart(DocumentPart dp) throws Exception {
        for (org.nuxeo.ecm.core.api.model.Property property : dp) {
            property.init((Serializable)this.getPropertyValue(property.getName()));
        }
    }

    public void writeDocumentPart(DocumentPart dp) throws Exception {
        for (org.nuxeo.ecm.core.api.model.Property property : dp) {
            this.setPropertyValue(property.getName(), property.getValueForWrite());
        }
        SQLDocument.clearDirtyFlags((org.nuxeo.ecm.core.api.model.Property)dp);
    }

    protected static void clearDirtyFlags(org.nuxeo.ecm.core.api.model.Property property) {
        if (property.isContainer()) {
            for (org.nuxeo.ecm.core.api.model.Property p : property) {
                SQLDocument.clearDirtyFlags(p);
            }
        }
        property.clearDirtyFlags();
    }

    public <T extends Serializable> void setSystemProp(String name, T value) throws DocumentException {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        this.getProperty(propertyName).setValue(value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) throws DocumentException {
        String propertyName = systemPropNameMap.get(name);
        if (propertyName == null) {
            throw new DocumentException("Unknown system property: " + name);
        }
        Object value = this.getProperty(propertyName).getValue();
        if (value == null) {
            if (type == Boolean.class) {
                value = Boolean.FALSE;
            } else if (type == Long.class) {
                value = 0L;
            }
        }
        return (T)((Serializable)value);
    }

    public String getLifeCyclePolicy() throws LifeCycleException {
        try {
            return this.getString("ecm:lifeCyclePolicy");
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get policy", (Throwable)e);
        }
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        try {
            this.setString("ecm:lifeCyclePolicy", policy);
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set policy", (Throwable)e);
        }
    }

    public String getCurrentLifeCycleState() throws LifeCycleException {
        try {
            return this.getString("ecm:lifeCycleState");
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to get state", (Throwable)e);
        }
    }

    public void setCurrentLifeCycleState(String state) throws LifeCycleException {
        try {
            this.setString("ecm:lifeCycleState", state);
        }
        catch (DocumentException e) {
            throw new LifeCycleException("Failed to set state", (Throwable)e);
        }
    }

    public boolean followTransition(String transition) throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        service.followTransition((Document)this, transition);
        return true;
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        LifeCycleService service = NXCore.getLifeCycleService();
        if (service == null) {
            throw new LifeCycleException("LifeCycleService not available");
        }
        LifeCycle lifeCycle = service.getLifeCycleFor((Document)this);
        if (lifeCycle == null) {
            return Collections.emptyList();
        }
        return lifeCycle.getAllowedStateTransitionsFrom(this.getCurrentLifeCycleState());
    }

    public boolean isLocked() throws DocumentException {
        return this.getLock() != null;
    }

    public String getLock() throws DocumentException {
        if (this.lock != null) {
            return this.lock == "" ? null : this.lock;
        }
        String l = this.getString("ecm:lock");
        this.lock = l == null ? "" : l;
        return l;
    }

    public void setLock(String key) throws DocumentException {
        if (key == null) {
            throw new IllegalArgumentException("Lock key cannot be null");
        }
        if (this.isLocked()) {
            throw new DocumentException("Document already locked");
        }
        this.setString("ecm:lock", key);
        this.lock = key;
    }

    public String unlock() throws DocumentException {
        String l = this.getLock();
        this.setString("ecm:lock", null);
        this.lock = "";
        return l;
    }

    public boolean isVersion() {
        return false;
    }

    public Document getSourceDocument() throws DocumentException {
        return this;
    }

    public void checkIn(String label) throws DocumentException {
        this.checkIn(label, null);
    }

    public void checkIn(String label, String description) throws DocumentException {
        this.session.checkIn(this.getHierarchyNode(), label, description);
    }

    public void checkOut() throws DocumentException {
        this.session.checkOut(this.getHierarchyNode());
    }

    public boolean isCheckedOut() throws DocumentException {
        return !this.getBoolean("ecm:isCheckedIn");
    }

    public void restore(String label) throws DocumentException {
        this.session.restoreByLabel(this.getHierarchyNode(), label);
    }

    public List<String> getVersionsIds() throws DocumentException {
        Collection<DocumentVersion> versions = this.session.getVersions(this.getHierarchyNode());
        ArrayList<String> ids = new ArrayList<String>(versions.size());
        for (DocumentVersion version : versions) {
            ids.add(version.getUUID());
        }
        return ids;
    }

    public Document getVersion(String label) throws DocumentException {
        return this.session.getVersionByLabel(this.getHierarchyNode(), label);
    }

    public DocumentVersionIterator getVersions() throws DocumentException {
        return new SQLDocumentVersionIterator(this.session.getVersions(this.getHierarchyNode()));
    }

    public DocumentVersion getLastVersion() throws DocumentException {
        return this.session.getLastVersion(this.getHierarchyNode());
    }

    public boolean hasVersions() throws DocumentException {
        log.error((Object)"hasVersions unimplemented, returning false");
        return false;
    }

    public Document resolvePath(String path) throws DocumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.length() == 0) {
            return this;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return this.session.resolvePath(this.getHierarchyNode(), path);
    }

    public Document getChild(String name) throws DocumentException {
        return this._getChild(name);
    }

    protected Document _getChild(String name) throws DocumentException {
        return this.session.getChild(this.getHierarchyNode(), name);
    }

    public Iterator<Document> getChildren() throws DocumentException {
        return this._getChildren();
    }

    protected Iterator<Document> _getChildren() throws DocumentException {
        return this.getChildren(0);
    }

    public DocumentIterator getChildren(int start) throws DocumentException {
        return this._getChildren(start);
    }

    protected DocumentIterator _getChildren(int start) throws DocumentException {
        if (!this.isFolder()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        List<Document> children = this.session.getChildren(this.getHierarchyNode());
        if (start < 0) {
            throw new IllegalArgumentException(String.valueOf(start));
        }
        if (start >= children.size()) {
            return EmptyDocumentIterator.INSTANCE;
        }
        return new SQLDocumentListIterator(children.subList(start, children.size()));
    }

    public List<String> getChildrenIds() throws DocumentException {
        return this._getChildrenIds();
    }

    protected List<String> _getChildrenIds() throws DocumentException {
        if (!this.isFolder()) {
            return Collections.emptyList();
        }
        List<Document> children = this.session.getChildren(this.getHierarchyNode());
        ArrayList<String> ids = new ArrayList<String>(children.size());
        for (Document child : children) {
            ids.add(child.getUUID());
        }
        return ids;
    }

    public boolean hasChild(String name) throws DocumentException {
        return this._hasChild(name);
    }

    protected boolean _hasChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChild(this.getHierarchyNode(), name);
    }

    public boolean hasChildren() throws DocumentException {
        return this._hasChildren();
    }

    protected boolean _hasChildren() throws DocumentException {
        if (!this.isFolder()) {
            return false;
        }
        return this.session.hasChildren(this.getHierarchyNode());
    }

    public Document addChild(String name, String typeName) throws DocumentException {
        return this._addChild(name, typeName);
    }

    protected Document _addChild(String name, String typeName) throws DocumentException {
        if (!this.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        return this.session.addChild(this.getHierarchyNode(), name, null, typeName);
    }

    public void orderBefore(String src, String dest) throws DocumentException {
        this._orderBefore(src, dest);
    }

    protected void _orderBefore(String src, String dest) throws DocumentException {
        SQLDocument destDoc;
        SQLDocument srcDoc = (SQLDocument)this.getChild(src);
        if (srcDoc == null) {
            throw new DocumentException("Document " + this + " has no child: " + src);
        }
        if (dest == null) {
            destDoc = null;
        } else {
            destDoc = (SQLDocument)this.getChild(dest);
            if (destDoc == null) {
                throw new DocumentException("Document " + this + " has no child: " + dest);
            }
        }
        this.session.orderBefore(this.getHierarchyNode(), srcDoc.getHierarchyNode(), destDoc == null ? null : destDoc.getHierarchyNode());
    }

    public void removeChild(String name) throws DocumentException {
        this._removeChild(name);
    }

    protected void _removeChild(String name) throws DocumentException {
        if (!this.isFolder()) {
            return;
        }
        Document doc = this.getChild(name);
        doc.remove();
    }

    protected Property getACLProperty() throws DocumentException {
        return this.session.makeACLProperty(this.getHierarchyNode());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getName() + ',' + this.getUUID() + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SQLDocument) {
            return this.equals((SQLDocument)other);
        }
        return false;
    }

    private boolean equals(SQLDocument other) {
        return this.getHierarchyNode().getId() == other.getHierarchyNode().getId();
    }

    public int hashCode() {
        return this.getHierarchyNode().getId().hashCode();
    }

    static {
        systemPropNameMap.put("WfinProgress", "ecm:wfInProgress");
        systemPropNameMap.put("WfIncOption", "ecm:wfIncOption");
        systemPropNameMap.put(BINARY_TEXT_SYS_PROP, "ecm:binaryText");
    }
}

