/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentVersionProxy;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;
import org.nuxeo.ecm.core.versioning.DocumentVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDocumentProxy
extends SQLDocumentVersion
implements DocumentVersionProxy {
    private final Node proxyNode;
    private SQLDocumentVersion version;

    protected SQLDocumentProxy(Node proxyNode, Node versionNode, ComplexType type, SQLSession session, boolean readonly) throws DocumentException {
        super(versionNode, type, session, readonly);
        this.version = new SQLDocumentVersion(versionNode, type, session, true);
        this.proxyNode = proxyNode;
    }

    public Document getTargetDocument() {
        return this.version;
    }

    public void setTargetDocument(Document document, String label) {
        try {
            Node node = ((SQLDocument)document).getHierarchyNode();
            Document versionDocument = this.session.getVersionByLabel(node, label);
            Node versionNode = ((SQLDocument)versionDocument).getHierarchyNode();
            super.setHierarchyNode(versionNode);
            this.version = new SQLDocumentVersion(versionNode, (ComplexType)this.version.getType(), this.session, true);
            this.proxyNode.setSingleProperty("ecm:proxyTargetId", versionNode.getId());
            this.proxyNode.setSingleProperty("ecm:proxyVersionableId", node.getId());
        }
        catch (DocumentException e) {
            throw new UnsupportedOperationException();
        }
        catch (StorageException e) {
            throw new UnsupportedOperationException();
        }
    }

    public DocumentVersion getTargetVersion() {
        return this.version;
    }

    public void updateToBaseVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public boolean isVersion() {
        return false;
    }

    @Override
    protected Node getHierarchyNode() {
        return this.proxyNode;
    }

    @Override
    public Document getSourceDocument() {
        return this.version;
    }

    @Override
    public String getPath() throws DocumentException {
        return this.session.getPath(this.proxyNode);
    }

    @Override
    public Document getParent() throws DocumentException {
        return this.session.getParent(this.proxyNode);
    }

    @Override
    public boolean isFolder() {
        return this._isFolder();
    }

    @Override
    public void removeChild(String name) throws DocumentException {
        this._removeChild(name);
    }

    @Override
    public Document addChild(String name, String typeName) throws DocumentException {
        return this._addChild(name, typeName);
    }

    @Override
    public void orderBefore(String src, String dest) throws DocumentException {
        this._orderBefore(src, dest);
    }

    @Override
    public Document getChild(String name) throws DocumentException {
        return this._getChild(name);
    }

    @Override
    public Iterator<Document> getChildren() throws DocumentException {
        return this._getChildren();
    }

    @Override
    public List<String> getChildrenIds() throws DocumentException {
        return this._getChildrenIds();
    }

    @Override
    public boolean hasChild(String name) throws DocumentException {
        return this._hasChild(name);
    }

    @Override
    public boolean hasChildren() throws DocumentException {
        return this._hasChildren();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SQLDocumentProxy) {
            return this.equals((SQLDocumentProxy)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentProxy other) {
        return this.proxyNode.getId() == other.proxyNode.getId();
    }

    @Override
    public int hashCode() {
        return this.proxyNode.getId().hashCode();
    }
}

