/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.model.EmptyDocumentIterator;
import org.nuxeo.ecm.core.query.QueryException;
import org.nuxeo.ecm.core.query.QueryResult;
import org.nuxeo.ecm.core.storage.PartialList;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryResult
implements QueryResult {
    private static final Log log = LogFactory.getLog(SQLQueryResult.class);
    protected final SQLSession session;
    protected final Iterator<Serializable> it;
    protected final long size;
    protected final long totalSize;
    protected final Boolean orderByPath;
    protected final int limit;
    protected final int offset;
    protected Serializable currentId;

    public SQLQueryResult(SQLSession session, PartialList<Serializable> pl, Boolean orderByPath, long limit, long offset) {
        this.session = session;
        this.it = pl.list.iterator();
        this.size = pl.list.size();
        this.totalSize = pl.totalSize;
        this.orderByPath = orderByPath;
        this.limit = (int)limit;
        this.offset = (int)offset;
    }

    public long count() {
        return this.size;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public DocumentModelList getDocumentModels() throws QueryException {
        List<Object> docs;
        ArrayList<Serializable> ids = new ArrayList<Serializable>((int)this.size);
        while (this.it.hasNext()) {
            ids.add(this.it.next());
        }
        try {
            docs = this.session.getDocumentsById(ids);
        }
        catch (DocumentException e) {
            log.error((Object)("Could not fetch documents for ids: " + ids), (Throwable)e);
            docs = Collections.emptyList();
        }
        String[] schemas = new String[]{"common"};
        ArrayList<DocumentModelImpl> list = new ArrayList<DocumentModelImpl>((int)this.size);
        for (Document document : docs) {
            try {
                list.add(DocumentModelFactory.createDocumentModel((Document)document, (String[])schemas));
            }
            catch (DocumentException e) {
                log.error((Object)("Could not create document model for doc: " + document), (Throwable)e);
            }
        }
        if (this.orderByPath != null) {
            Collections.sort(list, new PathComparator(this.orderByPath));
        }
        if (this.limit != 0) {
            int size = list.size();
            list.subList(0, this.offset > size ? size : this.offset).clear();
            size = list.size();
            if (this.limit < size) {
                list.subList(this.limit, size).clear();
            }
        }
        return new DocumentModelListImpl(list, this.totalSize);
    }

    public DocumentIterator getDocuments(int start) {
        for (int i = 0; i < start; ++i) {
            if (!this.it.hasNext()) {
                return EmptyDocumentIterator.INSTANCE;
            }
            this.it.next();
        }
        return new DocumentIterator(){

            public Document next() {
                SQLQueryResult.this.currentId = SQLQueryResult.this.it.next();
                try {
                    return SQLQueryResult.this.session.getDocumentById(SQLQueryResult.this.currentId);
                }
                catch (DocumentException e) {
                    log.error((Object)e.getMessage());
                    return this.next();
                }
            }

            public boolean hasNext() {
                return SQLQueryResult.this.it.hasNext();
            }

            public long getSize() {
                return SQLQueryResult.this.size;
            }

            public void remove() {
            }
        };
    }

    public boolean next() {
        if (!this.it.hasNext()) {
            return false;
        }
        this.currentId = this.it.next();
        return true;
    }

    public Object getObject() throws QueryException {
        throw new UnsupportedOperationException();
    }

    public long row() {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int i) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String column) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int i, double defaultValue) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String column, double defaultValue) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public long getLong(int i, long defaultValue) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public long getLong(String column, long defaultValue) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String column) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public String getString(int i) throws QueryException {
        throw new UnsupportedOperationException();
    }

    public String getString(String column) throws QueryException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathComparator
    implements Comparator<DocumentModel> {
        private final int sign;

        public PathComparator(boolean asc) {
            this.sign = asc ? 1 : -1;
        }

        @Override
        public int compare(DocumentModel doc1, DocumentModel doc2) {
            String p1 = doc1.getPathAsString();
            String p2 = doc2.getPathAsString();
            return this.sign * p1.compareTo(p2);
        }
    }
}

