/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.security.SecurityException;
import org.nuxeo.ecm.core.security.SecurityManager;
import org.nuxeo.ecm.core.storage.sql.ACLRow;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLSecurityManager
implements SecurityManager {
    public ACP getACP(Document doc) throws SecurityException {
        try {
            Property property = ((SQLDocument)doc).getACLProperty();
            return SQLSecurityManager.aclRowsToACP((ACLRow[])property.getValue());
        }
        catch (DocumentException e) {
            throw new SecurityException(e.getMessage(), (Throwable)e);
        }
    }

    public void setACP(Document doc, ACP acp, boolean overwrite) throws SecurityException {
        if (!overwrite && acp == null) {
            return;
        }
        try {
            Property property = ((SQLDocument)doc).getACLProperty();
            ACLRow[] aclrows = overwrite ? (acp == null ? null : SQLSecurityManager.acpToAclRows(acp)) : SQLSecurityManager.updateAclRows((ACLRow[])property.getValue(), acp);
            property.setValue((Object)aclrows);
        }
        catch (DocumentException e) {
            throw new SecurityException(e.getMessage(), (Throwable)e);
        }
    }

    public ACP getMergedACP(Document doc) throws SecurityException {
        try {
            Document base;
            Document document = base = doc.isVersion() ? doc.getSourceDocument() : doc;
            if (base == null) {
                return null;
            }
            ACP acp = this.getACP(base);
            if (doc.getParent() == null) {
                return acp;
            }
            ACL acl = this.getInheritedACLs(doc);
            if (acp == null) {
                if (acl == null) {
                    return null;
                }
                acp = new ACPImpl();
            }
            if (acl != null) {
                acp.addACL(acl);
            }
            return acp;
        }
        catch (DocumentException e) {
            throw new SecurityException("Failed to get merged acp", (Throwable)e);
        }
    }

    public boolean checkPermission(Document doc, String username, String permission) throws SecurityException {
        return this.getAccess(doc, username, permission).toBoolean();
    }

    public Access getAccess(Document doc, String username, String permission) throws SecurityException {
        ACP acp = this.getMergedACP(doc);
        return acp == null ? Access.UNKNOWN : acp.getAccess(username, permission);
    }

    public void invalidateCache(Session session) {
    }

    protected static ACP aclRowsToACP(ACLRow[] acls) {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = null;
        String name = null;
        for (ACLRow aclrow : acls) {
            String user;
            if (!aclrow.name.equals(name)) {
                if (acl != null) {
                    acp.addACL(acl);
                }
                name = aclrow.name;
                acl = new ACLImpl(name);
            }
            if ((user = aclrow.user) == null) {
                user = aclrow.group;
            }
            acl.add((Object)new ACE(user, aclrow.permission, aclrow.grant));
        }
        if (acl != null) {
            acp.addACL(acl);
        }
        return acp;
    }

    protected static ACLRow[] acpToAclRows(ACP acp) {
        LinkedList<ACLRow> aclrows = new LinkedList<ACLRow>();
        for (ACL acl : acp.getACLs()) {
            String name = acl.getName();
            if (name.equals("inherited")) continue;
            for (ACE ace : acl.getACEs()) {
                SQLSecurityManager.addACLRow(aclrows, name, ace);
            }
        }
        ACLRow[] array = new ACLRow[aclrows.size()];
        return aclrows.toArray(array);
    }

    protected static ACLRow[] updateAclRows(ACLRow[] aclrows, ACP acp) {
        LinkedList<ACLRow> newaclrows = new LinkedList<ACLRow>();
        HashMap<String, ACL> aclmap = new HashMap<String, ACL>();
        for (ACL acl : acp.getACLs()) {
            String name = acl.getName();
            if ("inherited".equals(name)) continue;
            aclmap.put(name, acl);
        }
        LinkedList<ACE> aces = Collections.emptyList();
        HashSet<String> aceKeys = null;
        String name = null;
        for (ACLRow aclrow : aclrows) {
            if (!aclrow.name.equals(name)) {
                for (ACE ace : aces) {
                    SQLSecurityManager.addACLRow(newaclrows, name, ace);
                }
                name = aclrow.name;
                ACL acl = (ACL)aclmap.remove(name);
                aces = acl == null ? Collections.emptyList() : new LinkedList<ACE>(Arrays.asList(acl.getACEs()));
                aceKeys = new HashSet<String>();
                for (ACE ace : aces) {
                    aceKeys.add(SQLSecurityManager.getACEkey(ace));
                }
            }
            if (aceKeys.contains(SQLSecurityManager.getACLrowKey(aclrow))) continue;
            newaclrows.add(new ACLRow(newaclrows.size(), name, aclrow.grant, aclrow.permission, aclrow.user, aclrow.group));
        }
        for (ACE ace : aces) {
            SQLSecurityManager.addACLRow(newaclrows, name, ace);
        }
        for (ACL acl : aclmap.values()) {
            name = acl.getName();
            for (ACE ace : acl.getACEs()) {
                SQLSecurityManager.addACLRow(newaclrows, name, ace);
            }
        }
        ACLRow[] array = new ACLRow[newaclrows.size()];
        return newaclrows.toArray(array);
    }

    protected static String getACEkey(ACE ace) {
        return ace.getUsername() + '|' + ace.getPermission();
    }

    protected static String getACLrowKey(ACLRow aclrow) {
        String user = aclrow.user;
        if (user == null) {
            user = aclrow.group;
        }
        return user + '|' + aclrow.permission;
    }

    protected static void addACLRow(List<ACLRow> aclrows, String name, ACE ace) {
        String user = ace.getUsername();
        if (user == null) {
            return;
        }
        String group = null;
        aclrows.add(new ACLRow(aclrows.size(), name, ace.isGranted(), ace.getPermission(), user, group));
    }

    protected ACL getInheritedACLs(Document doc) throws DocumentException {
        ACL merged = null;
        for (doc = doc.getParent(); doc != null; doc = doc.getParent()) {
            ACP acp = this.getACP(doc);
            if (acp == null) continue;
            ACL acl = acp.getMergedACLs("inherited");
            if (merged == null) {
                merged = acl;
            } else {
                merged.addAll((Collection)acl);
            }
            if (acp.getAccess("Everyone", "Everything") == Access.DENY) break;
        }
        return merged;
    }
}

