/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Table table;
    protected final Dialect dialect;
    protected final String physicalName;
    private final String quotedName;
    private final String freeVariableSetter;
    private final ColumnType type;
    private int jdbcType;
    private final String jdbcTypeString;
    private final String key;
    private final Model model;
    private boolean identity;
    private boolean primary;
    private boolean nullable = true;
    private String defaultValue;
    private Table foreignTable;
    private String foreignKey;

    public Column(Table table, String physicalName, ColumnType type, String key, Model model) {
        this.table = table;
        this.dialect = table.getDialect();
        this.physicalName = physicalName;
        this.type = type;
        Dialect.JDBCInfo jdbcInfo = this.dialect.getJDBCTypeAndString(type);
        this.jdbcType = jdbcInfo.jdbcType;
        this.jdbcTypeString = jdbcInfo.string;
        this.key = key;
        this.model = model;
        this.quotedName = this.dialect.openQuote() + physicalName + this.dialect.closeQuote();
        this.freeVariableSetter = this.dialect.getFreeVariableSetterForType(type);
    }

    public Column(Column column, Table table) {
        this(table, column.physicalName, column.type, column.key, column.model);
    }

    public Table getTable() {
        return this.table;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public String getFullQuotedName() {
        return this.table.getQuotedName() + '.' + this.quotedName;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public ColumnType getType() {
        return this.type;
    }

    public Model getModel() {
        return this.model;
    }

    public String getFreeVariableSetter() {
        return this.freeVariableSetter;
    }

    public boolean isOpaque() {
        return this.type == ColumnType.FTINDEXED || this.type == ColumnType.FTSTORED;
    }

    public boolean setJdbcType(int actual, String actualName, int actualSize) {
        int expected = this.jdbcType;
        if (actual == expected) {
            return true;
        }
        return this.dialect.isAllowedConversion(expected, actual, actualName, actualSize);
    }

    public String getKey() {
        return this.key;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setReferences(Table foreignTable, String foreignKey) {
        this.foreignTable = foreignTable;
        this.foreignKey = foreignKey;
    }

    public Table getForeignTable() {
        return this.foreignTable;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public String getSqlTypeString() {
        return this.jdbcTypeString;
    }

    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value) throws SQLException {
        if (value == null) {
            ps.setNull(index, this.jdbcType);
            return;
        }
        if (this.jdbcType == 2003 && !(value instanceof String[])) {
            throw new SQLException("Expected String[] instead of: " + value);
        }
        this.dialect.setToPreparedStatement(ps, index, value, this);
    }

    public Serializable getFromResultSet(ResultSet rs, int index) throws SQLException {
        Serializable result = this.dialect.getFromResultSet(rs, index, this);
        if (rs.wasNull()) {
            result = null;
        }
        return result;
    }

    public Serializable[] listToArray(List<Serializable> list) {
        return this.type.collectionToArray(list);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.physicalName + ')';
    }
}

