/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Collection;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.storage.sql.Binary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColumnType {
    VARCHAR(String.class),
    CLOB(String.class),
    BOOLEAN(Boolean.class),
    LONG(Long.class),
    DOUBLE(Double.class),
    TIMESTAMP(Calendar.class),
    BLOBID(Binary.class),
    NODEID,
    NODEIDFK,
    NODEIDFKNP,
    NODEIDFKMUL,
    NODEIDFKNULL,
    NODEVAL,
    SYSNAME,
    TINYINT,
    INTEGER,
    FTINDEXED,
    FTSTORED,
    CLUSTERNODE,
    CLUSTERFRAGS;

    private final Class<?> klass;

    private ColumnType() {
        this.klass = null;
    }

    private ColumnType(Class<?> klass) {
        this.klass = klass;
    }

    public Serializable[] collectionToArray(Collection<Serializable> collection) {
        if (this.klass == null) {
            throw new IllegalStateException(this.toString());
        }
        Serializable[] array = (Serializable[])Array.newInstance(this.klass, collection.size());
        return collection.toArray(array);
    }

    public static ColumnType fromFieldType(Type coreType) {
        if (coreType instanceof StringType) {
            return VARCHAR;
        }
        if (coreType instanceof BooleanType) {
            return BOOLEAN;
        }
        if (coreType instanceof LongType) {
            return LONG;
        }
        if (coreType instanceof DoubleType) {
            return DOUBLE;
        }
        if (coreType instanceof DateType) {
            return TIMESTAMP;
        }
        if (coreType instanceof BinaryType) {
            return BLOBID;
        }
        if (coreType instanceof IntegerType) {
            return INTEGER;
        }
        if (coreType instanceof SimpleTypeImpl) {
            return ColumnType.fromFieldType(coreType.getSuperType());
        }
        throw new RuntimeException("Invalid primitive type: " + coreType.getClass().getName());
    }
}

