/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableAlias
implements Table {
    private static final long serialVersionUID = 1L;
    protected final Table table;
    protected final String alias;
    protected final Dialect dialect;

    public TableAlias(Table table, String alias) {
        this.table = table;
        this.alias = alias;
        this.dialect = table.getDialect();
    }

    @Override
    public boolean isAlias() {
        return true;
    }

    @Override
    public Table getRealTable() {
        return this.table;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public String getQuotedName() {
        return this.dialect.openQuote() + this.alias + this.dialect.closeQuote();
    }

    @Override
    public String getQuotedSuffixedName(String suffix) {
        return this.dialect.openQuote() + this.alias + suffix + this.dialect.closeQuote();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Table(");
        buf.append(this.table.getName());
        buf.append(" AS ");
        buf.append(this.alias);
        buf.append(')');
        return buf.toString();
    }

    @Override
    public Column getColumn(String name) {
        return new Column(this.table.getColumn(name), this);
    }

    @Override
    public Collection<Column> getColumns() {
        Collection<Column> columns = this.table.getColumns();
        ArrayList<Column> result = new ArrayList<Column>(columns.size());
        for (Column column : columns) {
            result.add(new Column(column, this));
        }
        return result;
    }

    @Override
    public Column addColumn(String name, ColumnType type, String key, Model model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIndex(String ... columnNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFulltextIndex(String indexName, String ... columnNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasFulltextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCreateSql() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAddColumnSql(Column column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getPostCreateSqls() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDropSql() {
        throw new UnsupportedOperationException();
    }
}

