/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableImpl
implements Table {
    private static final long serialVersionUID = 1L;
    protected final Database database;
    protected final Dialect dialect;
    protected final String name;
    private final LinkedHashMap<String, Column> columns;
    private final List<String[]> indexedColumns;
    private final Map<String[], String> fulltextIndexedColumns;

    public TableImpl(Database database, String name) {
        this.database = database;
        this.dialect = database.dialect;
        this.name = name;
        this.columns = new LinkedHashMap();
        this.indexedColumns = new LinkedList<String[]>();
        this.fulltextIndexedColumns = new HashMap<String[], String>();
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public Table getRealTable() {
        return this;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.dialect.openQuote() + this.name + this.dialect.closeQuote();
    }

    @Override
    public String getQuotedSuffixedName(String suffix) {
        return this.dialect.openQuote() + this.name + suffix + this.dialect.closeQuote();
    }

    @Override
    public Column getColumn(String name) {
        return this.columns.get(name);
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columns.values();
    }

    @Override
    public Column addColumn(String name, ColumnType type, String key, Model model) {
        String physicalName = this.database.getColumnPhysicalName(name);
        if (this.columns.containsKey(physicalName)) {
            throw new IllegalArgumentException("duplicate column " + physicalName);
        }
        Column column = new Column(this, physicalName, type, key, model);
        this.columns.put(name, column);
        return column;
    }

    @Override
    public void addIndex(String ... columnNames) {
        this.indexedColumns.add(columnNames);
    }

    @Override
    public void addFulltextIndex(String indexName, String ... columnNames) {
        this.indexedColumns.add(columnNames);
        this.fulltextIndexedColumns.put(columnNames, indexName);
    }

    @Override
    public boolean hasFulltextIndex() {
        return !this.fulltextIndexedColumns.isEmpty();
    }

    @Override
    public String getCreateSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ");
        buf.append(this.getQuotedName());
        buf.append(" (");
        Iterator<Column> it = this.columns.values().iterator();
        while (it.hasNext()) {
            this.addOneColumn(buf, it.next());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(')');
        buf.append(this.dialect.getTableTypeString(this));
        return buf.toString();
    }

    @Override
    public String getAddColumnSql(Column column) {
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ");
        buf.append(this.getQuotedName());
        buf.append(' ');
        buf.append(this.dialect.getAddColumnString());
        buf.append(' ');
        this.addOneColumn(buf, column);
        return buf.toString();
    }

    protected void addOneColumn(StringBuilder buf, Column column) {
        buf.append(column.getQuotedName());
        buf.append(' ');
        if (column.isIdentity()) {
            throw new UnsupportedOperationException();
        }
        buf.append(column.getSqlTypeString());
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            buf.append(" DEFAULT ");
            buf.append(defaultValue);
        }
        if (column.isNullable()) {
            buf.append(this.dialect.getNullColumnString());
        } else {
            buf.append(" NOT NULL");
        }
    }

    @Override
    public List<String> getPostCreateSqls() {
        LinkedList<String> sqls = new LinkedList<String>();
        Model model = null;
        for (Column column : this.columns.values()) {
            Table ft;
            model = column.getModel();
            if (column.isPrimary()) {
                StringBuilder buf = new StringBuilder();
                String constraintName = this.dialect.openQuote() + this.name + (this.dialect.storesUpperCaseIdentifiers() ? "_PK" : "_pk") + this.dialect.closeQuote();
                buf.append("ALTER TABLE ");
                buf.append(this.getQuotedName());
                buf.append(this.dialect.getAddPrimaryKeyConstraintString(constraintName));
                buf.append('(');
                buf.append(column.getQuotedName());
                buf.append(')');
                sqls.add(buf.toString());
            }
            if ((ft = column.getForeignTable()) == null) continue;
            Column fc = ft.getColumn(column.getForeignKey());
            String constraintName = this.dialect.openQuote() + this.dialect.getForeignKeyConstraintName(this.name, column.getPhysicalName(), ft.getName()) + this.dialect.closeQuote();
            StringBuilder buf = new StringBuilder();
            buf.append("ALTER TABLE ");
            buf.append(this.getQuotedName());
            buf.append(this.dialect.getAddForeignKeyConstraintString(constraintName, new String[]{column.getQuotedName()}, ft.getQuotedName(), new String[]{fc.getQuotedName()}, true));
            if (this.dialect.supportsCircularCascadeDeleteConstraints() || "id".equals(fc.getPhysicalName()) && "id".equals(column.getPhysicalName())) {
                buf.append(" ON DELETE CASCADE");
            }
            sqls.add(buf.toString());
        }
        for (String[] columnNames : this.indexedColumns) {
            ArrayList<Column> cols = new ArrayList<Column>(columnNames.length);
            ArrayList<String> qcols = new ArrayList<String>(columnNames.length);
            ArrayList<String> pcols = new ArrayList<String>(columnNames.length);
            for (String name : columnNames) {
                Column col = this.getColumn(name);
                cols.add(col);
                qcols.add(col.getQuotedName());
                pcols.add(col.getPhysicalName());
            }
            String quotedIndexName = this.dialect.openQuote() + this.dialect.getIndexName(this.name, pcols) + this.dialect.closeQuote();
            String indexName = this.fulltextIndexedColumns.get(columnNames);
            String createIndexSql = indexName != null ? this.dialect.getCreateFulltextIndexSql(indexName, quotedIndexName, this, cols, model) : this.dialect.getCreateIndexSql(quotedIndexName, this.getQuotedName(), qcols);
            sqls.add(createIndexSql);
        }
        return sqls;
    }

    @Override
    public String getDropSql() {
        StringBuilder buf = new StringBuilder();
        buf.append("DROP TABLE ");
        if (this.dialect.supportsIfExistsBeforeTableName()) {
            buf.append("IF EXISTS ");
        }
        buf.append(this.getQuotedName());
        buf.append(this.dialect.getCascadeDropConstraintsString());
        if (this.dialect.supportsIfExistsAfterTableName()) {
            buf.append(" IF EXISTS");
        }
        return buf.toString();
    }

    public String toString() {
        return "Table(" + this.name + ')';
    }
}

