/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db.dialect;

import java.io.Serializable;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.DialectDerby;
import org.nuxeo.ecm.core.storage.sql.db.dialect.DialectH2;
import org.nuxeo.ecm.core.storage.sql.db.dialect.DialectMySQL;
import org.nuxeo.ecm.core.storage.sql.db.dialect.DialectOracle;
import org.nuxeo.ecm.core.storage.sql.db.dialect.DialectPostgreSQL;
import org.nuxeo.ecm.core.storage.sql.db.dialect.DialectSQLServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dialect {
    protected final boolean storesUpperCaseIdentifiers;
    protected final boolean fulltextDisabled;
    protected final boolean aclOptimizationsEnabled;
    protected static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    public JDBCInfo jdbcInfo(String string, int jdbcType) {
        return new JDBCInfo(string, jdbcType);
    }

    public static Dialect createDialect(Connection connection, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        String databaseName;
        DatabaseMetaData metadata;
        try {
            metadata = connection.getMetaData();
            databaseName = metadata.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        if ("Apache Derby".equals(databaseName)) {
            return new DialectDerby(metadata, repositoryDescriptor);
        }
        if ("H2".equals(databaseName)) {
            return new DialectH2(metadata, repositoryDescriptor);
        }
        if ("MySQL".equals(databaseName)) {
            return new DialectMySQL(metadata, repositoryDescriptor);
        }
        if ("Oracle".equals(databaseName)) {
            return new DialectOracle(metadata, repositoryDescriptor);
        }
        if ("PostgreSQL".equals(databaseName)) {
            return new DialectPostgreSQL(metadata, repositoryDescriptor);
        }
        if ("Microsoft SQL Server".equals(databaseName)) {
            return new DialectSQLServer(metadata, repositoryDescriptor);
        }
        throw new StorageException("Unsupported database: " + databaseName);
    }

    public Dialect(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        try {
            this.storesUpperCaseIdentifiers = metadata.storesUpperCaseIdentifiers();
        }
        catch (SQLException e) {
            throw new StorageException("An error has occured.", e);
        }
        this.fulltextDisabled = repositoryDescriptor.fulltextDisabled;
        this.aclOptimizationsEnabled = repositoryDescriptor.aclOptimizationsEnabled;
    }

    public String getConnectionSchema(Connection connection) throws SQLException {
        return null;
    }

    public abstract JDBCInfo getJDBCTypeAndString(ColumnType var1);

    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        return false;
    }

    public abstract void setToPreparedStatement(PreparedStatement var1, int var2, Serializable var3, Column var4) throws SQLException;

    public abstract Serializable getFromResultSet(ResultSet var1, int var2, Column var3) throws SQLException;

    public boolean storesUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    protected int getMaxNameSize() {
        return 999;
    }

    protected int getMaxIndexNameSize() {
        return 999;
    }

    protected String makeName(String prefix, String string, String suffix, int maxNameSize) {
        int length = prefix.length() + string.length() + suffix.length();
        StringBuilder buf = new StringBuilder(length);
        if (length > maxNameSize) {
            MessageDigest digest;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e.toString(), e);
            }
            byte[] bytes = (prefix + string).getBytes();
            digest.update(bytes, 0, bytes.length);
            buf.append(prefix.substring(0, 4));
            buf.append('_');
            buf.append(Dialect.toHexString(digest.digest()).substring(0, 8));
        } else {
            buf.append(prefix).append(string);
        }
        buf.append(this.storesUpperCaseIdentifiers() ? suffix : suffix.toLowerCase());
        return buf.toString();
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder buf = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            buf.append(HEX_DIGITS[(0xF0 & b) >> 4]);
            buf.append(HEX_DIGITS[0xF & b]);
        }
        return buf.toString();
    }

    public String getForeignKeyConstraintName(String tableName, String foreignColumnName, String foreignTableName) {
        return this.makeName(tableName + '_', foreignColumnName + '_' + foreignTableName, "_FK", this.getMaxNameSize());
    }

    public String getIndexName(String tableName, List<String> columnNames) {
        return this.makeName(this.qualifyIndexName() ? tableName + '_' : "", StringUtils.join(columnNames, (char)'_'), "_IDX", this.getMaxIndexNameSize());
    }

    public String getCreateIndexSql(String indexName, String tableName, List<String> columnNames) {
        return String.format("CREATE INDEX %s ON %s (%s)", indexName, tableName, StringUtils.join(columnNames, (String)", "));
    }

    public abstract int getFulltextIndexedColumns();

    public abstract boolean getMaterializeFulltextSyntheticColumn();

    public abstract String getCreateFulltextIndexSql(String var1, String var2, Table var3, List<Column> var4, Model var5);

    public abstract String getDialectFulltextQuery(String var1);

    public abstract String[] getFulltextMatch(String var1, String var2, Column var3, Model var4, Database var5);

    public int getFulltextType() {
        return 2005;
    }

    public String getFreeVariableSetterForType(ColumnType type) {
        return "?";
    }

    public String getNoColumnsInsertString() {
        return "VALUES ( )";
    }

    public String getNullColumnString() {
        return "";
    }

    public String getTableTypeString(Table table) {
        return "";
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " ADD CONSTRAINT" + constraintName + " PRIMARY KEY ";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKeys, String referencedTable, String[] primaryKeys, boolean referencesPrimaryKey) {
        String sql = String.format(" ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s", constraintName, StringUtils.join((Object[])foreignKeys, (String)", "), referencedTable);
        if (!referencesPrimaryKey) {
            sql = sql + " (" + StringUtils.join((Object[])primaryKeys, (String)", ") + ')';
        }
        return sql;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public String getCascadeDropConstraintsString() {
        return "";
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public String getAddColumnString() {
        return "ADD COLUMN";
    }

    public abstract boolean supportsUpdateFrom();

    public abstract boolean doesUpdateFromRepeatSelf();

    public boolean needsOrderByKeysAfterDistinct() {
        return true;
    }

    public boolean needsAliasForDerivedTable() {
        return false;
    }

    public String getClobCast(boolean inOrderBy) {
        return null;
    }

    public abstract String getSecurityCheckSql(String var1);

    public boolean supportsDescendantsTable() {
        return false;
    }

    public abstract String getInTreeSql(String var1);

    public boolean isFulltextTableNeeded() {
        return true;
    }

    public boolean supportsArrays() {
        return false;
    }

    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        throw new SQLException("Not supported");
    }

    public abstract Collection<ConditionalStatement> getConditionalStatements(Model var1, Database var2);

    public abstract Collection<ConditionalStatement> getTestConditionalStatements(Model var1, Database var2);

    public boolean isClusteringSupported() {
        return false;
    }

    public String getCleanupClusterNodesSql(Model model, Database database) {
        return null;
    }

    public String getCreateClusterNodeSql(Model model, Database database) {
        return null;
    }

    public String getRemoveClusterNodeSql(Model model, Database database) {
        return null;
    }

    public String getClusterInsertInvalidations() {
        return null;
    }

    public String getClusterGetInvalidations() {
        return null;
    }

    public boolean supportsIlike() {
        return false;
    }

    public boolean supportsReadAcl() {
        return false;
    }

    public String getUpdateReadAclsSql() {
        return null;
    }

    public String getRebuildReadAclsSql() {
        return null;
    }

    public String getReadAclsCheckSql(String idColumnName) {
        return null;
    }

    public boolean preCreateTable(Connection connection, Table table, Model model, Database database) throws SQLException {
        return true;
    }

    public List<String> getPostCreateTableSqls(Table table, Model model, Database database) {
        return Collections.emptyList();
    }

    public void existingTableDetected(Connection connection, Table table, Model model, Database database) throws SQLException {
    }

    public boolean connectionClosedByException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t instanceof SocketException;
    }

    public static final class JDBCInfo {
        public final String string;
        public final int jdbcType;

        public JDBCInfo(String string, int jdbcType) {
            this.string = string;
            this.jdbcType = jdbcType;
        }
    }
}

