/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectDerby
extends Dialect {
    private final String className = "org.nuxeo.ecm.core.storage.sql.db.DerbyFunctions";

    public DialectDerby(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, repositoryDescriptor);
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("VARCHAR(32672)", 12);
            }
            case CLOB: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("SMALLINT", 5);
            }
            case LONG: {
                return this.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("VARCHAR(250)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("SMALLINT", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case FTINDEXED: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("VARCHAR(4000)", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case 5: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return column.getModel().getBinary(string);
                }
                return string;
            }
            case 5: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 0;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        return query;
    }

    @Override
    public String[] getFulltextMatch(String indexName, String fulltextQuery, Column mainColumn, Model model, Database database) {
        String colFmt;
        Column ftColumn = database.getTable("fulltext").getColumn("fulltext");
        String qname = ftColumn.getFullQuotedName();
        if (ftColumn.getJdbcType() == 2005 && (colFmt = this.getClobCast(false)) != null) {
            qname = String.format(colFmt, qname, 255);
        }
        String whereExpr = String.format("NX_CONTAINS(%s, ?) = 1", qname);
        return new String[]{null, null, whereExpr, fulltextQuery};
    }

    @Override
    public boolean supportsUpdateFrom() {
        return false;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        return "CAST(%s AS VARCHAR(%d))";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public Collection<ConditionalStatement> getConditionalStatements(Model model, Database database) {
        String methodSuffix;
        String idType;
        switch (model.idGenPolicy) {
            case APP_UUID: {
                idType = "VARCHAR(36)";
                methodSuffix = "String";
                break;
            }
            case DB_IDENTITY: {
                idType = "INTEGER";
                methodSuffix = "Long";
                break;
            }
            default: {
                throw new AssertionError((Object)model.idGenPolicy);
            }
        }
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(this.makeFunction("NX_IN_TREE", String.format("(ID %s, BASEID %<s) RETURNS SMALLINT", idType), "isInTree" + methodSuffix, "READS SQL DATA"));
        statements.add(this.makeFunction("NX_ACCESS_ALLOWED", String.format("(ID %s, PRINCIPALS VARCHAR(10000), PERMISSIONS VARCHAR(10000)) RETURNS SMALLINT", idType), "isAccessAllowed" + methodSuffix, "READS SQL DATA"));
        if (!this.fulltextDisabled) {
            statements.add(this.makeFunction("NX_PARSE_FULLTEXT", "(S1 VARCHAR(10000), S2 VARCHAR(10000)) RETURNS VARCHAR(10000)", "parseFullText", ""));
            statements.add(this.makeFunction("NX_CONTAINS", "(FT VARCHAR(10000), QUERY VARCHAR(10000)) RETURNS SMALLINT", "matchesFullTextDerby", ""));
            Table ft = database.getTable("fulltext");
            Column ftft = ft.getColumn("fulltext");
            Column ftst = ft.getColumn("simpletext");
            Column ftbt = ft.getColumn("binarytext");
            Column ftid = ft.getColumn("id");
            statements.add(this.makeTrigger("NX_TRIG_FT_INSERT", String.format("AFTER INSERT ON %1$s REFERENCING NEW AS NEW FOR EACH ROW UPDATE %1$s SET %2$s = NX_PARSE_FULLTEXT(CAST(%3$s AS VARCHAR(10000)), CAST(%4$s AS VARCHAR(10000))) WHERE %5$s = NEW.%5$s", ft.getQuotedName(), ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName(), ftid.getQuotedName())));
            statements.add(this.makeTrigger("NX_TRIG_FT_UPDATE", String.format("AFTER UPDATE OF %3$s, %4$s ON %1$s REFERENCING NEW AS NEW FOR EACH ROW UPDATE %1$s SET %2$s = NX_PARSE_FULLTEXT(CAST(%3$s AS VARCHAR(10000)), CAST(%4$s AS VARCHAR(10000))) WHERE %5$s = NEW.%5$s", ft.getQuotedName(), ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName(), ftid.getQuotedName())));
        }
        return statements;
    }

    private ConditionalStatement makeFunction(String functionName, String proto, String methodName, String info) {
        return new ConditionalStatement(true, null, String.format("SELECT ALIAS FROM SYS.SYSALIASES WHERE ALIAS = '%s' AND ALIASTYPE = 'F'", functionName), String.format("DROP FUNCTION %s", functionName), String.format("CREATE FUNCTION %s%s LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '%s.%s' %s", functionName, proto, "org.nuxeo.ecm.core.storage.sql.db.DerbyFunctions", methodName, info));
    }

    private ConditionalStatement makeTrigger(String triggerName, String body) {
        return new ConditionalStatement(false, null, String.format("SELECT TRIGGERNAME FROM SYS.SYSTRIGGERS WHERE TRIGGERNAME = '%s'", triggerName), String.format("DROP TRIGGER %s", triggerName), String.format("CREATE TRIGGER %s %s", triggerName, body));
    }

    @Override
    public Collection<ConditionalStatement> getTestConditionalStatements(Model model, Database database) {
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE TABLE TESTSCHEMA2 (ID VARCHAR(36) NOT NULL, TITLE CLOB)"));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "ALTER TABLE TESTSCHEMA2 ADD CONSTRAINT TESTSCHEMA2_PK PRIMARY KEY (ID)"));
        return statements;
    }
}

