/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectH2
extends Dialect {
    private static final String DEFAULT_FULLTEXT_ANALYZER = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private static final String h2Functions = "org.nuxeo.ecm.core.storage.sql.db.H2Functions";
    private static final String h2Fulltext = "org.nuxeo.ecm.core.storage.sql.db.H2Fulltext";
    private static final String h2TrigDesc = "org.nuxeo.ecm.core.storage.sql.db.H2TriggerDescendants";

    public DialectH2(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, repositoryDescriptor);
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("VARCHAR", 12);
            }
            case CLOB: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("BOOLEAN", 16);
            }
            case LONG: {
                return this.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("VARCHAR(250)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case FTINDEXED: {
                throw new AssertionError((Object)type);
            }
            case FTSTORED: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("VARCHAR", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case 16: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return column.getModel().getBinary(string);
                }
                return string;
            }
            case 16: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        ArrayList<String> columnNames = new ArrayList<String>(columns.size());
        for (Column col : columns) {
            columnNames.add("'" + col.getPhysicalName() + "'");
        }
        String fullIndexName = String.format("PUBLIC_%s_%s", table.getName(), indexName);
        String analyzer = model.getFulltextInfo().indexAnalyzer.get(indexName);
        if (analyzer == null) {
            analyzer = DEFAULT_FULLTEXT_ANALYZER;
        }
        return String.format("CALL NXFT_CREATE_INDEX('%s', 'PUBLIC', '%s', (%s), '%s')", fullIndexName, table.getName(), StringUtils.join(columnNames, (String)", "), analyzer);
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        query = query.replaceAll(" +", " ");
        LinkedList<String> pos = new LinkedList<String>();
        LinkedList<String> neg = new LinkedList<String>();
        for (String word : StringUtils.split((String)query, (char)' ', (boolean)false)) {
            if (word.startsWith("-")) {
                neg.add(word);
                continue;
            }
            if (word.startsWith("+")) {
                pos.add(word);
                continue;
            }
            pos.add("+" + word);
        }
        if (pos.isEmpty()) {
            return "+DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        String res = StringUtils.join(pos, (String)" ");
        if (!neg.isEmpty()) {
            res = res + " " + StringUtils.join(neg, (String)" ");
        }
        return res;
    }

    @Override
    public String[] getFulltextMatch(String indexName, String fulltextQuery, Column mainColumn, Model model, Database database) {
        String phftname = database.getTable("fulltext").getName();
        String fullIndexName = "PUBLIC_" + phftname + "_" + indexName;
        String queryTable = String.format("NXFT_SEARCH('%s', ?) %%s ON %s = %%<s.KEY", fullIndexName, mainColumn.getFullQuotedName());
        String whereExpr = "%s.KEY IS NOT NULL";
        return new String[]{queryTable, fulltextQuery, whereExpr, null};
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return false;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getReadAclsCheckSql(String idColumnName) {
        return String.format("%s IN (SELECT * FROM nx_get_read_acls_for(?))", idColumnName);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "SELECT nx_update_read_acls();";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "SELECT nx_rebuild_read_acls();";
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        if (!inOrderBy) {
            return "CAST(%s AS VARCHAR)";
        }
        return null;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?)", idColumnName);
    }

    @Override
    public boolean supportsDescendantsTable() {
        return true;
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("EXISTS(SELECT 1 FROM DESCENDANTS WHERE ID = ? AND DESCENDANTID = %s)", idColumnName);
    }

    @Override
    public boolean isFulltextTableNeeded() {
        return false;
    }

    @Override
    public boolean supportsArrays() {
        return false;
    }

    @Override
    public Collection<ConditionalStatement> getConditionalStatements(Model model, Database database) {
        assert (model.idGenPolicy == RepositoryDescriptor.IdGenPolicy.APP_UUID);
        Table ht = database.getTable(model.hierTableName);
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(this.makeFunction("NX_IN_TREE", "isInTreeString"));
        statements.add(this.makeFunction("NX_ACCESS_ALLOWED", "isAccessAllowedString"));
        statements.add(this.makeFunction("NX_CLUSTER_INVAL", "clusterInvalidateString"));
        statements.add(this.makeFunction("NX_CLUSTER_GET_INVALS", "getClusterInvalidationsString"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE TABLE IF NOT EXISTS read_acls (  id character varying(4096) PRIMARY KEY,  acl character varying(4096));"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE TABLE IF NOT EXISTS hierarchy_read_acl (  id character varying(36) PRIMARY KEY,  acl_id character varying(4096),  CONSTRAINT hierarchy_read_acl_id_fk FOREIGN KEY (id) REFERENCES hierarchy(id) ON DELETE CASCADE);"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE INDEX IF NOT EXISTS hierarchy_read_acl_acl_id_idx ON hierarchy_read_acl(acl_id);"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE TABLE IF NOT EXISTS hierarchy_modified_acl (  id character varying(36),  is_new boolean);"));
        statements.add(this.makeFunction("nx_get_read_acl", "getReadAcl"));
        statements.add(this.makeFunction("nx_get_read_acls_for", "getReadAclsFor"));
        statements.add(this.makeFunction("nx_rebuild_read_acls", "rebuildReadAcls"));
        statements.add(this.makeFunction("nx_update_read_acls", "updateReadAcls"));
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "DROP TRIGGER IF EXISTS nx_trig_acls_modified;", "CREATE TRIGGER nx_trig_acls_modified\n  AFTER INSERT, UPDATE, DELETE ON acls\n  FOR EACH ROW CALL \"org.nuxeo.ecm.core.storage.sql.db.H2Functions$LogAclsModified\";"));
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "DROP TRIGGER IF EXISTS nx_trig_hierarchy_modified;", "CREATE TRIGGER nx_trig_hierarchy_modified\n  AFTER INSERT, UPDATE ON hierarchy\n  FOR EACH ROW CALL \"org.nuxeo.ecm.core.storage.sql.db.H2Functions$LogHierarchyModified\";"));
        statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM read_acls LIMIT 1);", "SELECT * FROM nx_rebuild_read_acls();", "SELECT 1;"));
        statements.add(this.makeFunction("NX_INIT_DESCENDANTS", "initDescendants"));
        if (!this.fulltextDisabled) {
            statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, String.format("CREATE ALIAS IF NOT EXISTS NXFT_INIT FOR \"%s.init\"; CALL NXFT_INIT()", h2Fulltext)));
        }
        statements.add(this.makeTrigger("NX_TRIG_DESC", ht.getQuotedName(), h2TrigDesc));
        return statements;
    }

    @Override
    public List<String> getPostCreateTableSqls(Table table, Model model, Database database) {
        if (table.getName().equals("descendants".toUpperCase())) {
            return Arrays.asList("CALL NX_INIT_DESCENDANTS()");
        }
        return Collections.emptyList();
    }

    private ConditionalStatement makeFunction(String functionName, String methodName) {
        return new ConditionalStatement(true, Boolean.TRUE, null, String.format("DROP ALIAS IF EXISTS %s", functionName), String.format("CREATE ALIAS %s FOR \"%s.%s\"", functionName, h2Functions, methodName));
    }

    private ConditionalStatement makeTrigger(String triggerName, String tableName, String className) {
        return new ConditionalStatement(false, Boolean.TRUE, null, String.format("DROP TRIGGER IF EXISTS %s", triggerName), String.format("CREATE TRIGGER %s AFTER INSERT, UPDATE, DELETE ON %s FOR EACH ROW CALL \"%s\"", triggerName, tableName, className));
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getCleanupClusterNodesSql(Model model, Database database) {
        Table cln = database.getTable("cluster_nodes");
        Column clnid = cln.getColumn("nodeid");
        return String.format("DELETE FROM %s C WHERE NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.SESSIONS S WHERE C.%s = S.ID) OR C.%<s = SESSION_ID()", cln.getQuotedName(), clnid.getQuotedName());
    }

    @Override
    public String getCreateClusterNodeSql(Model model, Database database) {
        Table cln = database.getTable("cluster_nodes");
        Column clnid = cln.getColumn("nodeid");
        Column clncr = cln.getColumn("created");
        return String.format("INSERT INTO %s (%s, %s) VALUES (SESSION_ID(), CURRENT_TIMESTAMP)", cln.getQuotedName(), clnid.getQuotedName(), clncr.getQuotedName());
    }

    @Override
    public String getRemoveClusterNodeSql(Model model, Database database) {
        Table cln = database.getTable("cluster_nodes");
        Column clnid = cln.getColumn("nodeid");
        return String.format("DELETE FROM %s WHERE %s = SESSION_ID()", cln.getQuotedName(), clnid.getQuotedName());
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "CALL NX_CLUSTER_INVAL(?, ?, ?)";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT * FROM NX_CLUSTER_GET_INVALS()";
    }

    @Override
    public Collection<ConditionalStatement> getTestConditionalStatements(Model model, Database database) {
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE TABLE TESTSCHEMA2 (ID VARCHAR(36) NOT NULL, TITLE CLOB)"));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "ALTER TABLE TESTSCHEMA2 ADD CONSTRAINT TESTSCHEMA2_PK PRIMARY KEY (ID)"));
        return statements;
    }
}

