/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db.dialect;

import java.io.Serializable;
import java.net.SocketException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectMySQL
extends Dialect {
    public DialectMySQL(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, repositoryDescriptor);
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKeys, String referencedTable, String[] primaryKeys, boolean referencesPrimaryKey) {
        String cols = StringUtils.join((Object[])foreignKeys, (String)", ");
        String sql = String.format(" ADD INDEX %s (%s), ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", constraintName, cols, constraintName, cols, referencedTable, StringUtils.join((Object[])primaryKeys, (String)", "));
        return sql;
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("VARCHAR(500)", 12);
            }
            case CLOB: {
                return this.jdbcInfo("LONGTEXT", -1);
            }
            case BOOLEAN: {
                return this.jdbcInfo("BIT", -7);
            }
            case LONG: {
                return this.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("DATETIME", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("VARCHAR(256)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case FTINDEXED: {
                throw new AssertionError((Object)type);
            }
            case FTSTORED: {
                return this.jdbcInfo("LONGTEXT", -1);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("INTEGER", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("TEXT", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == -1) {
            return true;
        }
        if (expected == -1 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case -1: 
            case 12: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case -1: 
            case 12: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return column.getModel().getBinary(string);
                }
                return string;
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        ArrayList<String> columnNames = new ArrayList<String>(columns.size());
        for (Column col : columns) {
            columnNames.add(col.getQuotedName());
        }
        return String.format("CREATE FULLTEXT INDEX %s ON %s (%s)", quotedIndexName, table.getQuotedName(), StringUtils.join(columnNames, (String)", "));
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        query = query.replaceAll(" +", " ");
        LinkedList<String> pos = new LinkedList<String>();
        LinkedList<String> neg = new LinkedList<String>();
        for (String word : StringUtils.split((String)query, (char)' ', (boolean)false)) {
            if (word.startsWith("-")) {
                neg.add(word);
                continue;
            }
            if (word.startsWith("+")) {
                pos.add(word);
                continue;
            }
            pos.add("+" + word);
        }
        if (pos.isEmpty()) {
            return "+DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        String res = StringUtils.join(pos, (String)" ");
        if (!neg.isEmpty()) {
            res = res + " " + StringUtils.join(neg, (String)" ");
        }
        return res;
    }

    @Override
    public String[] getFulltextMatch(String indexName, String fulltextQuery, Column mainColumn, Model model, Database database) {
        String suffix = model.getFulltextIndexSuffix(indexName);
        Column stColumn = database.getTable("fulltext").getColumn("simpletext" + suffix);
        Column btColumn = database.getTable("fulltext").getColumn("binarytext" + suffix);
        String whereExpr = String.format("MATCH (%s, %s) AGAINST (? IN BOOLEAN MODE)", stColumn.getFullQuotedName(), btColumn.getFullQuotedName());
        return new String[]{null, null, whereExpr, fulltextQuery};
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public String getTableTypeString(Table table) {
        if (table.hasFulltextIndex()) {
            return " ENGINE=MyISAM";
        }
        return " ENGINE=InnoDB";
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean needsOrderByKeysAfterDistinct() {
        return false;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?)", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("NX_IN_TREE(%s, ?)", idColumnName);
    }

    @Override
    public Collection<ConditionalStatement> getConditionalStatements(Model model, Database database) {
        String idType;
        switch (model.idGenPolicy) {
            case APP_UUID: {
                idType = "varchar(36)";
                break;
            }
            case DB_IDENTITY: {
                idType = "integer";
                break;
            }
            default: {
                throw new AssertionError((Object)model.idGenPolicy);
            }
        }
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.TRUE, null, "DROP FUNCTION IF EXISTS NX_IN_TREE", String.format("CREATE FUNCTION NX_IN_TREE(id %s, baseid %<s) RETURNS BOOLEAN LANGUAGE SQL READS SQL DATA BEGIN  DECLARE curid %<s DEFAULT id;  IF baseid IS NULL OR id IS NULL OR baseid = id THEN    RETURN FALSE;  END IF;  LOOP    SELECT parentid INTO curid FROM hierarchy WHERE hierarchy.id = curid;    IF curid IS NULL THEN      RETURN FALSE;     ELSEIF curid = baseid THEN      RETURN TRUE;    END IF;  END LOOP;END", idType)));
        statements.add(new ConditionalStatement(true, Boolean.TRUE, null, "DROP FUNCTION IF EXISTS NX_ACCESS_ALLOWED", String.format("CREATE FUNCTION NX_ACCESS_ALLOWED(id %s, users VARCHAR(10000), perms VARCHAR(10000)) RETURNS BOOLEAN LANGUAGE SQL READS SQL DATA BEGIN  DECLARE allusers VARCHAR(10000) DEFAULT CONCAT('|',users,'|');  DECLARE allperms VARCHAR(10000) DEFAULT CONCAT('|',perms,'|');  DECLARE first BOOLEAN DEFAULT TRUE;  DECLARE curid %<s DEFAULT id;  DECLARE newid %<s;  DECLARE gr BIT;  DECLARE pe VARCHAR(1000);  DECLARE us VARCHAR(1000);  WHILE curid IS NOT NULL DO    BEGIN      DECLARE done BOOLEAN DEFAULT FALSE;      DECLARE cur CURSOR FOR        SELECT `grant`, `permission`, `user` FROM `acls`        WHERE `acls`.`id` = curid ORDER BY `pos`;      DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;      OPEN cur;      REPEAT         FETCH cur INTO gr, pe, us;        IF NOT done THEN          IF LOCATE(CONCAT('|',us,'|'), allusers) <> 0 AND LOCATE(CONCAT('|',pe,'|'), allperms) <> 0 THEN            CLOSE cur;            RETURN gr;          END IF;        END IF;      UNTIL done END REPEAT;      CLOSE cur;    END;    SELECT parentid INTO newid FROM hierarchy WHERE hierarchy.id = curid;    IF first AND newid IS NULL THEN      SELECT versionableid INTO newid FROM versions WHERE versions.id = curid;    END IF;    SET first = FALSE;    SET curid = newid;  END WHILE;  RETURN FALSE; END", idType)));
        return statements;
    }

    @Override
    public Collection<ConditionalStatement> getTestConditionalStatements(Model model, Database database) {
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE TABLE `testschema2` (`id` VARCHAR(36) NOT NULL, `title` LONGTEXT) ENGINE=InnoDB"));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "ALTER TABLE `testschema2` ADD CONSTRAINT `testschema2_pk` PRIMARY KEY (`id`)"));
        return statements;
    }

    @Override
    public boolean connectionClosedByException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SocketException) {
            return true;
        }
        String message = t.toString() + " " + t.getMessage();
        return message.contains("Communications link failure") || message.contains("CommunicationsException");
    }

    protected static class DebugStatements {
        protected DebugStatements() {
        }

        public ConditionalStatement makeDebugTable() {
            return new ConditionalStatement(true, Boolean.TRUE, null, "DROP TABLE IF EXISTS NX_DEBUG_TABLE", "CREATE TABLE NX_DEBUG_TABLE (id INTEGER AUTO_INCREMENT PRIMARY KEY, log VARCHAR(10000))");
        }

        public ConditionalStatement makeNxDebug() {
            return new ConditionalStatement(true, Boolean.TRUE, null, "DROP PROCEDURE IF EXISTS NX_DEBUG", String.format("CREATE PROCEDURE NX_DEBUG(line VARCHAR(10000)) LANGUAGE SQL BEGIN   INSERT INTO NX_DEBUG_TABLE (log) values (line);END", new Object[0]));
        }
    }
}

