/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db.dialect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectOracle
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectOracle.class);
    protected final String fulltextParameters;
    private static boolean initialized;
    private static Constructor<?> arrayDescriptorConstructor;
    private static Constructor<?> arrayConstructor;

    public DialectOracle(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, repositoryDescriptor);
        this.fulltextParameters = repositoryDescriptor.fulltextAnalyzer == null ? "" : repositoryDescriptor.fulltextAnalyzer;
    }

    @Override
    public String getConnectionSchema(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        String sql = "SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL";
        log.trace((Object)("SQL: " + sql));
        ResultSet rs = st.executeQuery(sql);
        rs.next();
        String user = rs.getString(1);
        log.trace((Object)("SQL:   -> " + user));
        st.close();
        return user;
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return " CASCADE CONSTRAINTS";
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("NVARCHAR2(2000)", 12);
            }
            case CLOB: {
                return this.jdbcInfo("NCLOB", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("NUMBER(1,0)", -7);
            }
            case LONG: {
                return this.jdbcInfo("NUMBER(19,0)", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR2(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR2(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("VARCHAR2(250)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("NUMBER(3,0)", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("NUMBER(10,0)", 4);
            }
            case FTINDEXED: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return this.jdbcInfo("NCLOB", 2005);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("NUMBER(10,0)", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("VARCHAR2(4000)", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 8 && actual == 6) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NVARCHAR2")) {
            return true;
        }
        if (expected == 2005 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        if (expected == -7 && actual == 3 && actualName.equals("NUMBER") && actualSize == 1) {
            return true;
        }
        if (expected == 4 && actual == 3 && actualName.equals("NUMBER") && actualSize == 10) {
            return true;
        }
        if (expected == -5 && actual == 3 && actualName.equals("NUMBER") && actualSize == 19) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        return expected == 2005 && actual == 1111 && actualName.equals("NVARCHAR2");
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return column.getModel().getBinary(string);
                }
                return string;
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    protected int getMaxNameSize() {
        return 30;
    }

    @Override
    protected int getMaxIndexNameSize() {
        return 25;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        return String.format("CREATE INDEX %s ON %s(%s) INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('%s SYNC (ON COMMIT) TRANSACTIONAL')", quotedIndexName, table.getQuotedName(), columns.get(0).getQuotedName(), this.fulltextParameters);
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        query = query.replaceAll(" +", " ");
        LinkedList<String> pos = new LinkedList<String>();
        LinkedList<String> neg = new LinkedList<String>();
        for (String word : StringUtils.split((String)query, (char)' ', (boolean)false)) {
            if (word.startsWith("-")) {
                neg.add(word.substring(1));
                continue;
            }
            if (word.startsWith("+")) {
                pos.add(word.substring(1));
                continue;
            }
            pos.add(word);
        }
        if (pos.isEmpty()) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        String res = StringUtils.join(pos, (String)" & ");
        if (!neg.isEmpty()) {
            res = res + " ~ " + StringUtils.join(neg, (String)" ~ ");
        }
        return res;
    }

    @Override
    public String[] getFulltextMatch(String indexName, String fulltextQuery, Column mainColumn, Model model, Database database) {
        String suffix = model.getFulltextIndexSuffix(indexName);
        Column ftColumn = database.getTable("fulltext").getColumn("fulltext" + suffix);
        String whereExpr = String.format("CONTAINS(%s, ?) > 0", ftColumn.getFullQuotedName());
        return new String[]{null, null, whereExpr, fulltextQuery};
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 1;
    }

    @Override
    public boolean supportsUpdateFrom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        return "CAST(%s AS NVARCHAR2(%d))";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    private static void init() throws SQLException {
        if (!initialized) {
            try {
                Class<?> arrayDescriptorClass = Class.forName("oracle.sql.ArrayDescriptor");
                arrayDescriptorConstructor = arrayDescriptorClass.getConstructor(String.class, Connection.class);
                Class<?> arrayClass = Class.forName("oracle.sql.ARRAY");
                arrayConstructor = arrayClass.getConstructor(arrayDescriptorClass, Connection.class, Object.class);
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
            initialized = true;
        }
    }

    @Override
    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        if (elements == null || elements.length == 0) {
            return null;
        }
        DialectOracle.init();
        try {
            Object arrayDescriptor = arrayDescriptorConstructor.newInstance("NX_ARRAY", connection);
            return (Array)arrayConstructor.newInstance(arrayDescriptor, connection, elements);
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    @Override
    public Collection<ConditionalStatement> getConditionalStatements(Model model, Database database) {
        String declaredType;
        String idType;
        switch (model.idGenPolicy) {
            case APP_UUID: {
                idType = "VARCHAR2";
                declaredType = "VARCHAR2(36)";
                break;
            }
            case DB_IDENTITY: {
                idType = "INTEGER";
                declaredType = "INTEGER";
                break;
            }
            default: {
                throw new AssertionError((Object)model.idGenPolicy);
            }
        }
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE OR REPLACE TYPE NX_ARRAY AS VARRAY(99) OF VARCHAR2(100);"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, String.format("CREATE OR REPLACE FUNCTION NX_IN_TREE(id %s, baseid %<s) RETURN NUMBER IS   curid %s := id; BEGIN  IF baseid IS NULL OR id IS NULL OR baseid = id THEN    RETURN 0;  END IF;  LOOP    SELECT parentid INTO curid FROM hierarchy WHERE hierarchy.id = curid;    IF curid IS NULL THEN      RETURN 0;     ELSIF curid = baseid THEN      RETURN 1;    END IF;  END LOOP; END;", idType, declaredType)));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, String.format("CREATE OR REPLACE FUNCTION NX_ACCESS_ALLOWED(id %s, users NX_ARRAY, permissions NX_ARRAY) RETURN NUMBER IS   curid %s := id;  newid %<s;  first BOOLEAN := TRUE;BEGIN  WHILE curid IS NOT NULL LOOP    FOR r IN (SELECT * FROM acls WHERE acls.id = curid ORDER BY acls.pos) LOOP      FOR i IN permissions.FIRST .. permissions.LAST LOOP        IF r.permission = permissions(i) THEN          FOR j IN users.FIRST .. users.LAST LOOP            IF r.user = users(j) THEN              RETURN r.\"GRANT\";            END IF;          END LOOP;          EXIT;        END IF;      END LOOP;    END LOOP;    SELECT parentid INTO newid FROM hierarchy WHERE hierarchy.id = curid;    IF first AND newid IS NULL THEN      SELECT versionableid INTO newid FROM versions WHERE versions.id = curid;    END IF;    first := FALSE;    curid := newid;  END LOOP;  RETURN 0; END;", idType, declaredType)));
        if (!this.fulltextDisabled) {
            Table ft = database.getTable("fulltext");
            Model.FulltextInfo fti = model.getFulltextInfo();
            ArrayList<String> lines = new ArrayList<String>(fti.indexNames.size());
            for (String indexName : fti.indexNames) {
                String suffix = model.getFulltextIndexSuffix(indexName);
                Column ftft = ft.getColumn("fulltext" + suffix);
                Column ftst = ft.getColumn("simpletext" + suffix);
                Column ftbt = ft.getColumn("binarytext" + suffix);
                String line = String.format("  :NEW.%s := :NEW.%s || :NEW.%s; ", ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName());
                lines.add(line);
            }
            statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE TRIGGER NX_TRIG_FT_UPDATE BEFORE INSERT OR UPDATE ON \"FULLTEXT\" FOR EACH ROW BEGIN" + StringUtils.join(lines, (String)"") + "END;"));
        }
        return statements;
    }

    @Override
    public Collection<ConditionalStatement> getTestConditionalStatements(Model model, Database database) {
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE TABLE TESTSCHEMA2 (ID VARCHAR2(36) NOT NULL, TITLE NCLOB)"));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "ALTER TABLE TESTSCHEMA2 ADD CONSTRAINT TESTSCHEMA2_PK PRIMARY KEY (ID)"));
        return statements;
    }

    @Override
    public boolean connectionClosedByException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SocketException) {
            return true;
        }
        Integer err = 0;
        try {
            Method m = t.getClass().getMethod("getOracleError", new Class[0]);
            err = (Integer)m.invoke((Object)t, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (err) {
            case 17002: {
                return true;
            }
        }
        return false;
    }
}

