/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db.dialect;

import java.io.Serializable;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectPostgreSQL
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectPostgreSQL.class);
    private static final String DEFAULT_FULLTEXT_ANALYZER = "english";
    protected final String fulltextAnalyzer;
    protected boolean hierarchyCreated;
    protected boolean pathOptimizationsEnabled;

    public DialectPostgreSQL(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, repositoryDescriptor);
        this.fulltextAnalyzer = repositoryDescriptor.fulltextAnalyzer == null ? DEFAULT_FULLTEXT_ANALYZER : repositoryDescriptor.fulltextAnalyzer;
        this.pathOptimizationsEnabled = repositoryDescriptor.pathOptimizationsEnabled;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return bool ? "true" : "false";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "DEFAULT VALUES";
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return "CASCADE";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("varchar", 12);
            }
            case CLOB: {
                return this.jdbcInfo("text", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("bool", -7);
            }
            case LONG: {
                return this.jdbcInfo("int8", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("float8", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("timestamp", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("varchar(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("varchar(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("varchar(250)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("int2", 5);
            }
            case INTEGER: {
                return this.jdbcInfo("int4", 4);
            }
            case FTINDEXED: {
                return this.jdbcInfo("tsvector", 1111);
            }
            case FTSTORED: {
                return this.jdbcInfo("tsvector", 1111);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("int4", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("varchar[]", 2003);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            case 2003: {
                Array array = this.createArrayOf(12, (Object[])value, ps.getConnection());
                ps.setArray(index, array);
                return;
            }
            case 1111: {
                if (column.getType() == ColumnType.FTSTORED) {
                    ps.setString(index, (String)((Object)value));
                    return;
                }
                throw new SQLException("Unhandled type: " + (Object)((Object)column.getType()));
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return column.getModel().getBinary(string);
                }
                return string;
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
            case 2003: {
                return (Serializable)rs.getArray(index).getArray();
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        return String.format("CREATE INDEX %s ON %s USING GIN(%s)", quotedIndexName.toLowerCase(), table.getQuotedName(), columns.get(0).getQuotedName());
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        query = query.replace(" & ", " ");
        query = query.replaceAll(" +", " ");
        LinkedList<String> res = new LinkedList<String>();
        for (String word : StringUtils.split((String)query, (char)' ', (boolean)false)) {
            if (word.startsWith("-")) {
                res.add("!" + word.substring(1));
                continue;
            }
            if (word.startsWith("+")) {
                res.add(word.substring(1));
                continue;
            }
            res.add(word);
        }
        return StringUtils.join(res, (String)" & ");
    }

    @Override
    public String[] getFulltextMatch(String indexName, String fulltextQuery, Column mainColumn, Model model, Database database) {
        String suffix = model.getFulltextIndexSuffix(indexName);
        Column ftColumn = database.getTable("fulltext").getColumn("fulltext" + suffix);
        String whereExpr = String.format("NX_CONTAINS(%s, ?)", ftColumn.getFullQuotedName());
        return new String[]{null, null, whereExpr, fulltextQuery};
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 1;
    }

    @Override
    public String getFreeVariableSetterForType(ColumnType type) {
        if (type == ColumnType.FTSTORED) {
            return "NX_TO_TSVECTOR(?)";
        }
        return "?";
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return false;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getReadAclsCheckSql(String idColumnName) {
        return String.format("%s IN (SELECT * FROM nx_get_read_acls_for(?))", idColumnName);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "SELECT nx_update_read_acls();";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "SELECT nx_rebuild_read_acls();";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?)", idColumnName);
    }

    @Override
    public boolean supportsDescendantsTable() {
        return true;
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        if (this.pathOptimizationsEnabled) {
            return String.format("EXISTS(SELECT 1 FROM descendants WHERE id = ? AND descendantid = %s)", idColumnName);
        }
        return String.format("NX_IN_TREE(%s, ?)", idColumnName);
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    @Override
    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        String typeName;
        if (elements == null || elements.length == 0) {
            return null;
        }
        switch (type) {
            case 12: {
                typeName = "varchar";
                break;
            }
            default: {
                throw new RuntimeException("" + type);
            }
        }
        return new PostgreSQLArray(type, typeName, elements);
    }

    @Override
    public Collection<ConditionalStatement> getConditionalStatements(Model model, Database database) {
        String idType;
        switch (model.idGenPolicy) {
            case APP_UUID: {
                idType = "varchar(36)";
                break;
            }
            case DB_IDENTITY: {
                idType = "integer";
                break;
            }
            default: {
                throw new AssertionError((Object)model.idGenPolicy);
            }
        }
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, String.format("CREATE OR REPLACE FUNCTION NX_IN_TREE(id %s, baseid %<s) RETURNS boolean AS $$ DECLARE  curid %<s := id; BEGIN  IF baseid IS NULL OR id IS NULL OR baseid = id THEN    RETURN false;  END IF;  LOOP    SELECT parentid INTO curid FROM hierarchy WHERE hierarchy.id = curid;    IF curid IS NULL THEN      RETURN false;     ELSEIF curid = baseid THEN      RETURN true;    END IF;  END LOOP;END $$ LANGUAGE plpgsql STABLE COST 400 ", idType)));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, String.format("CREATE OR REPLACE FUNCTION NX_ACCESS_ALLOWED(id %s, users varchar[], permissions varchar[]) RETURNS boolean AS $$ DECLARE  curid %<s := id;  newid %<s;  r record;  first boolean := true;BEGIN  WHILE curid IS NOT NULL LOOP    FOR r in SELECT acls.grant, acls.permission, acls.user FROM acls WHERE acls.id = curid ORDER BY acls.pos LOOP      IF r.permission = ANY(permissions) AND r.user = ANY(users) THEN        RETURN r.grant;      END IF;    END LOOP;    SELECT parentid INTO newid FROM hierarchy WHERE hierarchy.id = curid;    IF first AND newid IS NULL THEN      SELECT versionableid INTO newid FROM versions WHERE versions.id = curid;    END IF;    first := false;    curid := newid;  END LOOP;  RETURN false; END $$ LANGUAGE plpgsql STABLE COST 500 ", idType)));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, String.format("CREATE OR REPLACE FUNCTION NX_CLUSTER_INVAL(i %s, f varchar[], k int) RETURNS VOID AS $$ DECLARE  nid int; BEGIN  FOR nid IN SELECT nodeid FROM cluster_nodes WHERE nodeid <> pg_backend_pid() LOOP  INSERT INTO cluster_invals (nodeid, id, fragments, kind) VALUES (nid, i, f, k);  END LOOP; END $$ LANGUAGE plpgsql", idType)));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION NX_CLUSTER_GET_INVALS() RETURNS SETOF RECORD AS $$ DECLARE  r RECORD; BEGIN  FOR r IN SELECT id, fragments, kind FROM cluster_invals WHERE nodeid = pg_backend_pid() LOOP    RETURN NEXT r;  END LOOP;  DELETE FROM cluster_invals WHERE nodeid = pg_backend_pid();  RETURN; END $$ LANGUAGE plpgsql"));
        if (!this.fulltextDisabled) {
            statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, String.format("CREATE OR REPLACE FUNCTION NX_TO_TSVECTOR(string VARCHAR) RETURNS TSVECTOR AS $$  SELECT TO_TSVECTOR('%s', SUBSTR($1, 1, 250000)) $$ LANGUAGE sql STABLE ", this.fulltextAnalyzer)));
            statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, String.format("CREATE OR REPLACE FUNCTION NX_CONTAINS(ft TSVECTOR, query VARCHAR) RETURNS boolean AS $$  SELECT $1 @@ TO_TSQUERY('%s', $2) $$ LANGUAGE sql STABLE ", this.fulltextAnalyzer)));
            Table ft = database.getTable("fulltext");
            Model.FulltextInfo fti = model.getFulltextInfo();
            ArrayList<String> lines = new ArrayList<String>(fti.indexNames.size());
            for (String indexName : fti.indexNames) {
                String suffix = model.getFulltextIndexSuffix(indexName);
                Column ftft = ft.getColumn("fulltext" + suffix);
                Column ftst = ft.getColumn("simpletext" + suffix);
                Column ftbt = ft.getColumn("binarytext" + suffix);
                String line = String.format("  NEW.%s := COALESCE(NEW.%s, ''::TSVECTOR) || COALESCE(NEW.%s, ''::TSVECTOR);", ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName());
                lines.add(line);
            }
            statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION NX_UPDATE_FULLTEXT() RETURNS trigger AS $$ BEGIN" + StringUtils.join(lines, (String)"") + "  RETURN NEW; " + "END " + "$$ " + "LANGUAGE plpgsql " + "VOLATILE "));
            statements.add(new ConditionalStatement(false, Boolean.TRUE, null, String.format("DROP TRIGGER IF EXISTS NX_TRIG_FT_UPDATE ON %s", ft.getQuotedName()), String.format("CREATE TRIGGER NX_TRIG_FT_UPDATE BEFORE INSERT OR UPDATE ON %s FOR EACH ROW EXECUTE PROCEDURE NX_UPDATE_FULLTEXT()", ft.getQuotedName())));
        }
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION NX_DESCENDANTS_CREATE_TRIGGERS() RETURNS void AS $$   DROP TRIGGER IF EXISTS NX_TRIG_DESC_INSERT ON hierarchy;  CREATE TRIGGER NX_TRIG_DESC_INSERT    AFTER INSERT ON hierarchy    FOR EACH ROW EXECUTE PROCEDURE NX_DESCENDANTS_INSERT();  DROP TRIGGER IF EXISTS NX_TRIG_DESC_UPDATE ON hierarchy;  CREATE TRIGGER NX_TRIG_DESC_UPDATE    AFTER UPDATE ON hierarchy    FOR EACH ROW EXECUTE PROCEDURE NX_DESCENDANTS_UPDATE(); $$ LANGUAGE sql VOLATILE "));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION NX_INIT_DESCENDANTS() RETURNS void AS $$ DECLARE  curid varchar(36);   curparentid varchar(36); BEGIN   CREATE TEMP TABLE nxtodo (id varchar(36), parentid varchar(36)) ON COMMIT DROP;   CREATE INDEX nxtodo_idx ON nxtodo (id);  INSERT INTO nxtodo SELECT id, NULL FROM repositories;  TRUNCATE TABLE descendants;  LOOP    -- get next node in queue\n    SELECT id, parentid INTO curid, curparentid FROM nxtodo LIMIT 1;    IF NOT FOUND THEN      EXIT;    END IF;    DELETE FROM nxtodo WHERE id = curid;    -- add children to queue\n    INSERT INTO nxtodo SELECT id, curid FROM hierarchy      WHERE parentid = curid and NOT isproperty;    IF curparentid IS NULL THEN      CONTINUE;    END IF;    -- process the node\n    INSERT INTO descendants (id, descendantid)      SELECT id, curid FROM descendants WHERE descendantid = curparentid;    INSERT INTO descendants (id, descendantid) VALUES (curparentid, curid);  END LOOP;  PERFORM NX_DESCENDANTS_CREATE_TRIGGERS(); END $$ LANGUAGE plpgsql VOLATILE "));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION NX_DESCENDANTS_INSERT() RETURNS trigger AS $$ BEGIN   IF NEW.isproperty THEN    RETURN NULL;   END IF;  IF NEW.parentid IS NULL THEN    RETURN NULL;   END IF;  IF NEW.id IS NULL THEN    RAISE EXCEPTION 'Cannot have NULL id';   END IF;  INSERT INTO descendants (id, descendantid)    SELECT id, NEW.id FROM descendants WHERE descendantid = NEW.parentid;  INSERT INTO descendants (id, descendantid) VALUES (NEW.parentid, NEW.id);  RETURN NULL; END $$ LANGUAGE plpgsql VOLATILE "));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION NX_DESCENDANTS_UPDATE() RETURNS trigger AS $$ BEGIN   IF NEW.isproperty THEN    RETURN NULL;   END IF;  IF OLD.id IS DISTINCT FROM NEW.id THEN    RAISE EXCEPTION 'Cannot change id';   END IF;  IF OLD.parentid IS NOT DISTINCT FROM NEW.parentid THEN    RETURN NULL;   END IF;  IF NEW.id IS NULL THEN    RAISE EXCEPTION 'Cannot have NULL id';   END IF;  IF OLD.parentid IS NOT NULL THEN    IF NEW.parentid IS NOT NULL THEN      IF NEW.parentid = NEW.id THEN        RAISE EXCEPTION 'Cannot move a node under itself';       END IF;      IF EXISTS(SELECT 1 FROM descendants WHERE id = NEW.id AND descendantid = NEW.parentid) THEN        RAISE EXCEPTION 'Cannot move a node under one of its descendants';       END IF;    END IF;    -- the old parent and its ancestors lose some descendants\n    DELETE FROM descendants      WHERE id IN (SELECT id FROM descendants WHERE descendantid = NEW.id)      AND descendantid IN (SELECT descendantid FROM descendants WHERE id = NEW.id                           UNION ALL SELECT NEW.id);  END IF;  IF NEW.parentid IS NOT NULL THEN    -- the new parent's ancestors gain as descendants\n    -- the descendants of the moved node (cross join)\n    INSERT INTO descendants (id, descendantid)      (SELECT A.id, B.descendantid FROM descendants A CROSS JOIN descendants B       WHERE A.descendantid = NEW.parentid AND B.id = NEW.id);    -- the new parent's ancestors gain as descendant the moved node\n    INSERT INTO descendants (id, descendantid)      SELECT id, NEW.id FROM descendants WHERE descendantid = NEW.parentid;    -- the new parent gains as descendants the descendants of the moved node\n    INSERT INTO descendants (id, descendantid)      SELECT NEW.parentid, descendantid FROM descendants WHERE id = NEW.id;    -- the new parent gains as descendant the moved node\n    INSERT INTO descendants (id, descendantid)      VALUES (NEW.parentid, NEW.id);  END IF;  RETURN NULL; END $$ LANGUAGE plpgsql VOLATILE "));
        statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM pg_tables WHERE tablename='read_acls');", "CREATE TABLE read_acls (  id character varying(34) PRIMARY KEY,  acl character varying(4096));", "SELECT 1;"));
        statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM pg_tables WHERE tablename='read_acls_cache');", "CREATE TABLE read_acls_cache (  users_md5 character varying(34) NOT NULL,  acl_id character varying(34));", "SELECT 1;"));
        statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM pg_indexes WHERE indexname='read_acls_cache_users_md5_idx');", "CREATE INDEX read_acls_cache_users_md5_idx ON read_acls_cache USING btree (users_md5);", "SELECT 1;"));
        statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM pg_tables WHERE tablename='hierarchy_read_acl');", "CREATE TABLE hierarchy_read_acl (  id character varying(36) PRIMARY KEY,  acl_id character varying(34),  CONSTRAINT hierarchy_read_acl_id_fk FOREIGN KEY (id) REFERENCES hierarchy(id) ON DELETE CASCADE);", "SELECT 1;"));
        statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM pg_indexes WHERE indexname='hierarchy_read_acl_acl_id_idx');", "CREATE INDEX hierarchy_read_acl_acl_id_idx ON hierarchy_read_acl USING btree (acl_id);", "SELECT 1;"));
        statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM pg_tables WHERE tablename='hierarchy_modified_acl');", "CREATE TABLE hierarchy_modified_acl (  id character varying(36),  is_new boolean);", "SELECT 1;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_get_local_read_acl(id character varying) RETURNS character varying AS $$\n -- Compute the read acl for a hierarchy id using a local acl\nDECLARE\n  curid varchar(36) := id;\n  read_acl varchar(4096) := NULL;\n  r record;\nBEGIN\n  -- RAISE DEBUG 'call %', curid;\n  FOR r in SELECT CASE\n         WHEN (acls.grant AND\n             acls.permission IN ('Read', 'ReadWrite', 'Everything', 'Browse')) THEN\n           acls.user\n         WHEN (NOT acls.grant AND\n             acls.permission IN ('Read', 'ReadWrite', 'Everything', 'Browse')) THEN\n           '-'|| acls.user\n         ELSE NULL END AS op\n       FROM acls WHERE acls.id = curid\n       ORDER BY acls.pos LOOP\n    IF r.op IS NULL THEN\n      CONTINUE;\n    END IF;\n    IF read_acl IS NULL THEN\n      read_acl := r.op;\n    ELSE\n      read_acl := read_acl || ',' || r.op;\n    END IF;\n  END LOOP;\n  RETURN read_acl;\nEND $$\nLANGUAGE plpgsql STABLE;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_get_read_acl(id character varying) RETURNS character varying AS $$\n -- Compute the read acl for a hierarchy id using inherited acl \nDECLARE\n  curid varchar(36) := id;\n  newid varchar(36);\n  first boolean := true;\n  read_acl varchar(4096);\n  ret varchar(4096);\nBEGIN\n  -- RAISE DEBUG 'call %', curid;\n  WHILE curid IS NOT NULL LOOP\n    -- RAISE DEBUG '  curid %', curid;\n    SELECT nx_get_local_read_acl(curid) INTO read_acl;\n    IF (read_acl IS NOT NULL) THEN\n      IF (ret is NULL) THEN\n        ret = read_acl;\n      ELSE\n        ret := ret || ',' || read_acl;\n      END IF;\n    END IF;\n    SELECT parentid INTO newid FROM hierarchy WHERE hierarchy.id = curid;\n    IF (first AND newid IS NULL) THEN\n      SELECT versionableid INTO newid FROM versions WHERE versions.id = curid;\n    END IF;\n    first := false;\n    curid := newid;\n  END LOOP;\n  IF (ret is NULL) THEN\n    ret = '_empty';\n  END IF;\n  RETURN ret;\nEND $$\nLANGUAGE plpgsql STABLE;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_get_read_acls_for(users character varying[]) RETURNS SETOF text AS $$\n-- List read acl ids for a list of user/groups using cache\nDECLARE\n  r record;\n  in_cache boolean := false;\n  md5_users varchar(34);\nBEGIN\n  SELECT md5(array_to_string(users, ',')) INTO md5_users;\n  SELECT true INTO in_cache WHERE EXISTS (SELECT 1 FROM read_acls_cache WHERE users_md5 = md5_users);\n  IF in_cache IS NULL THEN\n    INSERT INTO read_acls_cache SELECT md5_users, acl_id FROM nx_list_read_acls_for(users) AS acl_id;\n  END IF;\n  FOR r IN SELECT acl_id FROM read_acls_cache WHERE users_md5 = md5_users LOOP\n    RETURN NEXT r.acl_id;\n  END LOOP;\n  RETURN;\nEND $$\nLANGUAGE plpgsql VOLATILE;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_list_read_acls_for(users character varying[]) RETURNS SETOF text AS $$\n-- List read acl ids for a list of user/groups\nDECLARE\n  r record;\n  rr record;\n  users_blacklist character varying[];\nBEGIN\n  -- Build a black list with negative users\n  SELECT regexp_split_to_array('-' || array_to_string(users, ',-'), ',')\n    INTO users_blacklist;\n  <<acl_loop>>\n  FOR r IN SELECT read_acls.id, read_acls.acl FROM read_acls LOOP\n    -- RAISE DEBUG 'ACL %', r.id;\n    -- split the acl into aces\n    FOR rr IN SELECT ace FROM regexp_split_to_table(r.acl, ',') AS ace LOOP\n       -- RAISE DEBUG '  ACE %', rr.ace;\n       IF (rr.ace = ANY(users)) THEN\n         -- RAISE DEBUG '  GRANT %', users;\n         RETURN NEXT r.id;\n         CONTINUE acl_loop;\n         -- ok\n       ELSEIF (rr.ace = ANY(users_blacklist)) THEN\n         -- RAISE DEBUG '  DENY';\n         CONTINUE acl_loop;\n       END IF;\n    END LOOP;\n  END LOOP acl_loop;\n  RETURN;\nEND $$\nLANGUAGE plpgsql STABLE;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_log_acls_modified() RETURNS trigger  AS $$\n-- Trigger to log change in the acls table\nDECLARE\n  doc_id varchar(36);\nBEGIN\n  IF (TG_OP = 'DELETE') THEN\n    doc_id := OLD.id;\n  ELSE\n    doc_id := NEW.id;\n  END IF;\n  INSERT INTO hierarchy_modified_acl VALUES(doc_id, 'f');\n  RETURN NEW;\nEND $$\nLANGUAGE plpgsql;"));
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "DROP TRIGGER IF EXISTS nx_trig_acls_modified ON acls;", "CREATE TRIGGER nx_trig_acls_modified\n  AFTER INSERT OR UPDATE OR DELETE ON acls\n  FOR EACH ROW EXECUTE PROCEDURE nx_log_acls_modified();"));
        if (!this.aclOptimizationsEnabled) {
            statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "ALTER TABLE acls DISABLE TRIGGER nx_trig_acls_modified;"));
        }
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_log_hierarchy_modified() RETURNS trigger  AS $$\n-- Trigger to log doc_id that need read acl update\nDECLARE\n  doc_id varchar(36);\nBEGIN\n  IF (TG_OP = 'INSERT') THEN\n    IF (NEW.isproperty = 'f') THEN\n      -- New document\n      INSERT INTO hierarchy_modified_acl VALUES(NEW.id, 't');\n    END IF;\n  ELSEIF (TG_OP = 'UPDATE') THEN\n    IF (NEW.isproperty = 'f' AND NEW.parentid != OLD.parentid) THEN\n      -- New container\n      INSERT INTO hierarchy_modified_acl VALUES(NEW.id, 'f');\n    END IF;\n  END IF;\n  RETURN NEW;\nEND $$\nLANGUAGE plpgsql;"));
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "DROP TRIGGER IF EXISTS nx_trig_hierarchy_modified ON hierarchy;", "CREATE TRIGGER nx_trig_hierarchy_modified\n  AFTER INSERT OR UPDATE OR DELETE ON hierarchy\n  FOR EACH ROW EXECUTE PROCEDURE nx_log_hierarchy_modified();"));
        if (!this.aclOptimizationsEnabled) {
            statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "ALTER TABLE hierarchy DISABLE TRIGGER nx_trig_hierarchy_modified;"));
        }
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_rebuild_read_acls() RETURNS void AS $$\n-- Rebuild the read acls tables\nBEGIN\n  RAISE DEBUG 'nx_rebuild_read_acls truncating read_acls tables ...';\n  TRUNCATE TABLE read_acls;\n  TRUNCATE TABLE read_acls_cache;\n  TRUNCATE TABLE hierarchy_read_acl;\n  TRUNCATE TABLE hierarchy_modified_acl;\n  RAISE DEBUG 'nx_rebuild_read_acls rebuilding hierarchy_read_acl ...';\n  INSERT INTO hierarchy_read_acl\n    SELECT id, md5(nx_get_read_acl(id))\n    FROM (SELECT id FROM hierarchy WHERE NOT isproperty) AS uids;\n  RAISE INFO 'nx_rebuild_read_acls done.';\n  RETURN;\nEND $$\nLANGUAGE plpgsql VOLATILE;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_vacuum_read_acls() RETURNS void AS $$\n-- Remove unused read acls entries\nDECLARE\n  update_count integer;\nBEGIN\n  RAISE INFO 'nx_vacuum_read_acls vacuuming ...';\n  DELETE FROM read_acls WHERE id IN (SELECT r.id FROM read_acls AS r\n    LEFT JOIN hierarchy_read_acl AS h ON r.id=h.acl_id\n    WHERE h.acl_id IS NULL);\n  GET DIAGNOSTICS update_count = ROW_COUNT;\n  RAISE INFO 'nx_vacuum_read_acls done, % read acls removed.', update_count;\n  RETURN;\nEND $$\nLANGUAGE plpgsql VOLATILE;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_update_read_acls() RETURNS void AS $$\n-- Rebuild only necessary read acls\nDECLARE\n  update_count integer;\nBEGIN\n  -- New hierarchy_read_acl entry\n  RAISE DEBUG 'nx_update_read_acls inserting new hierarchy_read_acl ...';\n  INSERT INTO hierarchy_read_acl\n    SELECT id, md5(nx_get_read_acl(id))\n    FROM (SELECT DISTINCT(id) AS id\n        FROM hierarchy_modified_acl \n        WHERE is_new AND\n            EXISTS (SELECT 1 FROM hierarchy WHERE hierarchy_modified_acl.id=hierarchy.id)) AS uids;\n  GET DIAGNOSTICS update_count = ROW_COUNT;\n  RAISE DEBUG 'nx_update_read_acls % entries added.', update_count;\n  DELETE FROM hierarchy_modified_acl WHERE is_new;\n\n  -- Update hierarchy_read_acl entry\n  RAISE DEBUG 'nx_update_read_acls updating hierarchy_read_acl ...';\n  -- Mark acl that need to be updated (set to NULL)\n  UPDATE hierarchy_read_acl SET acl_id = NULL WHERE id IN (\n    SELECT DISTINCT(id) AS id FROM hierarchy_modified_acl WHERE NOT is_new);\n  GET DIAGNOSTICS update_count = ROW_COUNT;\n  RAISE DEBUG 'nx_update_read_acls mark % lines to update', update_count;\n  DELETE FROM hierarchy_modified_acl WHERE NOT is_new;\n  IF (update_count > 0) THEN\n    RAISE DEBUG 'nx_update_read_acls reset read_acls cache';\n    TRUNCATE TABLE read_acls_cache;\n  END IF;\n\n  -- Mark all childrens\n  LOOP\n    UPDATE hierarchy_read_acl SET acl_id = NULL WHERE id IN (\n      SELECT h.id\n      FROM hierarchy AS h\n      JOIN hierarchy_read_acl AS r ON h.id = r.id\n      WHERE r.acl_id IS NOT NULL\n        AND h.parentid IN (SELECT id FROM hierarchy_read_acl WHERE acl_id IS NULL));\n    GET DIAGNOSTICS update_count = ROW_COUNT;\n    RAISE DEBUG 'nx_update_read_acls mark % lines to udpate', update_count;\n    IF (update_count = 0) THEN\n      EXIT;\n    END IF;\n  END LOOP;\n  -- Update hierarchy_read_acl acl_ids\n  RAISE DEBUG 'nx_update_read_acls computing read acls ...';\n  UPDATE hierarchy_read_acl SET acl_id = md5(nx_get_read_acl(id)) WHERE acl_id IS NULL;\n  GET DIAGNOSTICS update_count = ROW_COUNT;\n  RAISE INFO 'nx_update_read_acls % updated.', update_count;\n\n  RETURN;\nEND $$\nLANGUAGE plpgsql VOLATILE;"));
        statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "CREATE OR REPLACE FUNCTION nx_log_hierarchy_read_acl_modified() RETURNS trigger AS $$\n-- Trigger to update the read_acls tables\nBEGIN\n  IF (NEW.acl_id IS NOT NULL) THEN\n    INSERT INTO read_acls\n      SELECT md5(acl), acl FROM (SELECT nx_get_read_acl(NEW.id) AS acl) AS input\n      WHERE NOT EXISTS (SELECT 1 FROM read_acls AS r WHERE r.id = NEW.acl_id);\n  END IF;\n  RETURN NEW;\nEND $$\nLANGUAGE plpgsql;"));
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "DROP TRIGGER IF EXISTS nx_trig_hierarchy_read_acl_modified ON hierarchy_read_acl;", "CREATE TRIGGER nx_trig_hierarchy_read_acl_modified\n  AFTER INSERT OR UPDATE ON hierarchy_read_acl\n  FOR EACH ROW EXECUTE PROCEDURE nx_log_hierarchy_read_acl_modified();"));
        if (this.aclOptimizationsEnabled) {
            log.info((Object)"ACL optimizations enable, building read acls if needed...");
            statements.add(new ConditionalStatement(false, null, "SELECT 1 WHERE NOT EXISTS(SELECT 1 FROM read_acls LIMIT 1);", "SELECT * FROM nx_rebuild_read_acls();", "SELECT 1;"));
            log.info((Object)"Vacuuming read acls table...");
            statements.add(new ConditionalStatement(false, Boolean.FALSE, null, null, "SELECT nx_vacuum_read_acls();"));
            log.info((Object)"ACL optimizations ready.");
        }
        return statements;
    }

    @Override
    public boolean preCreateTable(Connection connection, Table table, Model model, Database database) throws SQLException {
        if (table.getName().equals(model.hierTableName.toLowerCase())) {
            this.hierarchyCreated = true;
            return true;
        }
        if (table.getName().equals("descendants".toLowerCase())) {
            if (this.hierarchyCreated) {
                return true;
            }
            String sql = "SELECT COUNT(*) FROM hierarchy WHERE NOT isproperty";
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            rs.next();
            long count = rs.getLong(1);
            rs.close();
            s.close();
            if (count > 1000L) {
                this.pathOptimizationsEnabled = false;
                log.error((Object)"Table DESCENDANTS not initialized automatically because table HIERARCHY is too big. Upgrade by hand by calling: SELECT NX_INIT_DESCENDANTS()");
            }
            return true;
        }
        return true;
    }

    @Override
    public List<String> getPostCreateTableSqls(Table table, Model model, Database database) {
        if (table.getName().equals("descendants".toLowerCase())) {
            ArrayList<String> sqls = new ArrayList<String>();
            if (this.pathOptimizationsEnabled) {
                sqls.add("SELECT NX_INIT_DESCENDANTS()");
            } else {
                log.info((Object)"Path optimizations disabled");
            }
            return sqls;
        }
        return Collections.emptyList();
    }

    @Override
    public void existingTableDetected(Connection connection, Table table, Model model, Database database) throws SQLException {
        if (table.getName().equals("descendants".toLowerCase())) {
            if (!this.pathOptimizationsEnabled) {
                log.info((Object)"Path optimizations disabled");
                return;
            }
            String sql = "SELECT id FROM descendants LIMIT 1";
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(sql);
            boolean empty = !rs.next();
            rs.close();
            s.close();
            if (empty) {
                this.pathOptimizationsEnabled = false;
                log.error((Object)"Table DESCENDANTS empty, must be upgraded by hand by calling: SELECT NX_INIT_DESCENDANTS()");
                log.info((Object)"Path optimizations disabled");
            }
        }
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public String getCleanupClusterNodesSql(Model model, Database database) {
        Table cln = database.getTable("cluster_nodes");
        Column clnid = cln.getColumn("nodeid");
        return String.format("DELETE FROM %s N WHERE NOT EXISTS(SELECT * FROM pg_stat_activity S WHERE N.%s = S.procpid) ", cln.getQuotedName(), clnid.getQuotedName());
    }

    @Override
    public String getCreateClusterNodeSql(Model model, Database database) {
        Table cln = database.getTable("cluster_nodes");
        Column clnid = cln.getColumn("nodeid");
        Column clncr = cln.getColumn("created");
        return String.format("INSERT INTO %s (%s, %s) VALUES (pg_backend_pid(), CURRENT_TIMESTAMP)", cln.getQuotedName(), clnid.getQuotedName(), clncr.getQuotedName());
    }

    @Override
    public String getRemoveClusterNodeSql(Model model, Database database) {
        Table cln = database.getTable("cluster_nodes");
        Column clnid = cln.getColumn("nodeid");
        return String.format("DELETE FROM %s WHERE %s = pg_backend_pid()", cln.getQuotedName(), clnid.getQuotedName());
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "SELECT NX_CLUSTER_INVAL(?, ?, ?)";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT * FROM NX_CLUSTER_GET_INVALS() AS invals(id varchar(36), fragments varchar[], kind int2)";
    }

    @Override
    public Collection<ConditionalStatement> getTestConditionalStatements(Model model, Database database) {
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE TABLE testschema2 (id varchar(36) NOT NULL, title text)"));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "ALTER TABLE testschema2 ADD CONSTRAINT testschema2_pk PRIMARY KEY (id)"));
        return statements;
    }

    @Override
    public boolean connectionClosedByException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SocketException) {
            return true;
        }
        String message = t.getMessage();
        return message != null && message.contains("FATAL:");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostgreSQLArray
    implements Array {
        private static final String NOT_SUPPORTED = "Not supported";
        protected final int type;
        protected final String typeName;
        protected final Object[] elements;
        protected final String string;

        public PostgreSQLArray(int type, String typeName, Object[] elements) {
            this.type = type;
            if (type == 12) {
                typeName = "varchar";
            }
            this.typeName = typeName;
            this.elements = elements;
            StringBuilder b = new StringBuilder();
            PostgreSQLArray.appendArray(b, elements);
            this.string = b.toString();
        }

        protected static void appendArray(StringBuilder b, Object[] elements) {
            b.append('{');
            for (int i = 0; i < elements.length; ++i) {
                Object e = elements[i];
                if (i > 0) {
                    b.append(',');
                }
                if (e == null) {
                    b.append("NULL");
                    continue;
                }
                if (e.getClass().isArray()) {
                    PostgreSQLArray.appendArray(b, (Object[])e);
                    continue;
                }
                String s = e.toString();
                b.append('\"');
                for (int j = 0; j < s.length(); ++j) {
                    char c = s.charAt(j);
                    if (c == '\"' || c == '\\') {
                        b.append('\\');
                    }
                    b.append(c);
                }
                b.append('\"');
            }
            b.append('}');
        }

        public String toString() {
            return this.string;
        }

        @Override
        public int getBaseType() {
            return this.type;
        }

        @Override
        public String getBaseTypeName() {
            return this.typeName;
        }

        @Override
        public Object getArray() {
            return this.elements;
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public Object getArray(long index, int count) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet(long index, int count) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw new SQLException(NOT_SUPPORTED);
        }

        @Override
        public void free() {
        }
    }
}

