/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.db.dialect;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.db.Column;
import org.nuxeo.ecm.core.storage.sql.db.ColumnType;
import org.nuxeo.ecm.core.storage.sql.db.Database;
import org.nuxeo.ecm.core.storage.sql.db.Table;
import org.nuxeo.ecm.core.storage.sql.db.dialect.ConditionalStatement;
import org.nuxeo.ecm.core.storage.sql.db.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectSQLServer
extends Dialect {
    private static final String DEFAULT_FULLTEXT_ANALYZER = "english";
    private static final String DEFAULT_FULLTEXT_CATALOG = "nuxeo";
    protected final String fulltextAnalyzer;
    protected final String fulltextCatalog;

    public DialectSQLServer(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, repositoryDescriptor);
        this.fulltextAnalyzer = repositoryDescriptor.fulltextAnalyzer == null ? DEFAULT_FULLTEXT_ANALYZER : repositoryDescriptor.fulltextAnalyzer;
        this.fulltextCatalog = repositoryDescriptor.fulltextCatalog == null ? DEFAULT_FULLTEXT_CATALOG : repositoryDescriptor.fulltextCatalog;
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getNoColumnsInsertString() {
        return "DEFAULT VALUES";
    }

    @Override
    public String getNullColumnString() {
        return " NULL";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("NVARCHAR(4000)", 12);
            }
            case CLOB: {
                return this.jdbcInfo("NVARCHAR(MAX)", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("BIT", -7);
            }
            case LONG: {
                return this.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("DATETIME", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR(36)", 12);
            }
            case SYSNAME: {
                return this.jdbcInfo("VARCHAR(256)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("INT", 4);
            }
            case FTINDEXED: {
                throw new AssertionError((Object)type);
            }
            case FTSTORED: {
                return this.jdbcInfo("NVARCHAR(MAX)", 2005);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("INT", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("VARCHAR(8000)", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == 2005) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        return expected == 4 && actual == -5;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String v = column.getType() == ColumnType.BLOBID ? ((Binary)value).getDigest() : (String)((Object)value);
                ps.setString(index, v);
                break;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                Calendar cal = (Calendar)value;
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ps.setTimestamp(index, ts, cal);
                return;
            }
            default: {
                throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
            }
        }
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                String string = rs.getString(index);
                if (column.getType() == ColumnType.BLOBID && string != null) {
                    return column.getModel().getBinary(string);
                }
                return string;
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                Timestamp ts = rs.getTimestamp(index);
                if (ts == null) {
                    return null;
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).setTimeInMillis(ts.getTime());
                return cal;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("CREATE FULLTEXT INDEX ON %s (", table.getQuotedName()));
        Iterator<Column> it = columns.iterator();
        while (it.hasNext()) {
            buf.append(String.format("%s LANGUAGE %s", it.next().getQuotedName(), this.getQuotedFulltextAnalyzer()));
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        String fulltextUniqueIndex = "[fulltext_pk]";
        buf.append(String.format(") KEY INDEX %s ON [%s]", fulltextUniqueIndex, this.fulltextCatalog));
        return buf.toString();
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        query = query.replaceAll(" +", " ");
        LinkedList<String> pos = new LinkedList<String>();
        LinkedList<String> neg = new LinkedList<String>();
        for (String word : StringUtils.split((String)query, (char)' ', (boolean)false)) {
            if (word.startsWith("-")) {
                neg.add(word.substring(1));
                continue;
            }
            if (word.startsWith("+")) {
                pos.add(word.substring(1));
                continue;
            }
            pos.add(word);
        }
        if (pos.isEmpty()) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        String res = StringUtils.join(pos, (String)" & ");
        if (!neg.isEmpty()) {
            res = res + " &! " + StringUtils.join(neg, (String)" &! ");
        }
        return res;
    }

    @Override
    public String[] getFulltextMatch(String name, String fulltextQuery, Column mainColumn, Model model, Database database) {
        String whereExpr = String.format("CONTAINS([fulltext].*, ?, LANGUAGE %s)", this.getQuotedFulltextAnalyzer());
        return new String[]{null, null, whereExpr, fulltextQuery};
    }

    protected String getQuotedFulltextAnalyzer() {
        if (!Character.isDigit(this.fulltextAnalyzer.charAt(0))) {
            return String.format("'%s'", this.fulltextAnalyzer);
        }
        return this.fulltextAnalyzer;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("dbo.NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("dbo.NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public Collection<ConditionalStatement> getConditionalStatements(Model model, Database database) {
        String idType;
        switch (model.idGenPolicy) {
            case APP_UUID: {
                idType = "NVARCHAR(36)";
                break;
            }
            case DB_IDENTITY: {
                idType = "INTEGER";
                break;
            }
            default: {
                throw new AssertionError((Object)model.idGenPolicy);
            }
        }
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "IF OBJECT_ID('dbo.nxTrigCascadeDelete', 'TR') IS NOT NULL DROP TRIGGER dbo.nxTrigCascadeDelete", "CREATE TRIGGER nxTrigCascadeDelete ON [hierarchy] INSTEAD OF DELETE AS BEGIN  SET NOCOUNT ON;  WITH subtree(id, parentid) AS (    SELECT id, parentid    FROM deleted  UNION ALL    SELECT h.id, h.parentid    FROM [hierarchy] h    JOIN subtree ON subtree.id = h.parentid  )  DELETE FROM [hierarchy]    FROM [hierarchy] h    JOIN subtree    ON subtree.id = h.id; END"));
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "IF OBJECT_ID('dbo.NX_ACCESS_ALLOWED', 'FN') IS NOT NULL DROP FUNCTION dbo.NX_ACCESS_ALLOWED", String.format("CREATE FUNCTION NX_ACCESS_ALLOWED(@id %s, @users NVARCHAR(4000), @perms NVARCHAR(4000)) RETURNS TINYINT AS BEGIN  DECLARE @allusers NVARCHAR(4000);  DECLARE @allperms NVARCHAR(4000);  DECLARE @first TINYINT;  DECLARE @curid %<s;  DECLARE @newid %<s;  DECLARE @gr TINYINT;  DECLARE @pe VARCHAR(1000);  DECLARE @us VARCHAR(1000);  SET @allusers = N'|' + @users + N'|';  SET @allperms = N'|' + @perms + N'|';  SET @first = 1;  SET @curid = @id;  WHILE @curid IS NOT NULL BEGIN    DECLARE @cur CURSOR;    SET @cur = CURSOR FAST_FORWARD FOR      SELECT [grant], [permission], [user] FROM [acls]      WHERE [id] = @curid ORDER BY [pos];    OPEN @cur;    FETCH FROM @cur INTO @gr, @pe, @us;    WHILE @@FETCH_STATUS = 0 BEGIN      IF @allusers LIKE (N'%%|' + @us + N'|%%')        AND @allperms LIKE (N'%%|' + @pe + N'|%%')      BEGIN        CLOSE @cur;        RETURN @gr;      END;      FETCH FROM @cur INTO @gr, @pe, @us;    END;    CLOSE @cur;    SET @newid = (SELECT [parentid] FROM [hierarchy] WHERE [id] = @curid);    IF @first = 1 AND @newid IS NULL BEGIN      SET @newid = (SELECT [versionableid] FROM [versions] WHERE [id] = @curid);    END;    SET @first = 0;    SET @curid = @newid;  END;  RETURN 0; END", idType)));
        statements.add(new ConditionalStatement(false, Boolean.TRUE, null, "IF OBJECT_ID('dbo.NX_IN_TREE', 'FN') IS NOT NULL DROP FUNCTION dbo.NX_IN_TREE", String.format("CREATE FUNCTION NX_IN_TREE(@id %s, @baseid %<s) RETURNS TINYINT AS BEGIN  DECLARE @curid %<s;  IF @baseid IS NULL OR @id IS NULL OR @baseid = @id RETURN 0;  SET @curid = @id;  WHILE @curid IS NOT NULL BEGIN    SET @curid = (SELECT [parentid] FROM [hierarchy] WHERE [id] = @curid);    IF @curid = @baseid RETURN 1;  END;  RETURN 0;END", idType)));
        if (!this.fulltextDisabled) {
            statements.add(new ConditionalStatement(true, null, String.format("IF EXISTS(SELECT name FROM sys.fulltext_catalogs WHERE name = '%s') SELECT * FROM sys.tables WHERE 1 = 0 ELSE SELECT 1", this.fulltextCatalog), String.format("CREATE FULLTEXT CATALOG [%s]", this.fulltextCatalog), "SELECT 1"));
        }
        return statements;
    }

    @Override
    public Collection<ConditionalStatement> getTestConditionalStatements(Model model, Database database) {
        LinkedList<ConditionalStatement> statements = new LinkedList<ConditionalStatement>();
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "CREATE TABLE TESTSCHEMA2 (ID VARCHAR(36) NOT NULL, TITLE NVARCHAR(MAX) NULL)"));
        statements.add(new ConditionalStatement(true, Boolean.FALSE, null, null, "ALTER TABLE TESTSCHEMA2 ADD CONSTRAINT TESTSCHEMA2_PK PRIMARY KEY (ID)"));
        return statements;
    }
}

