/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.management;

import java.util.LinkedList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.management.RepositoryStatusMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryStatus
implements RepositoryStatusMBean {
    private static final Log log = LogFactory.getLog(RepositoryStatus.class);

    protected List<RepositoryManagement> getRepositories() throws NamingException {
        LinkedList<RepositoryManagement> list = new LinkedList<RepositoryManagement>();
        InitialContext context = new InitialContext();
        for (String prefix : new String[]{"java:NXRepository", "NXRepository"}) {
            NamingEnumeration<Binding> bindings;
            try {
                bindings = context.listBindings(prefix);
            }
            catch (NamingException e) {
                continue;
            }
            NamingEnumeration<Binding> e = bindings;
            while (e.hasMore()) {
                Object object;
                Binding binding = (Binding)e.nextElement();
                String name = binding.getName();
                if (binding.isRelative()) {
                    name = prefix + '/' + name;
                }
                if (!((object = context.lookup(name)) instanceof RepositoryManagement)) continue;
                list.add((RepositoryManagement)object);
            }
        }
        return list;
    }

    @Override
    public String listActiveSessions() {
        List<RepositoryManagement> repositories;
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            log.error((Object)"Error getting repositories", (Throwable)e);
            return "Error!";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Actives sessions for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.getActiveSessionsCount());
            buf.append("<br />");
        }
        return buf.toString();
    }

    @Override
    public int getActiveSessionsCount() {
        List<RepositoryManagement> repositories;
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            throw new IllegalStateException("Cannot get repositories", e);
        }
        int count = 0;
        for (RepositoryManagement repository : repositories) {
            count += repository.getActiveSessionsCount();
        }
        return count;
    }

    @Override
    public String clearCaches() {
        List<RepositoryManagement> repositories;
        try {
            repositories = this.getRepositories();
        }
        catch (NamingException e) {
            log.error((Object)"Error getting repositories", (Throwable)e);
            return "Error!";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Cleared cached objects for SQL repositories:<br />");
        for (RepositoryManagement repository : repositories) {
            buf.append("<b>").append(repository.getName()).append("</b>: ");
            buf.append(repository.clearCaches());
            buf.append("<br />");
        }
        return buf.toString();
    }
}

