/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.tag.TagServiceImpl;
import org.nuxeo.ecm.platform.tag.TagServiceLocal;
import org.nuxeo.ecm.platform.tag.TagServiceRemote;
import org.nuxeo.ecm.platform.tag.WeightedTag;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={TagServiceLocal.class})
@Remote(value={TagServiceRemote.class})
public class TagServiceBean
implements TagService {
    private static final Log log = LogFactory.getLog(TagServiceBean.class);
    protected TagService tagService;
    @PersistenceContext(unitName="nxtags")
    protected EntityManager em;

    protected TagServiceImpl getLocalTagService() throws ClientException {
        if (this.tagService == null) {
            try {
                this.tagService = (TagService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.tag.TagService");
            }
            catch (Exception e) {
                log.error((Object)"Problems retrieveing the TagService ... ", (Throwable)e);
            }
        }
        if (null == this.tagService) {
            throw new ClientException("Tag Service not available");
        }
        return (TagServiceImpl)this.tagService;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public DocumentModel getRootTag(CoreSession session) throws ClientException {
        return this.getLocalTagService().getRootTag(this.em, session);
    }

    public DocumentModelList listTagsInGroup(CoreSession session, DocumentModel tag) throws ClientException {
        return this.getLocalTagService().listTagsInGroup(this.em, session, tag);
    }

    public void untagDocument(CoreSession session, DocumentModel document, String tagId) throws ClientException {
        this.getLocalTagService().untagDocument(this.em, session, document, tagId);
    }

    public List<String> listDocumentsForTag(CoreSession session, String tagId, String user) throws ClientException {
        return this.getLocalTagService().listDocumentsForTag(this.em, session, tagId, user);
    }

    public String getTaggingId(CoreSession session, String docId, String tagLabel, String author) throws ClientException {
        return this.getLocalTagService().getTaggingId(this.em, session, docId, tagLabel, author);
    }

    public void completeUntagDocument(CoreSession session, DocumentModel document, String tagId) throws ClientException {
        this.getLocalTagService().completeUntagDocument(this.em, session, document, tagId);
    }

    public List<WeightedTag> getPopularCloud(CoreSession session, DocumentModel document) throws ClientException {
        return this.getLocalTagService().getPopularCloud(this.em, session, document);
    }

    public List<WeightedTag> getPopularCloudOnAllDocuments(CoreSession session) throws ClientException {
        return this.getLocalTagService().getPopularCloudOnAllDocuments(this.em, session);
    }

    public WeightedTag getPopularTag(CoreSession session, DocumentModel document, String tagId) throws ClientException {
        return this.getLocalTagService().getPopularTag(this.em, session, document, tagId);
    }

    public List<WeightedTag> getVoteCloud(CoreSession session, DocumentModel document) throws ClientException {
        return this.getLocalTagService().getVoteCloud(this.em, session, document);
    }

    public WeightedTag getVoteTag(CoreSession session, DocumentModel document, String tagId) throws ClientException {
        return this.getLocalTagService().getVoteTag(this.em, session, document, tagId);
    }

    public List<Tag> listTagsAppliedOnDocument(CoreSession session, DocumentModel document) throws ClientException {
        return this.getLocalTagService().listTagsAppliedOnDocument(this.em, session, document);
    }

    public List<Tag> listTagsAppliedOnDocumentByUser(CoreSession session, DocumentModel document) throws ClientException {
        return this.getLocalTagService().listTagsAppliedOnDocumentByUser(this.em, session, document);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void tagDocument(CoreSession session, DocumentModel document, String tagId, boolean privateFlag) throws ClientException {
        this.getLocalTagService().tagDocument(this.em, session, document, tagId, privateFlag);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public DocumentModel getOrCreateTag(CoreSession session, DocumentModel parent, String label, boolean privateFlag) throws ClientException {
        return this.getLocalTagService().getOrCreateTag(this.em, session, parent, label, privateFlag);
    }

    public boolean isEnabled() throws ClientException {
        return this.getLocalTagService().isEnabled();
    }
}

