/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTranslationMapImpl
implements DocumentTranslationMap {
    private final String oldServerName;
    private final String newServerName;
    private Map<DocumentRef, DocumentRef> map;

    public DocumentTranslationMapImpl(String oldServerName, String newServerName) {
        this.oldServerName = oldServerName;
        this.newServerName = newServerName;
    }

    public DocumentTranslationMapImpl(String oldServerName, String newServerName, Map<DocumentRef, DocumentRef> map) {
        this.oldServerName = oldServerName;
        this.newServerName = newServerName;
        this.map = map;
    }

    @Override
    public Map<DocumentRef, DocumentRef> getDocRefMap() {
        if (this.map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public String getNewServerName() {
        return this.newServerName;
    }

    @Override
    public String getOldServerName() {
        return this.oldServerName;
    }

    @Override
    public void put(DocumentRef oldRef, DocumentRef newRef) {
        if (this.map == null) {
            this.map = new HashMap<DocumentRef, DocumentRef>();
        }
        this.map.put(oldRef, newRef);
    }

    @Override
    public void putAll(Map<DocumentRef, DocumentRef> refs) {
        if (refs == null) {
            return;
        }
        if (this.map == null) {
            this.map = new HashMap<DocumentRef, DocumentRef>();
        }
        this.map.putAll(refs);
    }

    public static DocumentTranslationMap merge(List<DocumentTranslationMap> maps) {
        if (maps == null || maps.isEmpty()) {
            return null;
        }
        DocumentTranslationMap ref = maps.get(0);
        String oldRepo = ref.getOldServerName();
        String newRepo = ref.getNewServerName();
        DocumentTranslationMapImpl finalMap = new DocumentTranslationMapImpl(oldRepo, newRepo);
        for (DocumentTranslationMap item : maps) {
            finalMap.putAll(item.getDocRefMap());
        }
        return finalMap;
    }
}

