/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;

public class DocumentModelInjector
extends AbstractDocumentModelWriter {
    public DocumentModelInjector(CoreSession session, String parentPath) {
        super(session, parentPath);
    }

    public DocumentModelInjector(CoreSession session, String parentPath, int saveInterval) {
        super(session, parentPath, saveInterval);
    }

    public DocumentTranslationMap write(ExportedDocument xdoc) throws IOException {
        Path path = xdoc.getPath();
        if (path.isEmpty() || path.isRoot()) {
            return null;
        }
        path = this.root.append(path);
        try {
            DocumentModel doc = this.createDocument(xdoc, path);
            DocumentLocation source = xdoc.getSourceLocation();
            DocumentTranslationMapImpl map = new DocumentTranslationMapImpl(source.getServerName(), doc.getRepositoryName());
            map.put(source.getDocRef(), doc.getRef());
            return map;
        }
        catch (ClientException e) {
            IOException ioe = new IOException("Failed to import document in repository: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            e.printStackTrace();
            return null;
        }
    }
}

