/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRegistry
implements Serializable {
    private static final Log log = LogFactory.getLog(ActionRegistry.class);
    private static final long serialVersionUID = 8425627293154848041L;
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final Map<String, List<Action>> categories = new HashMap<String, List<Action>>();

    public synchronized void addAction(Action action) {
        String id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering action: " + action));
        }
        if (this.actions.containsKey(id = action.getId())) {
            return;
        }
        this.actions.put(id, action);
        for (String category : action.getCategories()) {
            List<Action> acts = this.categories.get(category);
            if (acts == null) {
                acts = new ArrayList<Action>();
                this.categories.put(category, acts);
            }
            acts.add(action);
        }
    }

    public synchronized Action removeAction(String id) {
        Action action;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering action: " + id));
        }
        if ((action = this.actions.remove(id)) != null) {
            for (String category : action.getCategories()) {
                List<Action> acts = this.categories.get(category);
                if (acts == null) continue;
                acts.remove(action);
            }
        }
        return action;
    }

    public synchronized Collection<Action> getActions() {
        return Collections.unmodifiableCollection(ActionRegistry.sortActions(this.actions.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> getActions(String category) {
        Collection<Action> actions;
        LinkedList<Action> result = new LinkedList<Action>();
        ActionRegistry actionRegistry = this;
        synchronized (actionRegistry) {
            actions = (Collection<Action>)this.categories.get(category);
        }
        actions = ActionRegistry.sortActions(actions);
        if (actions != null) {
            for (Action action : actions) {
                if (!action.isEnabled()) continue;
                result.add(action);
            }
        }
        return result;
    }

    public synchronized Action getAction(String id) {
        return this.actions.get(id);
    }

    private static Collection<Action> sortActions(Collection<Action> actions) {
        List<Object> sortedActions;
        if (actions == null) {
            sortedActions = new ArrayList<Action>();
        } else {
            Object[] sortedActionsArray = actions.toArray(new Action[actions.size()]);
            Arrays.sort(sortedActionsArray);
            sortedActions = Arrays.asList(sortedActionsArray);
        }
        return sortedActions;
    }
}

