/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.restAPI;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.syndication.restAPI.BaseQueryModelRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.Request;
import org.restlet.data.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashBoardRestlet
extends BaseQueryModelRestlet {
    private static final Log log = LogFactory.getLog(DashBoardRestlet.class);
    public static final int RELEVANT_NUMBER = 20;

    @Override
    protected String getQueryModelName(Request req) {
        String qmName = (String)req.getAttributes().get("QMName");
        return qmName.toUpperCase();
    }

    @Override
    protected CoreSession getCoreSession(Request req, Response res, String repoName) {
        repoName = req.getResourceRef().getQueryAsForm().getFirstValue("repo");
        return super.getCoreSession(req, res, repoName);
    }

    @Override
    protected String getDefaultFormat() {
        return "ATOM";
    }

    protected String getDomainPath(Request req) {
        String domain = req.getResourceRef().getQueryAsForm().getFirstValue("domain");
        if (domain == null) {
            domain = "/default-domain/";
        } else if (domain.equals("*")) {
            domain = "/";
        } else {
            if (!domain.startsWith("/")) {
                domain = "/" + domain;
            }
            if (!domain.endsWith("/")) {
                domain = domain + "/";
            }
        }
        return domain;
    }

    protected List<String> getRelevantDocuments(Request req) {
        AuditReader auditReader;
        try {
            auditReader = (AuditReader)Framework.getService(AuditReader.class);
        }
        catch (Exception e) {
            log.error((Object)"Cannot get AuditReader", (Throwable)e);
            return Collections.emptyList();
        }
        if (auditReader == null) {
            log.error((Object)"Cannot get AuditReader");
            return Collections.emptyList();
        }
        String username = DashBoardRestlet.getUserPrincipal((Request)req).getName();
        String query = String.format("from LogEntry log WHERE log.principalName = '%s'   AND log.eventId IN     ('%s', '%s')   AND log.docLifeCycle IS NOT NULL   AND log.docLifeCycle <> 'undefined' ORDER BY log.eventDate DESC", username, "documentCreated", "documentModified");
        List logEntries = auditReader.nativeQuery(query, 1, 20);
        ArrayList<String> ids = new ArrayList<String>(logEntries.size());
        for (Object logEntry : logEntries) {
            ids.add(((LogEntry)logEntry).getDocUUID());
        }
        if (ids.isEmpty()) {
            ids.add("00000000-0000-0000-0000-000000000000");
        }
        return ids;
    }

    @Override
    protected List<Object> extractQueryParameters(Request req) {
        List<Object> queryParams = super.extractQueryParameters(req);
        String qmName = this.getQueryModelName(req);
        if ("USER_DOCUMENTS".equals(qmName)) {
            queryParams.add(0, DashBoardRestlet.getUserPrincipal((Request)req).getName());
            queryParams.add(1, this.getDomainPath(req));
        } else if (!"USER_DOMAINS".equals(qmName)) {
            if ("USER_DELETED_DOCUMENTS".equals(qmName)) {
                queryParams.add(0, DashBoardRestlet.getUserPrincipal((Request)req).getName());
            } else if ("USER_WORKSPACES".equals(qmName)) {
                queryParams.add(0, this.getDomainPath(req));
                queryParams.add(1, this.getDomainPath(req) + "templates");
            } else if ("USER_SITES".equals(qmName)) {
                queryParams.add(0, this.getDomainPath(req));
                queryParams.add(1, this.getDomainPath(req) + "templates");
            } else if ("DOMAIN_PUBLISHED_DOCUMENTS".equals(qmName)) {
                queryParams.add(0, this.getDomainPath(req));
            } else if ("DOMAIN_DOCUMENTS".equals(qmName)) {
                queryParams.add(0, this.getDomainPath(req));
                queryParams.add(1, this.getDomainPath(req) + "templates");
            } else if ("USER_SECTIONS".equals(qmName)) {
                queryParams.add(0, this.getDomainPath(req));
            } else if ("RELEVANT_DOCUMENTS".equals(qmName)) {
                queryParams.add(0, this.getRelevantDocuments(req));
            }
        }
        return queryParams;
    }
}

