/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.serializer;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.syndication.serializer.AbstractDocumentModelSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.DashBoardItemSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.ResultField;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.syndication.translate.TranslationHelper;
import org.nuxeo.ecm.platform.syndication.workflow.DashBoardItem;
import org.restlet.data.MediaType;
import org.restlet.data.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMJSONSerializer
extends AbstractDocumentModelSerializer
implements DashBoardItemSerializer {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) throws ClientException {
        return this.serialize(summary, docList, columnsDefinition, req, null, null);
    }

    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req, List<String> labels, String lang) throws ClientException {
        if (docList == null) {
            return "empty result";
        }
        HashMap<String, Object> all = new HashMap<String, Object>();
        all.put("summary", summary);
        ArrayList struct = new ArrayList();
        for (DocumentModel doc : docList) {
            HashMap<String, String> resDoc = new HashMap<String, String>();
            resDoc.put("id", doc.getId());
            for (String colDef : columnsDefinition) {
                ResultField res = this.getDocumentProperty(doc, colDef);
                resDoc.put(res.getName(), res.getValue());
            }
            struct.add(resDoc);
        }
        all.put("data", struct);
        if (lang != null && labels != null) {
            HashMap<String, String> translations = new HashMap<String, String>();
            for (String key : labels) {
                translations.put(key, TranslationHelper.getLabel(key, lang));
            }
            all.put("translations", translations);
        }
        return DMJSONSerializer.makeJSON(all);
    }

    protected static String makeJSON(Map<String, Object> all) {
        JSON jsonRes = JSONSerializer.toJSON(all);
        if (jsonRes instanceof JSONObject) {
            JSONObject jsonOb = (JSONObject)jsonRes;
            return jsonOb.toString(2);
        }
        if (jsonRes instanceof JSONArray) {
            JSONArray jsonOb = (JSONArray)jsonRes;
            return jsonOb.toString(2);
        }
        return null;
    }

    @Override
    public void serialize(ResultSummary summary, DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req) throws ClientException {
        String json = this.serialize(summary, docList, columnsDefinition, req);
        res.setEntity(json, MediaType.TEXT_PLAIN);
    }

    @Override
    public void serialize(ResultSummary summary, DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req, List<String> labels, String lang) throws ClientException {
        List<String> cols = new ArrayList<String>();
        if (columnsDefinition != null) {
            cols = Arrays.asList(columnsDefinition.split(","));
        }
        String json = this.serialize(summary, docList, cols, req, labels, lang);
        res.setEntity(json, MediaType.TEXT_PLAIN);
    }

    protected String serialize(ResultSummary summary, List<DashBoardItem> workItems, String columnsDefinition, List<String> labels, String lang) throws ClientException {
        if (workItems == null) {
            workItems = Collections.emptyList();
        }
        HashMap data = new HashMap();
        for (DashBoardItem item : workItems) {
            String currentLifeCycle;
            ArrayList<HashMap<String, String>> category;
            String cat = item.getDirective();
            if (cat == null) {
                cat = "None";
            }
            if ((category = (ArrayList<HashMap<String, String>>)data.get(cat)) == null) {
                category = new ArrayList<HashMap<String, String>>();
                data.put(cat, category);
            }
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", item.getId().toString());
            m.put("name", item.getName());
            if (lang != null && item.getName() != null) {
                m.put("nameI18n", TranslationHelper.getLabel("label.workflow.task." + item.getName(), lang));
            }
            m.put("directive", item.getDirective());
            if (lang != null && item.getDirective() != null) {
                m.put("directiveI18n", TranslationHelper.getLabel(item.getDirective(), lang));
            }
            m.put("description", item.getDescription());
            m.put("title", item.getDocument().getTitle());
            m.put("link", item.getDocumentLink());
            try {
                currentLifeCycle = item.getDocument().getCurrentLifeCycleState();
            }
            catch (ClientException e) {
                currentLifeCycle = "";
            }
            m.put("currentDocumentLifeCycle", currentLifeCycle);
            if (item.getDueDate() != null) {
                m.put("dueDate", DATE_FORMAT.format(item.getDueDate()));
            }
            if (item.getStartDate() != null) {
                m.put("startDate", DATE_FORMAT.format(item.getStartDate()));
            }
            if (item.getComment() != null) {
                m.put("comment", item.getComment());
            }
            category.add(m);
        }
        HashMap<String, Object> all = new HashMap<String, Object>();
        all.put("data", data);
        all.put("summary", summary);
        if (lang != null && labels != null) {
            HashMap<String, String> translations = new HashMap<String, String>();
            for (String key : labels) {
                translations.put(key, TranslationHelper.getLabel(key, lang));
            }
            all.put("translations", translations);
        }
        return DMJSONSerializer.makeJSON(all);
    }

    public void serialize(ResultSummary summary, List<DashBoardItem> workItems, String columnsDefinition, Response res, HttpServletRequest req) throws ClientException {
        this.serialize(summary, workItems, columnsDefinition, null, null, res, req);
    }

    @Override
    public void serialize(ResultSummary summary, List<DashBoardItem> workItems, String columnsDefinition, List<String> labels, String lang, Response res, HttpServletRequest req) throws ClientException {
        String json = this.serialize(summary, workItems, columnsDefinition, labels, lang);
        res.setEntity(json, MediaType.TEXT_PLAIN);
    }
}

