/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.serializer;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.syndication.serializer.ATOMSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.AbstractDocumentModelSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.DMJSONSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.RSSSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.syndication.serializer.SimpleXMLSerializer;
import org.nuxeo.ecm.platform.syndication.workflow.DashBoardItem;
import org.restlet.data.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializerHelper {
    private SerializerHelper() {
    }

    public static void formatResult(ResultSummary summary, DocumentModelList dmList, Response res, String format, String columnsDefinition, HttpServletRequest req) throws ClientException {
        SerializerHelper.formatResult(summary, dmList, res, format, columnsDefinition, req, null, null);
    }

    public static void formatResult(ResultSummary summary, DocumentModelList dmList, Response res, String format, String columnsDefinition, HttpServletRequest req, List<String> labels, String lang) throws ClientException {
        AbstractDocumentModelSerializer dms = format.equalsIgnoreCase("JSON") ? new DMJSONSerializer() : (format.equalsIgnoreCase("XML") ? new SimpleXMLSerializer() : (format.equalsIgnoreCase("RSS") ? new RSSSerializer() : (format.equalsIgnoreCase("ATOM") ? new ATOMSerializer() : new SimpleXMLSerializer())));
        if (lang != null) {
            dms.serialize(summary, dmList, columnsDefinition, res, req, labels, lang);
        } else {
            dms.serialize(summary, dmList, columnsDefinition, res, req);
        }
    }

    public static void formatResult(ResultSummary summary, List<DashBoardItem> tasks, Response response, String format, String columnsDefinition, HttpServletRequest req) throws ClientException {
        SerializerHelper.formatResult(summary, tasks, response, format, columnsDefinition, req, null, null);
    }

    public static void formatResult(ResultSummary summary, List<DashBoardItem> tasks, Response response, String format, String columnsDefinition, HttpServletRequest req, List<String> labels, String lang) throws ClientException {
        AbstractDocumentModelSerializer dis = format.equalsIgnoreCase("JSON") ? new DMJSONSerializer() : (format.equalsIgnoreCase("XML") ? new SimpleXMLSerializer() : (format.equalsIgnoreCase("ATOM") ? new ATOMSerializer() : new SimpleXMLSerializer()));
        dis.serialize(summary, tasks, columnsDefinition, labels, lang, response, req);
    }
}

