/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.vocabularies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nuxeo.ecm.platform.syndication.vocabularies.SimpleVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HierarchicalVocabulary {
    public static final Comparator<HierarchicalVocabulary> ORDER_BY_ID = new Comparator<HierarchicalVocabulary>(){

        @Override
        public int compare(HierarchicalVocabulary o1, HierarchicalVocabulary o2) {
            return o1.getVocabulary().getId().compareToIgnoreCase(o2.getVocabulary().getId());
        }
    };
    private final SimpleVocabulary simpleVocabulary;
    private final HierarchicalVocabulary parent;
    private final List<HierarchicalVocabulary> childs = new ArrayList<HierarchicalVocabulary>();
    private boolean sorted = false;

    public HierarchicalVocabulary(HierarchicalVocabulary parent, SimpleVocabulary vocabulary) {
        this.simpleVocabulary = vocabulary;
        this.parent = parent;
    }

    public void addChild(HierarchicalVocabulary voca) {
        this.childs.add(voca);
    }

    public void addChild(SimpleVocabulary voca) {
        this.addChild(new HierarchicalVocabulary(this, voca));
    }

    public void removeChild(HierarchicalVocabulary voca) {
        this.childs.remove(voca);
    }

    public HierarchicalVocabulary getParent() {
        return this.parent;
    }

    public SimpleVocabulary getVocabulary() {
        return this.simpleVocabulary;
    }

    public List<HierarchicalVocabulary> getChilds() {
        if (!this.sorted) {
            Collections.sort(this.childs, ORDER_BY_ID);
            this.sorted = true;
        }
        return Collections.unmodifiableList(this.childs);
    }

    public boolean hasParent() {
        return null != this.parent;
    }

    public boolean hasChilds() {
        return !this.childs.isEmpty();
    }
}

