/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.workflow;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;
import com.sun.syndication.io.impl.DateParser;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.nuxeo.ecm.platform.syndication.workflow.TaskModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskModuleGenerator
implements ModuleGenerator {
    private static final Namespace TASK_NS = Namespace.getNamespace((String)"task", (String)"http://nuxeo.org/module/task/1.0");
    private static final Set<Namespace> NAMESPACES;

    public String getNamespaceUri() {
        return "http://nuxeo.org/module/task/1.0";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)element.getParent();
        }
        root.addNamespaceDeclaration(TASK_NS);
        TaskModule tm = (TaskModule)module;
        if (tm.getDueDate() != null) {
            element.addContent((Content)TaskModuleGenerator.generateSimpleElement("dueDate", DateParser.formatW3CDateTime((Date)tm.getDueDate())));
        }
        if (tm.getStartDate() != null) {
            element.addContent((Content)TaskModuleGenerator.generateSimpleElement("startDate", DateParser.formatW3CDateTime((Date)tm.getStartDate())));
        }
        if (tm.getDirective() != null) {
            element.addContent((Content)TaskModuleGenerator.generateSimpleElement("directive", tm.getDirective()));
        }
        if (tm.getName() != null) {
            element.addContent((Content)TaskModuleGenerator.generateSimpleElement("name", tm.getName()));
        }
        if (tm.getDescription() != null) {
            element.addContent((Content)TaskModuleGenerator.generateSimpleElement("description", tm.getDescription()));
        }
        if (tm.getComment() != null) {
            element.addContent((Content)TaskModuleGenerator.generateSimpleElement("comment", tm.getComment()));
        }
    }

    protected static Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, TASK_NS);
        element.addContent(value);
        return element;
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(TASK_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

