/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class NoticeOfDisconnect
extends ExtendedResponseImpl {
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.1466.20036";
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    public static final NoticeOfDisconnect UNAVAILABLE = new NoticeOfDisconnect(ResultCodeEnum.UNAVAILABLE);
    public static final NoticeOfDisconnect PROTOCOLERROR = new NoticeOfDisconnect(ResultCodeEnum.PROTOCOL_ERROR);
    public static final NoticeOfDisconnect STRONGAUTHREQUIRED = new NoticeOfDisconnect(ResultCodeEnum.STRONG_AUTH_REQUIRED);

    private NoticeOfDisconnect(ResultCodeEnum rcode) {
        super(0, EXTENSION_OID);
        switch (rcode) {
            case UNAVAILABLE: {
                break;
            }
            case PROTOCOL_ERROR: {
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The result code can only be one of: " + (Object)((Object)ResultCodeEnum.UNAVAILABLE) + ", " + (Object)((Object)ResultCodeEnum.PROTOCOL_ERROR) + ", " + (Object)((Object)ResultCodeEnum.STRONG_AUTH_REQUIRED));
            }
        }
        super.getLdapResult().setErrorMessage("The server will disconnect!");
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public byte[] getResponse() {
        return EMPTY_RESPONSE;
    }

    public void setResponse(byte[] value) {
        throw new UnsupportedOperationException("the response is hardcoded as zero length array");
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException("the OID is fixed: 1.3.6.1.4.1.1466.20036");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof NoticeOfDisconnect;
    }
}

