/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.webengine.sites.AbstractSiteDocumentObject;
import org.nuxeo.webengine.sites.utils.SiteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebObject(type="WebPage", superType="AbstractSiteDocumentObject")
@Produces(value={"text/html;charset=UTF-8"})
public class Page
extends AbstractSiteDocumentObject {
    private static final Log log = LogFactory.getLog(Page.class);
    protected String pathSegment;

    public void initialize(Object ... args) {
        assert (args != null && args.length == 1);
        Object arg = args[0];
        if (arg instanceof String) {
            this.pathSegment = (String)arg;
        } else {
            this.doc = (DocumentModel)arg;
        }
    }

    @POST
    public Response doPost() {
        return null;
    }

    @Override
    @Path(value="{path}")
    public Resource traverse(@PathParam(value="path") String path) {
        return super.traverse(path);
    }

    @POST
    @Path(value="modifyWebPage")
    public Object modifyWebPage() {
        log.debug((Object)"Modifying web page ...");
        try {
            CoreSession session = this.ctx.getCoreSession();
            HttpServletRequest request = this.ctx.getRequest();
            String title = request.getParameter("title");
            String description = request.getParameter("description");
            Boolean isRichtext = SiteUtils.getBoolean(this.doc, "webp:isRichtext", false);
            String content = isRichtext != false ? request.getParameter("richtextEditorEdit") : request.getParameter("wikitextEditorEdit");
            String pushToMenu = request.getParameter("pushToMenu");
            this.doc.setPropertyValue("dc:title", (Serializable)((Object)title));
            this.doc.setPropertyValue("dc:description", (Serializable)((Object)description));
            this.doc.setPropertyValue("webp:content", (Serializable)((Object)content));
            this.doc.setPropertyValue("webp:pushtomenu", (Serializable)Boolean.valueOf(pushToMenu));
            session.saveDocument(this.doc);
            session.save();
            DocumentModel webContainer = SiteUtils.getFirstWebSiteParent(session, this.doc);
            String path = SiteUtils.getPagePath(webContainer, this.doc);
            return this.redirect(path);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Override
    protected String getSchemaFieldThemeName() {
        return "webp:theme";
    }

    @Override
    protected String getDefaultSchemaFieldThemeValue() {
        return "sites";
    }

    @Override
    protected String getSchemaFieldThemePageName() {
        return "webp:themePage";
    }

    @Override
    protected String getDefaultSchemaFieldThemePageValue() {
        return "page";
    }

    @Override
    protected Map<String, Object> getErrorArguments() {
        HashMap<String, Object> errorArguments = new HashMap<String, Object>();
        errorArguments.put("pageName", this.pathSegment);
        return errorArguments;
    }

    @Override
    protected String getErrorTemplateName() {
        return "error_create_page.ftl";
    }

    @Override
    protected String getSearchThemePage() {
        return "sites/search";
    }
}

