/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.fragments;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.fragments.AbstractFragment;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.models.ModelException;
import org.nuxeo.webengine.sites.models.TagListModel;
import org.nuxeo.webengine.sites.models.TagModel;
import org.nuxeo.webengine.sites.utils.SiteUtils;

public class TagFragment
extends AbstractFragment {
    public Model getModel() throws ModelException {
        TagListModel model = new TagListModel();
        try {
            DocumentModel documentModel;
            WebContext ctx;
            CoreSession session;
            List tags;
            TagService tagService = (TagService)Framework.getService(TagService.class);
            if (tagService != null && WebEngine.getActiveContext() != null && tagService.isEnabled() && (tags = tagService.listTagsAppliedOnDocument(session = (ctx = WebEngine.getActiveContext()).getCoreSession(), documentModel = (DocumentModel)ctx.getTargetObject().getAdapter(DocumentModel.class))) != null && !tags.isEmpty()) {
                for (Tag tag : tags) {
                    DocumentModel document = session.getDocument((DocumentRef)new IdRef(tag.tagId));
                    if (document.getCurrentLifeCycleState().equals("deleted")) continue;
                    String label = SiteUtils.getString(document, "tag:label", "");
                    Boolean isPrivate = SiteUtils.getNumber(document, "tag:private") != 0L;
                    boolean canModify = TagFragment.canModify(documentModel, label, tagService, session);
                    TagModel tagModel = new TagModel(label, isPrivate, canModify);
                    tagModel.setId(tag.tagId);
                    model.addItem((Model)tagModel);
                }
            }
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e);
        }
        return model;
    }

    private static boolean canModify(DocumentModel doc, String label, TagService tagService, CoreSession session) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)doc.getCoreSession().getPrincipal();
        if (principal.isAdministrator()) {
            return true;
        }
        String taggingId = tagService.getTaggingId(session, doc.getId(), label, principal.getName());
        return taggingId != null;
    }
}

