/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.resteasy.client.core.ClientInterceptor;
import org.jboss.resteasy.client.core.ClientInvoker;
import org.jboss.resteasy.client.core.ClientProxy;
import org.jboss.resteasy.spi.ProviderFactoryDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.IsHttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory {
    private static Collection<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();

    public static <T> T create(Class<T> clazz, String base) {
        return ProxyFactory.create(clazz, base, new HttpClient());
    }

    public static <T> T create(Class<T> clazz, String base, HttpClient client) {
        try {
            return ProxyFactory.create(clazz, new URI(base), client, ResteasyProviderFactory.getInstance());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T create(Class<T> clazz, URI baseUri, HttpClient httpClient, ResteasyProviderFactory providerFactory) {
        return ProxyFactory.create(clazz, baseUri, httpClient, providerFactory, interceptors);
    }

    public static <T> T create(Class<T> clazz, URI baseUri, HttpClient httpClient, ResteasyProviderFactory providerFactory, Collection<ClientInterceptor> interceptors) {
        HashMap<Method, ClientInvoker> methodMap = new HashMap<Method, ClientInvoker>();
        if (providerFactory instanceof ProviderFactoryDelegate) {
            providerFactory = ((ProviderFactoryDelegate)((Object)providerFactory)).getDelegate();
        }
        for (Method method : clazz.getMethods()) {
            ClientInvoker invoker = null;
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (httpMethods == null) {
                throw new RuntimeException("Method must be annotated with an http method annotation @GET, etc..");
            }
            if (httpMethods.size() != 1) {
                throw new RuntimeException("You may only annotate a method with only one http method annotation");
            }
            invoker = new ClientInvoker(clazz, method, providerFactory, httpClient, interceptors);
            invoker.setBaseUri(baseUri);
            invoker.setRestVerb(ProxyFactory.getRestVerb(httpMethods));
            methodMap.put(method, invoker);
        }
        Class[] intfs = new Class[]{clazz};
        ClientProxy clientProxy = new ClientProxy(methodMap);
        clientProxy.setClazz(clazz);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), intfs, (InvocationHandler)clientProxy);
    }

    private static String getRestVerb(Set<String> httpMethods) {
        if (httpMethods.contains("GET")) {
            return "GET";
        }
        if (httpMethods.contains("PUT")) {
            return "PUT";
        }
        if (httpMethods.contains("POST")) {
            return "POST";
        }
        if (httpMethods.contains("DELETE")) {
            return "DELETE";
        }
        throw new RuntimeException("@" + httpMethods.iterator().next() + " is not supported yet");
    }

    public static void addInterceptor(ClientInterceptor clientInterceptor) {
        interceptors.add(clientInterceptor);
    }
}

