/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.resteasy.client.core.ClientMarshallerFactory;
import org.jboss.resteasy.client.core.Marshaller;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class FormMarshaller
implements Marshaller {
    protected HashMap<Field, Marshaller> fieldMap = new HashMap();
    protected List<GetterMethod> setters = new ArrayList<GetterMethod>();
    protected HashMap<Long, Method> setterhashes = new HashMap();
    protected Class clazz;

    public FormMarshaller(Class clazz, ResteasyProviderFactory factory) {
        this.clazz = clazz;
        this.populateMap(clazz, factory);
    }

    public static long methodHash(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuffer methodDesc = new StringBuffer(method.getName() + "(");
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc.append(FormMarshaller.getTypeString(parameterTypes[j]));
        }
        methodDesc.append(")" + FormMarshaller.getTypeString(method.getReturnType()));
        return FormMarshaller.createHash(methodDesc.toString());
    }

    public static long createHash(String methodDesc) throws Exception {
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + FormMarshaller.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    protected void populateMap(Class clazz, ResteasyProviderFactory factory) {
        Type genericType;
        Class<?> type;
        Marshaller marshaller;
        Annotation[] annotations;
        for (Field field : clazz.getDeclaredFields()) {
            annotations = field.getAnnotations();
            if (annotations == null || annotations.length == 0 || (marshaller = ClientMarshallerFactory.createMarshaller(clazz, factory, type = field.getType(), annotations, genericType = field.getGenericType(), field, true)) == null) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            this.fieldMap.put(field, marshaller);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Method older;
            if (!((Method)accessibleObject).getName().startsWith("get") || ((Method)accessibleObject).getParameterTypes().length > 0 || (annotations = accessibleObject.getAnnotations()) == null || annotations.length == 0 || (marshaller = ClientMarshallerFactory.createMarshaller(clazz, factory, type = ((Method)accessibleObject).getReturnType(), annotations, genericType = ((Method)accessibleObject).getGenericReturnType(), accessibleObject, true)) == null) continue;
            long hash = 0L;
            try {
                hash = FormMarshaller.methodHash((Method)accessibleObject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!Modifier.isPrivate(((Method)accessibleObject).getModifiers()) && (older = this.setterhashes.get(hash)) != null) continue;
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers())) {
                ((Method)accessibleObject).setAccessible(true);
            }
            this.setters.add(new GetterMethod((Method)accessibleObject, marshaller));
            this.setterhashes.put(hash, (Method)accessibleObject);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            this.populateMap(clazz.getSuperclass(), factory);
        }
    }

    public void buildUri(Object object, UriBuilderImpl uri) {
        Object val;
        for (Map.Entry<Field, Marshaller> entry : this.fieldMap.entrySet()) {
            try {
                val = entry.getKey().get(object);
                entry.getValue().buildUri(val, uri);
            }
            catch (IllegalAccessException e) {
                throw new LoggableFailure(e);
            }
        }
        for (GetterMethod setter : this.setters) {
            val = null;
            try {
                val = setter.method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            setter.marshaller.buildUri(val, uri);
        }
    }

    public void setHeaders(Object object, HttpMethodBase httpMethod) {
        Object val;
        for (Map.Entry<Field, Marshaller> entry : this.fieldMap.entrySet()) {
            try {
                val = entry.getKey().get(object);
                entry.getValue().setHeaders(val, httpMethod);
            }
            catch (IllegalAccessException e) {
                throw new LoggableFailure(e);
            }
        }
        for (GetterMethod setter : this.setters) {
            val = null;
            try {
                val = setter.method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            setter.marshaller.setHeaders(val, httpMethod);
        }
    }

    public void buildRequest(Object object, HttpMethodBase httpMethod) {
        Object val;
        for (Map.Entry<Field, Marshaller> entry : this.fieldMap.entrySet()) {
            try {
                val = entry.getKey().get(object);
                entry.getValue().buildRequest(val, httpMethod);
            }
            catch (IllegalAccessException e) {
                throw new LoggableFailure(e);
            }
        }
        for (GetterMethod setter : this.setters) {
            val = null;
            try {
                val = setter.method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            setter.marshaller.buildRequest(val, httpMethod);
        }
    }

    private static class GetterMethod {
        public Method method;
        public Marshaller marshaller;

        private GetterMethod(Method method, Marshaller marshaller) {
            this.method = method;
            this.marshaller = marshaller;
        }
    }
}

