/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.core.LoggerCategories;
import org.jboss.resteasy.plugins.providers.ByteArrayProvider;
import org.jboss.resteasy.plugins.providers.DataSourceProvider;
import org.jboss.resteasy.plugins.providers.DefaultTextPlain;
import org.jboss.resteasy.plugins.providers.FileProvider;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.plugins.providers.InputStreamProvider;
import org.jboss.resteasy.plugins.providers.StreamingOutputProvider;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;

public class RegisterBuiltin {
    private static final Logger logger = LoggerCategories.getProviderLogger();

    public static void register(ResteasyProviderFactory factory) {
        if (factory.isBuiltinsRegistered()) {
            return;
        }
        logger.debug("Registering standard providers");
        DataSourceProvider dataSourceProvider = new DataSourceProvider();
        factory.addBuiltInMessageBodyReader(dataSourceProvider);
        factory.addBuiltInMessageBodyWriter(dataSourceProvider);
        logger.info("Added built in provider {}", (Object)dataSourceProvider.getClass().getSimpleName());
        DefaultTextPlain plainText = new DefaultTextPlain();
        factory.addBuiltInMessageBodyReader(plainText);
        factory.addBuiltInMessageBodyWriter(plainText);
        logger.info("Added built in provider {}", (Object)plainText.getClass().getSimpleName());
        StringTextStar stringTextStar = new StringTextStar();
        factory.addBuiltInMessageBodyReader(stringTextStar);
        factory.addBuiltInMessageBodyWriter(stringTextStar);
        logger.info("Added built in provider {}", (Object)StringTextStar.class.getName());
        InputStreamProvider inputStreamProvider = new InputStreamProvider();
        factory.addBuiltInMessageBodyReader(inputStreamProvider);
        factory.addBuiltInMessageBodyWriter(inputStreamProvider);
        logger.info("Added built in provider {}", (Object)InputStreamProvider.class.getName());
        ByteArrayProvider byteArrayProvider = new ByteArrayProvider();
        factory.addBuiltInMessageBodyReader(byteArrayProvider);
        factory.addBuiltInMessageBodyWriter(byteArrayProvider);
        logger.info("Added built in provider {}", (Object)ByteArrayProvider.class.getName());
        FormUrlEncodedProvider formProvider = new FormUrlEncodedProvider();
        factory.addBuiltInMessageBodyReader(formProvider);
        factory.addBuiltInMessageBodyWriter(formProvider);
        logger.info("Added built in provider {}", (Object)FormUrlEncodedProvider.class.getName());
        FileProvider fileProvider = new FileProvider();
        factory.addBuiltInMessageBodyReader(fileProvider);
        factory.addBuiltInMessageBodyWriter(fileProvider);
        logger.info("Added built in provider {}", (Object)FormUrlEncodedProvider.class.getName());
        factory.addBuiltInMessageBodyWriter(new StreamingOutputProvider());
        logger.info("Added built in provider {}", (Object)StreamingOutputProvider.class.getName());
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlSeeAlsoProvider", "org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlSeeAlsoProvider", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlRootElementProvider", "org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlRootElementProvider", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.jaxb.JAXBElementProvider", "org.jboss.resteasy.plugins.providers.jaxb.JAXBElementProvider", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlTypeProvider", "org.jboss.resteasy.plugins.providers.jaxb.JAXBXmlTypeProvider", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.jaxb.CollectionProvider", "org.jboss.resteasy.plugins.providers.jaxb.CollectionProvider", factory);
        RegisterBuiltin.optionalContextResolver("org.jboss.resteasy.plugins.providers.jaxb.XmlJAXBContextFinder", "org.jboss.resteasy.plugins.providers.jaxb.XmlJAXBContextFinder", factory);
        RegisterBuiltin.optionalReader("org.jboss.resteasy.plugins.providers.multipart.MultipartReader", "org.jboss.resteasy.plugins.providers.multipart.MultipartReader", factory);
        RegisterBuiltin.optionalReader("org.jboss.resteasy.plugins.providers.multipart.ListMultipartReader", "org.jboss.resteasy.plugins.providers.multipart.ListMultipartReader", factory);
        RegisterBuiltin.optionalReader("org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataReader", "org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataReader", factory);
        RegisterBuiltin.optionalReader("org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataReader", "org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataReader", factory);
        RegisterBuiltin.optionalWriter("org.jboss.resteasy.plugins.providers.multipart.MultipartWriter", "org.jboss.resteasy.plugins.providers.multipart.MultipartWriter", factory);
        RegisterBuiltin.optionalWriter("org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataWriter", "org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataWriter", factory);
        RegisterBuiltin.optionalWriter("org.jboss.resteasy.plugins.providers.multipart.ListMultipartWriter", "org.jboss.resteasy.plugins.providers.multipart.ListMultipartWriter", factory);
        RegisterBuiltin.optionalWriter("org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataWriter", "org.jboss.resteasy.plugins.providers.multipart.MapMultipartFormDataWriter", factory);
        RegisterBuiltin.optionalReader("org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationReader", "org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationReader", factory);
        RegisterBuiltin.optionalWriter("org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationWriter", "org.jboss.resteasy.plugins.providers.multipart.MultipartFormAnnotationWriter", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.atom.AtomFeedProvider", "org.jboss.resteasy.plugins.providers.atom.AtomFeedProvider", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.atom.AtomEntryProvider", "org.jboss.resteasy.plugins.providers.atom.AtomEntryProvider", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.IIOImageProvider", "org.jboss.resteasy.plugins.providers.IIOImageProvider", factory);
        RegisterBuiltin.optionalContextResolver("org.jboss.resteasy.plugins.providers.jaxb.json.JsonJAXBContextFinder", "org.jboss.resteasy.plugins.providers.jaxb.json.JsonJAXBContextFinder", factory);
        RegisterBuiltin.optionalContextResolver("org.jboss.resteasy.plugins.providers.jaxb.fastinfoset.FastinfoSetJAXBContextFinder", "org.jboss.resteasy.plugins.providers.jaxb.fastinfoset.FastinfoSetJAXBContextFinder", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.multipart.MimeMultipartProvider", "org.jboss.resteasy.plugins.providers.multipart.MimeMultipartProvider", factory);
        RegisterBuiltin.optionalProvider("org.jboss.resteasy.plugins.providers.YamlProvider", "org.jboss.resteasy.plugins.providers.YamlProvider", factory);
        factory.setBuiltinsRegistered(true);
    }

    private static void optionalProvider(String dependency, String providerClass, ResteasyProviderFactory factory) {
        if (RegisterBuiltin.isAvailable(dependency)) {
            logger.info("Adding built in provider " + providerClass);
            Object provider = RegisterBuiltin.instantiate(providerClass);
            factory.addBuiltInMessageBodyReader((MessageBodyReader)provider);
            factory.addBuiltInMessageBodyWriter((MessageBodyWriter)provider);
        }
    }

    private static void optionalReader(String dependency, String providerClass, ResteasyProviderFactory factory) {
        if (RegisterBuiltin.isAvailable(dependency)) {
            logger.info("Adding built in provider " + providerClass);
            Object provider = RegisterBuiltin.instantiate(providerClass);
            factory.addBuiltInMessageBodyReader((MessageBodyReader)provider);
        }
    }

    private static void optionalWriter(String dependency, String providerClass, ResteasyProviderFactory factory) {
        if (RegisterBuiltin.isAvailable(dependency)) {
            logger.info("Adding built in provider" + providerClass);
            Object provider = RegisterBuiltin.instantiate(providerClass);
            factory.addBuiltInMessageBodyWriter((MessageBodyWriter)provider);
        }
    }

    private static void optionalContextResolver(String dependency, String providerClass, ResteasyProviderFactory factory) {
        if (RegisterBuiltin.isAvailable(dependency)) {
            logger.info("Adding built in provider " + providerClass);
            factory.registerProviderInstance(RegisterBuiltin.instantiate(providerClass));
        }
    }

    private static boolean isAvailable(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private static Object instantiate(String className) {
        try {
            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(className);
            return cl.newInstance();
        }
        catch (Exception e) {
            logger.error("Failed to load: " + className, (Throwable)e);
            return null;
        }
    }
}

